/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.AbstractAuthenticationManager;
import org.springframework.security.AccountStatusException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.concurrent.ConcurrentLoginException;
import org.springframework.security.concurrent.ConcurrentSessionController;
import org.springframework.security.concurrent.NullConcurrentSessionController;
import org.springframework.security.event.authentication.AbstractAuthenticationEvent;
import org.springframework.security.event.authentication.AuthenticationSuccessEvent;
import org.springframework.security.providers.AbstractAuthenticationToken;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.ProviderNotFoundException;
import org.springframework.util.Assert;

public class ProviderManager
extends AbstractAuthenticationManager
implements InitializingBean,
MessageSourceAware,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$providers$ProviderManager == null ? (class$org$springframework$security$providers$ProviderManager = ProviderManager.class$("org.springframework.security.providers.ProviderManager")) : class$org$springframework$security$providers$ProviderManager));
    private static final Properties DEFAULT_EXCEPTION_MAPPINGS = new Properties();
    private ApplicationEventPublisher applicationEventPublisher;
    private ConcurrentSessionController sessionController = new NullConcurrentSessionController();
    private List providers;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private Properties exceptionMappings = new Properties();
    private Properties additionalExceptionMappings = new Properties();
    static /* synthetic */ Class class$org$springframework$security$providers$ProviderManager;
    static /* synthetic */ Class class$org$springframework$security$AccountExpiredException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureExpiredEvent;
    static /* synthetic */ Class class$org$springframework$security$AuthenticationServiceException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureServiceExceptionEvent;
    static /* synthetic */ Class class$org$springframework$security$LockedException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureLockedEvent;
    static /* synthetic */ Class class$org$springframework$security$CredentialsExpiredException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureCredentialsExpiredEvent;
    static /* synthetic */ Class class$org$springframework$security$DisabledException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureDisabledEvent;
    static /* synthetic */ Class class$org$springframework$security$BadCredentialsException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureBadCredentialsEvent;
    static /* synthetic */ Class class$org$springframework$security$userdetails$UsernameNotFoundException;
    static /* synthetic */ Class class$org$springframework$security$concurrent$ConcurrentLoginException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureConcurrentLoginEvent;
    static /* synthetic */ Class class$org$springframework$security$providers$ProviderNotFoundException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureProviderNotFoundEvent;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AuthenticationFailureProxyUntrustedEvent;
    static /* synthetic */ Class class$org$springframework$security$Authentication;
    static /* synthetic */ Class class$org$springframework$security$AuthenticationException;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$AbstractAuthenticationEvent;
    static /* synthetic */ Class class$org$springframework$security$providers$AuthenticationProvider;

    public ProviderManager() {
        ((Hashtable)this.exceptionMappings).putAll(DEFAULT_EXCEPTION_MAPPINGS);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        ((Hashtable)this.exceptionMappings).putAll(this.additionalExceptionMappings);
    }

    public Authentication doAuthentication(Authentication authentication) throws AuthenticationException {
        Iterator iter = this.getProviders().iterator();
        Class<?> toTest = authentication.getClass();
        AuthenticationException lastException = null;
        while (iter.hasNext()) {
            Authentication result;
            AuthenticationProvider provider = (AuthenticationProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
            try {
                result = provider.authenticate(authentication);
                if (result != null) {
                    this.copyDetails(authentication, result);
                    this.sessionController.checkAuthenticationAllowed(result);
                }
            }
            catch (AuthenticationException ae) {
                lastException = ae;
                result = null;
            }
            if (lastException instanceof AccountStatusException || lastException instanceof ConcurrentLoginException) break;
            if (result == null) continue;
            this.sessionController.registerSuccessfulAuthentication(result);
            this.publishEvent(new AuthenticationSuccessEvent(result));
            return result;
        }
        if (lastException == null) {
            lastException = new ProviderNotFoundException(this.messages.getMessage("ProviderManager.providerNotFound", new Object[]{toTest.getName()}, "No AuthenticationProvider found for {0}"));
        }
        this.publishAuthenticationFailure(lastException, authentication);
        throw lastException;
    }

    private void publishAuthenticationFailure(AuthenticationException exception, Authentication authentication) {
        String className = this.exceptionMappings.getProperty(((Object)((Object)exception)).getClass().getName());
        AbstractAuthenticationEvent event = null;
        if (className != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(class$org$springframework$security$Authentication == null ? (class$org$springframework$security$Authentication = ProviderManager.class$("org.springframework.security.Authentication")) : class$org$springframework$security$Authentication, class$org$springframework$security$AuthenticationException == null ? (class$org$springframework$security$AuthenticationException = ProviderManager.class$("org.springframework.security.AuthenticationException")) : class$org$springframework$security$AuthenticationException);
                Object obj = constructor.newInstance(new Object[]{authentication, exception});
                Assert.isInstanceOf((Class)(class$org$springframework$security$event$authentication$AbstractAuthenticationEvent == null ? (class$org$springframework$security$event$authentication$AbstractAuthenticationEvent = ProviderManager.class$("org.springframework.security.event.authentication.AbstractAuthenticationEvent")) : class$org$springframework$security$event$authentication$AbstractAuthenticationEvent), obj, (String)"Must be an AbstractAuthenticationEvent");
                event = (AbstractAuthenticationEvent)((Object)obj);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
        }
        if (event != null) {
            this.publishEvent(event);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No event was found for the exception " + ((Object)((Object)exception)).getClass().getName()));
        }
    }

    private void copyDetails(Authentication source, Authentication dest) {
        if (dest instanceof AbstractAuthenticationToken && dest.getDetails() == null) {
            AbstractAuthenticationToken token = (AbstractAuthenticationToken)dest;
            token.setDetails(source.getDetails());
        }
    }

    public List getProviders() {
        if (this.providers == null || this.providers.size() == 0) {
            throw new IllegalArgumentException("A list of AuthenticationProviders is required");
        }
        return this.providers;
    }

    public ConcurrentSessionController getSessionController() {
        return this.sessionController;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setProviders(List providers) {
        Assert.notEmpty((Collection)providers, (String)"A list of AuthenticationProviders is required");
        Iterator iter = providers.iterator();
        while (iter.hasNext()) {
            Object currentObject = iter.next();
            Assert.isInstanceOf((Class)(class$org$springframework$security$providers$AuthenticationProvider == null ? ProviderManager.class$("org.springframework.security.providers.AuthenticationProvider") : class$org$springframework$security$providers$AuthenticationProvider), currentObject, (String)"Can only provide AuthenticationProvider instances");
        }
        this.providers = providers;
    }

    public void setSessionController(ConcurrentSessionController sessionController) {
        this.sessionController = sessionController;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent(event);
        }
    }

    public void setAdditionalExceptionMappings(Properties additionalExceptionMappings) {
        this.additionalExceptionMappings = additionalExceptionMappings;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$AccountExpiredException == null ? (class$org$springframework$security$AccountExpiredException = ProviderManager.class$("org.springframework.security.AccountExpiredException")) : class$org$springframework$security$AccountExpiredException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureExpiredEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureExpiredEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureExpiredEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureExpiredEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$AuthenticationServiceException == null ? (class$org$springframework$security$AuthenticationServiceException = ProviderManager.class$("org.springframework.security.AuthenticationServiceException")) : class$org$springframework$security$AuthenticationServiceException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureServiceExceptionEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureServiceExceptionEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureServiceExceptionEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureServiceExceptionEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$LockedException == null ? (class$org$springframework$security$LockedException = ProviderManager.class$("org.springframework.security.LockedException")) : class$org$springframework$security$LockedException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureLockedEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureLockedEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureLockedEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureLockedEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$CredentialsExpiredException == null ? (class$org$springframework$security$CredentialsExpiredException = ProviderManager.class$("org.springframework.security.CredentialsExpiredException")) : class$org$springframework$security$CredentialsExpiredException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureCredentialsExpiredEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureCredentialsExpiredEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureCredentialsExpiredEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureCredentialsExpiredEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$DisabledException == null ? (class$org$springframework$security$DisabledException = ProviderManager.class$("org.springframework.security.DisabledException")) : class$org$springframework$security$DisabledException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureDisabledEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureDisabledEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureDisabledEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureDisabledEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$BadCredentialsException == null ? (class$org$springframework$security$BadCredentialsException = ProviderManager.class$("org.springframework.security.BadCredentialsException")) : class$org$springframework$security$BadCredentialsException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureBadCredentialsEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureBadCredentialsEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureBadCredentialsEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureBadCredentialsEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$userdetails$UsernameNotFoundException == null ? (class$org$springframework$security$userdetails$UsernameNotFoundException = ProviderManager.class$("org.springframework.security.userdetails.UsernameNotFoundException")) : class$org$springframework$security$userdetails$UsernameNotFoundException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureBadCredentialsEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureBadCredentialsEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureBadCredentialsEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureBadCredentialsEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$concurrent$ConcurrentLoginException == null ? (class$org$springframework$security$concurrent$ConcurrentLoginException = ProviderManager.class$("org.springframework.security.concurrent.ConcurrentLoginException")) : class$org$springframework$security$concurrent$ConcurrentLoginException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureConcurrentLoginEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureConcurrentLoginEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureConcurrentLoginEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureConcurrentLoginEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put((class$org$springframework$security$providers$ProviderNotFoundException == null ? (class$org$springframework$security$providers$ProviderNotFoundException = ProviderManager.class$("org.springframework.security.providers.ProviderNotFoundException")) : class$org$springframework$security$providers$ProviderNotFoundException).getName(), (class$org$springframework$security$event$authentication$AuthenticationFailureProviderNotFoundEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureProviderNotFoundEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureProviderNotFoundEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureProviderNotFoundEvent).getName());
        ((Hashtable)DEFAULT_EXCEPTION_MAPPINGS).put("org.springframework.security.providers.cas.ProxyUntrustedException", (class$org$springframework$security$event$authentication$AuthenticationFailureProxyUntrustedEvent == null ? (class$org$springframework$security$event$authentication$AuthenticationFailureProxyUntrustedEvent = ProviderManager.class$("org.springframework.security.event.authentication.AuthenticationFailureProxyUntrustedEvent")) : class$org$springframework$security$event$authentication$AuthenticationFailureProxyUntrustedEvent).getName());
    }
}

