#!/bin/sh
# $NetBSD: $
# FreeBSD: src/sys/i386/acpica/genwakecode.sh,v 1.1 2002/05/01 21:52:34 peter Exp $
echo '/* THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT. */'
echo -n '/* $'
echo 'NetBSD: $ */'
echo

nm -n acpi_wakecode.o | while read offset dummy what
do
    if [ x"${offset}" = x"U" ]; then
	echo error: undefined symbol \"${dummy}\". 1>&2
	exit 1
    fi
    case $dummy in
    t)
	echo "#define	${what}	0x${offset}"
	;;
    *)
	;;
    esac
    true
done || exit 1

echo 
echo 'static char wakecode[] = {';
hexdump -Cv < acpi_wakecode.bin | \
    sed -e 's/^[0-9a-f][0-9a-f]*//' -e 's/\|.*$//' | \
    while read line
    do
	for code in ${line}
	do
	    echo -n "0x${code},";
	done
    done
echo '};'

exit 0
