/*
 * Author: anonymous
 * Public Domain
 */
#include <linux/ps2/dev.h>
#include <asm/addrspace.h>

#define SCREEN_W        640
#define FONT_W          8
#define FONT_H          16

#define D2_CHCR         ((volatile unsigned int *)0xb000a000)
#define D2_MADR         ((volatile unsigned int *)0xb000a010)
#define D2_QWC          ((volatile unsigned int *)0xb000a020)

extern unsigned char fontdata_8x16[];

static unsigned long long packet[12 + (FONT_W * FONT_H * 4 / 8)] __attribute__((aligned(16))) = {
    PS2_GIFTAG_SET_TOPHALF(4, 0, 0, 0, PS2_GIFTAG_FLG_PACKED, 1),
    0xe,
    PS2_GS_SETREG_BITBLTBUF(0, 0, 0, 0, SCREEN_W / 64, PS2_GS_PSMCT32),
    PS2_GS_BITBLTBUF,
    PS2_GS_SETREG_TRXPOS(0, 0, 100, 100, 0),
    PS2_GS_TRXPOS,
    PS2_GS_SETREG_TRXREG(FONT_W, FONT_H),
    PS2_GS_TRXREG,
    PS2_GS_SETREG_TRXDIR(0),
    PS2_GS_TRXDIR,
    PS2_GIFTAG_SET_TOPHALF(FONT_W * FONT_H * 4 / 16, 1, 0, 0, PS2_GIFTAG_FLG_IMAGE, 0),
    0,
};

void putc_xy(int c, int x, int y)
{
    unsigned long long *pp = KSEG1ADDR((unsigned long long *)packet);
    unsigned long *pl;
    unsigned char *fp;
    int i, j, b;

    pp[4] = PS2_GS_SETREG_TRXPOS(0, 0, x, y, 0);
    pl = (unsigned long *)&pp[12];
    fp = &fontdata_8x16[(c & 0xff) * FONT_H];
    for (i = 0; i < FONT_H; i++)
	for (j = 0, b = *fp++; j < FONT_W; j++, b <<= 1)
            *pl++ = (b & 0x80) ? 0xffffff : 0;

    *D2_MADR = PHYSADDR((unsigned int)pp);
    *D2_QWC = sizeof(packet) / 16;
    *D2_CHCR = 0x0101;
    while ((*D2_CHCR & 0x0100) != 0)
	;
}

int kernel_entry(void)
{
    int i, j, c;

    *(volatile unsigned int *)0xb2000000 = 0xffa5;

    for (i = 0; i < 30; i++)
        for (j = 0; j < 80; j++)
            putc_xy(c++ & 0x7f, j * FONT_W, i * FONT_H);

    while (1)
	;
}
