// Copyright (C) 2001  Sony Computer Entertainment Inc.
// 
// "mathfunc.h"
// 
// 
#ifndef _MATHFUNC_H_
#define _MATHFUNC_H_

typedef int ps2Samp0IVECTOR[4] __attribute__((aligned (16)));
typedef float ps2Samp0FVECTOR[4] __attribute__((aligned (16)));
typedef float ps2Samp0FMATRIX[4][4] __attribute__((aligned (16)));

// prototypes
void ps2Samp0DumpVector(char *s, ps2Samp0FVECTOR v);
void ps2Samp0DumpMatrix(char *s, ps2Samp0FMATRIX m);
void ps2Samp0CopyVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1);
void ps2Samp0FTOI0Vector(ps2Samp0IVECTOR v0, ps2Samp0FVECTOR v1);
void ps2Samp0ITOF0Vector(ps2Samp0FVECTOR v0, ps2Samp0IVECTOR v1);
void ps2Samp0ScaleVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, float s);
void ps2Samp0AddVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2);
void ps2Samp0SubVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2);
void ps2Samp0MulVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2);
float ps2Samp0InnerProduct(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1);
void ps2Samp0OuterProduct(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2);
void ps2Samp0Normalize(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1);
void ps2Samp0ApplyMatrix(ps2Samp0FVECTOR v0, ps2Samp0FMATRIX m, ps2Samp0FVECTOR v1);
void ps2Samp0UnitMatrix(ps2Samp0FMATRIX m);
void ps2Samp0CopyMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1);
void ps2Samp0TransposeMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1);
void ps2Samp0MulMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FMATRIX m2);
void ps2Samp0InversMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1);
void ps2Samp0RotMatrixX(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float rx);
void ps2Samp0RotMatrixY(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float ry);
void ps2Samp0RotMatrixZ(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float rz);
void ps2Samp0RotMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FVECTOR rot);
void ps2Samp0TransMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FVECTOR tv);
void ps2Samp0CameraMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR p, ps2Samp0FVECTOR zd, ps2Samp0FVECTOR yd);
void ps2Samp0RotCameraMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR p, ps2Samp0FVECTOR zd, ps2Samp0FVECTOR yd, ps2Samp0FVECTOR rot);
void ps2Samp0NormalLightMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR l0, ps2Samp0FVECTOR l1, ps2Samp0FVECTOR l2);
void ps2Samp0NormalColorVector(ps2Samp0IVECTOR c0, ps2Samp0FMATRIX local_light, ps2Samp0FMATRIX light_color,
				ps2Samp0FVECTOR v0, ps2Samp0FVECTOR c1);
void ps2Samp0LightColorMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR c0, 
				ps2Samp0FVECTOR c1, ps2Samp0FVECTOR c2, ps2Samp0FVECTOR a);
void ps2Samp0ViewScreenMatrix(ps2Samp0FMATRIX m, float scrz, float ax, float ay, 
	float cx, float cy, float zmin, float zmax, float nearz, float farz);
void ps2Samp0ClampVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, float min, float max);
float ps2Samp0RotTransPers(ps2Samp0IVECTOR v0, ps2Samp0FMATRIX m0, ps2Samp0FVECTOR v1, int mode);

#endif // _MATHFUNC_H_
