#include <linux/string.h>
#include <linux/types.h>

//AES key table
static unsigned char g_AESkey_default[] = {
0xAD,0x93,0x00,0xC4,0x8E,0x50,0x20,0xC5,0x3F,0xBF,0x23,0x32,0x80,0x5A,0xC6,0xDF,
0x2F,0x7D,0x49,0xD9,0x15,0x8B,0x7F,0x04,0x2C,0x80,0xB0,0x62,0x78,0x25,0x8D,0x9C,
0x13,0x22,0x02,0x4A,0x55,0x23,0xBB,0xCB,0xF1,0xFB,0x2A,0xCC,0xBB,0x95,0xF4,0x50,
0xAE,0x08,0xD7,0xFB,0x80,0xF2,0x64,0x72,0xE3,0x3C,0xC4,0xB4,0xA3,0x50,0xD9,0xF1,
0x2A,0xDE,0xFC,0xD7,0x67,0xC8,0xDE,0xD0,0xF0,0x1E,0xE8,0x12,0xF9,0x57,0x25,0x36,
0x6D,0x71,0xD2,0xF8,0x1E,0x32,0x25,0x59,0x89,0x80,0xA3,0x59,0xD4,0xB6,0xDA,0x00,
0x8D,0xB8,0x5B,0x95,0x96,0x47,0x07,0xBD,0xED,0x68,0xDF,0xB9,0xD5,0x93,0x34,0x8F,
0xC6,0x66,0x06,0x64,0x94,0xCC,0x27,0x29,0x3A,0x8F,0x58,0x2E,0x70,0x7D,0x22,0xE7,
0x9D,0x62,0xAA,0xD1,0x0C,0xD2,0xD7,0x76,0xBD,0x40,0xCD,0x87,0x4E,0xC8,0x4C,0x80,
0x86,0xC2,0xB8,0x97,0xA3,0xDC,0x8F,0x8C,0x45,0xCC,0x26,0x40,0xBD,0xEB,0x3F,0xAF,
0x55,0x1E,0x88,0xFC,0x38,0xC0,0x06,0x1C,0xDA,0xDB,0xE4,0xFA,0x2B,0xFB,0x6D,0x6F,
0x19,0x62,0x0A,0xC4,0xEA,0xF0,0xE3,0x47,0xDB,0x47,0x83,0xE8,0x50,0x17,0xDF,0xA8,
0x29,0x37,0xB4,0x0A,0x19,0x1B,0x2D,0xDB,0x86,0xC8,0xBB,0xD1,0x52,0xD5,0x8F,0xC8,
0x2B,0xBC,0xE7,0x8A,0xF4,0xA1,0xE2,0x4D,0xAC,0xFC,0xB2,0x6F,0xDA,0x82,0xAB,0x86,
0xB7,0x95,0x6B,0xD7,0xA9,0x07,0xC7,0xB8,0x2D,0xBF,0x86,0xB4,0xBF,0xF4,0xC8,0xFD,
0x50,0x43,0xEB,0x8D,0xAB,0x16,0x91,0xBB,0x6B,0x5E,0x60,0x21,0x57,0x44,0x61,0x06,
};

extern int aes256_algorithm_encrypt(uint8_t data[16], uint8_t *key,int keylen);
extern int aes256_algorithm_decrypt(uint8_t data[16], uint8_t *key,int keylen);

/* function: aml_algorithm_aes_enc_dec
 * encFlag: 1: encrypt, 0:decrypt
 * out: 
 * outlen: 
 * in:
 * inlen: 16byte align
 * */
int aml_algorithm_aes_enc_dec(int encFlag,unsigned char *out,int *outlen,unsigned char *in,int inlen)
{
	int ret=-1;
	uint8_t blk_buf[16];
	uint8_t *key;
	int keylen;
	int blklen;
	if(!out || !outlen || !in){
		return ret;
	}
	if(*outlen < inlen){
		return ret;
	}
	blklen=16;
	if(inlen & (blklen-1)){
		return ret;
	}
	memset(out,0,inlen);
	key = g_AESkey_default;
	keylen = sizeof(g_AESkey_default);
	if(keylen > 14*16){
		keylen = 14*16;
	}
	*outlen = 0;
	do{
		memset(blk_buf,0,blklen);
		memcpy(blk_buf,in,blklen);
		if(encFlag){
			aes256_algorithm_encrypt(blk_buf,key,keylen);
		}
		else{
			aes256_algorithm_decrypt(blk_buf,key,keylen);
		}
		memcpy(out,blk_buf,blklen);
		out+=blklen;
		in+=blklen;
		*outlen += blklen;
	}while(inlen != *outlen);
	return 0;
}


