#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Master of Orion 2
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251014.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='master-of-orion-2'
GAME_NAME='Master of Orion II: Battle at Antares'

ARCHIVE_BASE_EN_0_NAME='gog_master_of_orion_2_2.0.0.6.sh'
ARCHIVE_BASE_EN_0_MD5='51529fd6734bc12f1ac36fea5fc547f8'
ARCHIVE_BASE_EN_0_SIZE='350000'
ARCHIVE_BASE_EN_0_VERSION='1.31-gog2.0.0.6'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/master_of_orion_1_2'

ARCHIVE_BASE_FR_0_NAME='gog_master_of_orion_2_french_2.0.0.6.sh'
ARCHIVE_BASE_FR_0_MD5='06d643ee04387914738707d435e8f7a6'
ARCHIVE_BASE_FR_0_SIZE='370000'
ARCHIVE_BASE_FR_0_VERSION='1.31-gog2.0.0.6'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/master_of_orion_1_2'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
SAMPLE.AD
SAMPLE.BNK
SAMPLE.CAT
SETSOUND.EXE
DIG.INI
MDI.INI
ORIONCD.INI
AMEBAFIN.LBX
ANATKFIN.LBX
ANTARMSG.LBX
ANTAROOM.LBX
APP_PICS.LBX
BEAMS.LBX
BILLTEX2.LBX
BILLTEXT.LBX
BLDG0.LBX
BLDG1.LBX
BLDG2.LBX
BLDG3.LBX
BLDG4.LBX
BLDG5.LBX
BUFFER0.LBX
CMBTFGTR.LBX
CMBTMISL.LBX
CMBTPLNT.LBX
CMBTSFX.LBX
COLBLDG.LBX
COLGCBT.LBX
COLONY2.LBX
COLONY.LBX
COLPUPS.LBX
COLPUSP.LBX
COLREFIT.LBX
COLROADS.LBX
COLSUM.LBX
COLSYSDI.LBX
COLVEGGI.LBX
COMBAT.LBX
CONFIRM.LBX
COUNCMSG.LBX
CREDITS.LBX
CUSTMSTR.LBX
DESIGN.LBX
DIMTVFIN.LBX
DIPLOMSE.LBX
DIPSTARS.LBX
ENGMSG.LBX
ESTRINGS.LBX
EVENTMSE.LBX
EVENTS.LBX
FIREPTS.LBX
FLEET.LBX
FLTICONS.LBX
FONTS.LBX
GAME.LBX
GENWINFN.LBX
GSTAR.LBX
HERODATA.LBX
INBOX.LBX
INFO.LBX
INTRO.LBX
JIMTEXT2.LBX
JIMTEXT.LBX
KENTEXT1.LBX
KENTEXT.LBX
LOADSAVE.LBX
LOGO.LBX
MAINMENU.LBX
MAINPUPS.LBX
MAINTEXT.LBX
MONSTER.LBX
MSGENG.LBX
MULTIGM.LBX
NDATA.LBX
NEWGAME.LBX
NEXTPLYR.LBX
OCPOL.LBX
OFFICER.LBX
ORIONFIN.LBX
PATCH13.LBX
PLANETS.LBX
PLAYSPEC.LBX
PLNTDFIN.LBX
PLNTSUM.LBX
RACEICON.LBX
RACENAME.LBX
RACEOPT.LBX
RACERPRT.LBX
RACESEL.LBX
RACES.LBX
RACESTUF.LBX
REFITPUP.LBX
RSTRING0.LBX
SCIENCE.LBX
SCORE.LBX
SHIPNAME.LBX
SHIPS.LBX
SKILDESC.LBX
SOUND.LBX
SPHERSFX.LBX
SR_R0_SC.LBX
SR_R0_SP.LBX
SR_R0_TR.LBX
SR_R1_SC.LBX
SR_R1_SP.LBX
SR_R1_TR.LBX
SR_R2_SC.LBX
SR_R2_SP.LBX
SR_R2_TR.LBX
SR_R3_SC.LBX
SR_R3_SP.LBX
SR_R3_TR.LBX
SR_R4_SC.LBX
SR_R4_SP.LBX
SR_R4_TR.LBX
SR_R5_SC.LBX
SR_R5_SP.LBX
SR_R5_TR.LBX
SR_R6_SC.LBX
SR_R6_SP.LBX
SR_R6_TR.LBX
SR_R7_SC.LBX
SR_R7_SP.LBX
SR_R7_TR.LBX
SR_R8_SC.LBX
SR_R8_SP.LBX
SR_R8_TR.LBX
SR_R9_SC.LBX
SR_R9_SP.LBX
SR_R9_TR.LBX
SR_RA_SC.LBX
SR_RA_SP.LBX
SR_RA_TR.LBX
SR_RB_SC.LBX
SR_RB_SP.LBX
SR_RB_TR.LBX
SR_RC_SC.LBX
SR_RC_SP.LBX
SR_RC_TR.LBX
STARBG.LBX
STARNAME.LBX
STREAM.LBX
SYSDISP.LBX
TANM_001.LBX
TANM_002.LBX
TANM_003.LBX
TANM_004.LBX
TANM_005.LBX
TANM_006.LBX
TANM_007.LBX
TANM_008.LBX
TANM_009.LBX
TANM_010.LBX
TANM_011.LBX
TANM_012.LBX
TANM_013.LBX
TANM_014.LBX
TANM_015.LBX
TANM_016.LBX
TANM_017.LBX
TANM_018.LBX
TANM_019.LBX
TANM_020.LBX
TANM_021.LBX
TANM_022.LBX
TANM_023.LBX
TANM_024.LBX
TANM_025.LBX
TANM_026.LBX
TANM_027.LBX
TANM_028.LBX
TANM_029.LBX
TANM_030.LBX
TANM_031.LBX
TANM_032.LBX
TANM_033.LBX
TANM_034.LBX
TANM_035.LBX
TANM_036.LBX
TANM_037.LBX
TANM_038.LBX
TANM_039.LBX
TANM_040.LBX
TANM_041.LBX
TANM_042.LBX
TANM_043.LBX
TANM_044.LBX
TANM_045.LBX
TANM_046.LBX
TANM_047.LBX
TANM_048.LBX
TANM_049.LBX
TANM_050.LBX
TANM_051.LBX
TANM_052.LBX
TANM_053.LBX
TANM_054.LBX
TANM_055.LBX
TANM_056.LBX
TANM_057.LBX
TANM_058.LBX
TANM_059.LBX
TANM_060.LBX
TANM_061.LBX
TANM_062.LBX
TANM_063.LBX
TANM_064.LBX
TANM_065.LBX
TANM_066.LBX
TANM_067.LBX
TANM_068.LBX
TANM_069.LBX
TANM_070.LBX
TANM_071.LBX
TANM_072.LBX
TANM_073.LBX
TANM_074.LBX
TANM_075.LBX
TANM_076.LBX
TANM_077.LBX
TANM_078.LBX
TANM_079.LBX
TANM_080.LBX
TANM_081.LBX
TANM_082.LBX
TANM_083.LBX
TANM_084.LBX
TANM_085.LBX
TANM_086.LBX
TANM_087.LBX
TANM_088.LBX
TANM_089.LBX
TANM_090.LBX
TANM_091.LBX
TANM_092.LBX
TANM_093.LBX
TANM_094.LBX
TANM_095.LBX
TANM_096.LBX
TANM_097.LBX
TANM_098.LBX
TANM_099.LBX
TANM_100.LBX
TANM_101.LBX
TANM_102.LBX
TANM_103.LBX
TANM_104.LBX
TANM_105.LBX
TANM_106.LBX
TANM_107.LBX
TANM_108.LBX
TANM_109.LBX
TANM_110.LBX
TANM_111.LBX
TANM_112.LBX
TANM_113.LBX
TANM_115.LBX
TANM_116.LBX
TANM_117.LBX
TANM_118.LBX
TANM_119.LBX
TANM_120.LBX
TANM_121.LBX
TANM_122.LBX
TANM_123.LBX
TANM_124.LBX
TANM_125.LBX
TANM_126.LBX
TANM_127.LBX
TANM_128.LBX
TANM_129.LBX
TANM_130.LBX
TANM_131.LBX
TANM_132.LBX
TANM_133.LBX
TANM_134.LBX
TANM_135.LBX
TANM_136.LBX
TANM_137.LBX
TANM_138.LBX
TANM_139.LBX
TANM_140.LBX
TANM_141.LBX
TANM_142.LBX
TANM_143.LBX
TANM_144.LBX
TANM_145.LBX
TANM_146.LBX
TANM_147.LBX
TANM_148.LBX
TANM_149.LBX
TANM_150.LBX
TANM_151.LBX
TANM_152.LBX
TANM_153.LBX
TANM_154.LBX
TANM_155.LBX
TANM_156.LBX
TANM_157.LBX
TANM_158.LBX
TANM_159.LBX
TANM_160.LBX
TANM_161.LBX
TANM_162.LBX
TANM_163.LBX
TANM_164.LBX
TANM_165.LBX
TANM_166.LBX
TANM_167.LBX
TANM_168.LBX
TANM_169.LBX
TANM_170.LBX
TANM_171.LBX
TANM_172.LBX
TANM_173.LBX
TANM_174.LBX
TANM_175.LBX
TANM_176.LBX
TANM_177.LBX
TANM_178.LBX
TANM_179.LBX
TANM_180.LBX
TANM_181.LBX
TANM_182.LBX
TANM_183.LBX
TANM_184.LBX
TANM_185.LBX
TANM_186.LBX
TANM_187.LBX
TANM_188.LBX
TANM_189.LBX
TANM_190.LBX
TANM_191.LBX
TANM_192.LBX
TANM_193.LBX
TANM_194.LBX
TANM_195.LBX
TANM_196.LBX
TANM_197.LBX
TANM_198.LBX
TANM_199.LBX
TANM_200.LBX
TANM_201.LBX
TANM_202.LBX
TANM_203.LBX
TANM_204.LBX
TANM_205.LBX
TANM_206.LBX
TANM_207.LBX
TANM_208.LBX
TANM_209.LBX
TANM_210.LBX
TANM_211.LBX
TANM_212.LBX
TANM_213.LBX
TECHDESC.LBX
TECHNAME.LBX
TECHSEL.LBX
TEXTBOX.LBX
TURNSUM.LBX
WININFIN.LBX
AILDRVR.LST
SAMPLE.MT
SAMPLE.OPL
*.DIG
*.MDI'
CONTENT_GAME_L10N_FILES='
RKERNEL.COM
Orion2.exe
LANGUAGE.INI
ANWINFIN.LBX
CMBTSHP.LBX
COUNCIL.LBX
DIPLOMAT.LBX
DIPLOMSF.LBX
DIPLOMSG.LBX
DIPLOMSI.LBX
DIPLOMSS.LBX
ESTRFREN.LBX
ESTRGERM.LBX
ESTRITAL.LBX
ESTRPOLI.LBX
ESTRSPAN.LBX
EVENTMSF.LBX
EVENTMSG.LBX
EVENTMSI.LBX
EVENTMSS.LBX
FILEDATA.LBX
FONTSF.LBX
FONTSG.LBX
FONTSI.LBX
FONTSS.LBX
FRECRDTS.LBX
FRE_HELP.LBX
FRESKLLS.LBX
FRETECD.LBX
GERCRDTS.LBX
GER_HELP.LBX
GERSKLLS.LBX
GERTECD.LBX
HELP.LBX
HERODATF.LBX
HERODATG.LBX
HERODATI.LBX
HERODATS.LBX
HESTRNGS.LBX
HFSTRNGS.LBX
HGSTRNGS.LBX
HISTRNGS.LBX
HSSTRNGS.LBX
IFONTS.LBX
INSTALL.LBX
ITACRDTS.LBX
ITA_HELP.LBX
ITASKLLS.LBX
ITATECD.LBX
LOSERFIN.LBX
MAINFREN.LBX
MAINGERM.LBX
MAINITAL.LBX
MAINSPAN.LBX
RSTRING1.LBX
RSTRING2.LBX
RSTRING3.LBX
RSTRING4.LBX
RSTRINGS.LBX
SIMTEX.LBX
SPACRDTS.LBX
SPA_HELP.LBX
SPASKLLS.LBX
SPATECD.LBX
STREAMHD.LBX
TANM_114.LBX
WARNING.LBX'
CONTENT_DOC_L10N_FILES='
*.TXT'
CONTENT_DOC_MAIN_PATH='data/noarch/docs'
CONTENT_DOC_MAIN_FILES='
*.pdf'

APP_MAIN_EXE='Orion2.exe'
APP_MAIN_ICON='../support/icon.png'

USER_PERSISTENT_FILES='
MOX.SET
SOUND.LBX
*.INI
*.GAM'

PACKAGES_LIST='
PKG_MAIN
PKG_L10N'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localisation'
PKG_L10N_DESCRIPTION_FR='French localisation'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
