//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlpathstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLPathStyle(pub CFIndex);
impl CFURLPathStyle {
    #[doc(alias = "kCFURLPOSIXPathStyle")]
    pub const CFURLPOSIXPathStyle: Self = Self(0);
    #[doc(alias = "kCFURLHFSPathStyle")]
    #[deprecated = "Carbon File Manager is deprecated, use kCFURLPOSIXPathStyle where possible"]
    pub const CFURLHFSPathStyle: Self = Self(1);
    #[doc(alias = "kCFURLWindowsPathStyle")]
    pub const CFURLWindowsPathStyle: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFURLPathStyle {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFURLPathStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurl?language=objc)
#[repr(C)]
pub struct CFURL {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFURL {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFURL"> for CFURL {}
);

unsafe impl ConcreteType for CFURL {
    #[doc(alias = "CFURLGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFURLGetTypeID() -> CFTypeID;
        }
        unsafe { CFURLGetTypeID() }
    }
}

impl CFURL {
    #[doc(alias = "CFURLCreateWithBytes")]
    #[cfg(feature = "CFString")]
    #[inline]
    pub unsafe fn with_bytes(
        allocator: Option<&CFAllocator>,
        url_bytes: *const u8,
        length: CFIndex,
        encoding: CFStringEncoding,
        base_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateWithBytes(
                allocator: Option<&CFAllocator>,
                url_bytes: *const u8,
                length: CFIndex,
                encoding: CFStringEncoding,
                base_url: Option<&CFURL>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCreateWithBytes(allocator, url_bytes, length, encoding, base_url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateData")]
    #[cfg(all(feature = "CFData", feature = "CFString"))]
    #[inline]
    pub fn new_data(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
        encoding: CFStringEncoding,
        escape_whitespace: bool,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFURLCreateData(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
                encoding: CFStringEncoding,
                escape_whitespace: Boolean,
            ) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CFURLCreateData(allocator, url, encoding, escape_whitespace as _) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateWithString")]
    #[inline]
    pub(crate) fn __from_string(
        allocator: Option<&CFAllocator>,
        url_string: Option<&CFString>,
        base_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateWithString(
                allocator: Option<&CFAllocator>,
                url_string: Option<&CFString>,
                base_url: Option<&CFURL>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCreateWithString(allocator, url_string, base_url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateAbsoluteURLWithBytes")]
    #[cfg(feature = "CFString")]
    #[inline]
    pub unsafe fn new_absolute_url_with_bytes(
        alloc: Option<&CFAllocator>,
        relative_url_bytes: *const u8,
        length: CFIndex,
        encoding: CFStringEncoding,
        base_url: Option<&CFURL>,
        use_compatibility_mode: bool,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateAbsoluteURLWithBytes(
                alloc: Option<&CFAllocator>,
                relative_url_bytes: *const u8,
                length: CFIndex,
                encoding: CFStringEncoding,
                base_url: Option<&CFURL>,
                use_compatibility_mode: Boolean,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFURLCreateAbsoluteURLWithBytes(
                alloc,
                relative_url_bytes,
                length,
                encoding,
                base_url,
                use_compatibility_mode as _,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateWithFileSystemPath")]
    #[inline]
    pub fn with_file_system_path(
        allocator: Option<&CFAllocator>,
        file_path: Option<&CFString>,
        path_style: CFURLPathStyle,
        is_directory: bool,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateWithFileSystemPath(
                allocator: Option<&CFAllocator>,
                file_path: Option<&CFString>,
                path_style: CFURLPathStyle,
                is_directory: Boolean,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFURLCreateWithFileSystemPath(allocator, file_path, path_style, is_directory as _)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateFromFileSystemRepresentation")]
    #[inline]
    pub unsafe fn from_file_system_representation(
        allocator: Option<&CFAllocator>,
        buffer: *const u8,
        buf_len: CFIndex,
        is_directory: bool,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateFromFileSystemRepresentation(
                allocator: Option<&CFAllocator>,
                buffer: *const u8,
                buf_len: CFIndex,
                is_directory: Boolean,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFURLCreateFromFileSystemRepresentation(allocator, buffer, buf_len, is_directory as _)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateWithFileSystemPathRelativeToBase")]
    #[inline]
    pub fn with_file_system_path_relative_to_base(
        allocator: Option<&CFAllocator>,
        file_path: Option<&CFString>,
        path_style: CFURLPathStyle,
        is_directory: bool,
        base_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateWithFileSystemPathRelativeToBase(
                allocator: Option<&CFAllocator>,
                file_path: Option<&CFString>,
                path_style: CFURLPathStyle,
                is_directory: Boolean,
                base_url: Option<&CFURL>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFURLCreateWithFileSystemPathRelativeToBase(
                allocator,
                file_path,
                path_style,
                is_directory as _,
                base_url,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateFromFileSystemRepresentationRelativeToBase")]
    #[inline]
    pub unsafe fn from_file_system_representation_relative_to_base(
        allocator: Option<&CFAllocator>,
        buffer: *const u8,
        buf_len: CFIndex,
        is_directory: bool,
        base_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateFromFileSystemRepresentationRelativeToBase(
                allocator: Option<&CFAllocator>,
                buffer: *const u8,
                buf_len: CFIndex,
                is_directory: Boolean,
                base_url: Option<&CFURL>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFURLCreateFromFileSystemRepresentationRelativeToBase(
                allocator,
                buffer,
                buf_len,
                is_directory as _,
                base_url,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLGetFileSystemRepresentation")]
    #[inline]
    pub unsafe fn file_system_representation(
        self: &CFURL,
        resolve_against_base: bool,
        buffer: *mut u8,
        max_buf_len: CFIndex,
    ) -> bool {
        extern "C-unwind" {
            fn CFURLGetFileSystemRepresentation(
                url: &CFURL,
                resolve_against_base: Boolean,
                buffer: *mut u8,
                max_buf_len: CFIndex,
            ) -> Boolean;
        }
        let ret = unsafe {
            CFURLGetFileSystemRepresentation(self, resolve_against_base as _, buffer, max_buf_len)
        };
        ret != 0
    }

    #[doc(alias = "CFURLCopyAbsoluteURL")]
    #[inline]
    pub fn absolute_url(self: &CFURL) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCopyAbsoluteURL(relative_url: &CFURL) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCopyAbsoluteURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLGetString")]
    #[inline]
    pub(crate) fn __string(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLGetString(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLGetString(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFURLGetBaseURL")]
    #[inline]
    pub fn base_url(self: &CFURL) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLGetBaseURL(an_url: &CFURL) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLGetBaseURL(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFURLCanBeDecomposed")]
    #[inline]
    pub fn can_be_decomposed(self: &CFURL) -> bool {
        extern "C-unwind" {
            fn CFURLCanBeDecomposed(an_url: &CFURL) -> Boolean;
        }
        let ret = unsafe { CFURLCanBeDecomposed(self) };
        ret != 0
    }

    #[doc(alias = "CFURLCopyScheme")]
    #[inline]
    pub fn scheme(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyScheme(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyScheme(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyNetLocation")]
    #[inline]
    pub fn net_location(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyNetLocation(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyNetLocation(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyPath")]
    #[inline]
    pub fn path(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyPath(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyPath(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyStrictPath")]
    #[inline]
    pub unsafe fn strict_path(
        self: &CFURL,
        is_absolute: *mut Boolean,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyStrictPath(
                an_url: &CFURL,
                is_absolute: *mut Boolean,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyStrictPath(self, is_absolute) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyFileSystemPath")]
    #[inline]
    pub fn file_system_path(
        self: &CFURL,
        path_style: CFURLPathStyle,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyFileSystemPath(
                an_url: &CFURL,
                path_style: CFURLPathStyle,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyFileSystemPath(self, path_style) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLHasDirectoryPath")]
    #[inline]
    pub fn has_directory_path(self: &CFURL) -> bool {
        extern "C-unwind" {
            fn CFURLHasDirectoryPath(an_url: &CFURL) -> Boolean;
        }
        let ret = unsafe { CFURLHasDirectoryPath(self) };
        ret != 0
    }

    #[doc(alias = "CFURLCopyResourceSpecifier")]
    #[inline]
    pub fn resource_specifier(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyResourceSpecifier(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyResourceSpecifier(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyHostName")]
    #[inline]
    pub fn host_name(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyHostName(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyHostName(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLGetPortNumber")]
    #[inline]
    pub fn port_number(self: &CFURL) -> i32 {
        extern "C-unwind" {
            fn CFURLGetPortNumber(an_url: &CFURL) -> i32;
        }
        unsafe { CFURLGetPortNumber(self) }
    }

    #[doc(alias = "CFURLCopyUserName")]
    #[inline]
    pub fn user_name(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyUserName(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyUserName(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyPassword")]
    #[inline]
    pub fn password(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyPassword(an_url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyPassword(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyParameterString")]
    #[deprecated = "The CFURLCopyParameterString function is deprecated. Post deprecation for applications linked with or after the macOS 10.15, and for all iOS, watchOS, and tvOS applications, CFURLCopyParameterString will always return NULL, and the CFURLCopyPath(), CFURLCopyStrictPath(), and CFURLCopyFileSystemPath() functions will return the complete path including the semicolon separator and params component if the URL string contains them."]
    #[inline]
    pub fn parameter_string(
        self: &CFURL,
        characters_to_leave_escaped: Option<&CFString>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyParameterString(
                an_url: &CFURL,
                characters_to_leave_escaped: Option<&CFString>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyParameterString(self, characters_to_leave_escaped) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyQueryString")]
    #[inline]
    pub fn query_string(
        self: &CFURL,
        characters_to_leave_escaped: Option<&CFString>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyQueryString(
                an_url: &CFURL,
                characters_to_leave_escaped: Option<&CFString>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyQueryString(self, characters_to_leave_escaped) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyFragment")]
    #[inline]
    pub fn fragment(
        self: &CFURL,
        characters_to_leave_escaped: Option<&CFString>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyFragment(
                an_url: &CFURL,
                characters_to_leave_escaped: Option<&CFString>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyFragment(self, characters_to_leave_escaped) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyLastPathComponent")]
    #[inline]
    pub fn last_path_component(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyLastPathComponent(url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyLastPathComponent(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyPathExtension")]
    #[inline]
    pub fn path_extension(self: &CFURL) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCopyPathExtension(url: &CFURL) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFURLCopyPathExtension(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateCopyAppendingPathComponent")]
    #[inline]
    pub fn new_copy_appending_path_component(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
        path_component: Option<&CFString>,
        is_directory: bool,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateCopyAppendingPathComponent(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
                path_component: Option<&CFString>,
                is_directory: Boolean,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFURLCreateCopyAppendingPathComponent(allocator, url, path_component, is_directory as _)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateCopyDeletingLastPathComponent")]
    #[inline]
    pub fn new_copy_deleting_last_path_component(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateCopyDeletingLastPathComponent(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCreateCopyDeletingLastPathComponent(allocator, url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateCopyAppendingPathExtension")]
    #[inline]
    pub fn new_copy_appending_path_extension(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
        extension: Option<&CFString>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateCopyAppendingPathExtension(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
                extension: Option<&CFString>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCreateCopyAppendingPathExtension(allocator, url, extension) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateCopyDeletingPathExtension")]
    #[inline]
    pub fn new_copy_deleting_path_extension(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateCopyDeletingPathExtension(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCreateCopyDeletingPathExtension(allocator, url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLGetBytes")]
    #[inline]
    pub unsafe fn bytes(self: &CFURL, buffer: *mut u8, buffer_length: CFIndex) -> CFIndex {
        extern "C-unwind" {
            fn CFURLGetBytes(url: &CFURL, buffer: *mut u8, buffer_length: CFIndex) -> CFIndex;
        }
        unsafe { CFURLGetBytes(self, buffer, buffer_length) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlcomponenttype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLComponentType(pub CFIndex);
impl CFURLComponentType {
    #[doc(alias = "kCFURLComponentScheme")]
    pub const Scheme: Self = Self(1);
    #[doc(alias = "kCFURLComponentNetLocation")]
    pub const NetLocation: Self = Self(2);
    #[doc(alias = "kCFURLComponentPath")]
    pub const Path: Self = Self(3);
    #[doc(alias = "kCFURLComponentResourceSpecifier")]
    pub const ResourceSpecifier: Self = Self(4);
    #[doc(alias = "kCFURLComponentUser")]
    pub const User: Self = Self(5);
    #[doc(alias = "kCFURLComponentPassword")]
    pub const Password: Self = Self(6);
    #[doc(alias = "kCFURLComponentUserInfo")]
    pub const UserInfo: Self = Self(7);
    #[doc(alias = "kCFURLComponentHost")]
    pub const Host: Self = Self(8);
    #[doc(alias = "kCFURLComponentPort")]
    pub const Port: Self = Self(9);
    #[doc(alias = "kCFURLComponentParameterString")]
    pub const ParameterString: Self = Self(10);
    #[doc(alias = "kCFURLComponentQuery")]
    pub const Query: Self = Self(11);
    #[doc(alias = "kCFURLComponentFragment")]
    pub const Fragment: Self = Self(12);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFURLComponentType {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFURLComponentType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFURL {
    #[doc(alias = "CFURLGetByteRangeForComponent")]
    #[inline]
    pub unsafe fn byte_range_for_component(
        self: &CFURL,
        component: CFURLComponentType,
        range_including_separators: *mut CFRange,
    ) -> CFRange {
        extern "C-unwind" {
            fn CFURLGetByteRangeForComponent(
                url: &CFURL,
                component: CFURLComponentType,
                range_including_separators: *mut CFRange,
            ) -> CFRange;
        }
        unsafe { CFURLGetByteRangeForComponent(self, component, range_including_separators) }
    }

    #[doc(alias = "CFURLCreateStringByReplacingPercentEscapes")]
    #[inline]
    pub fn new_string_by_replacing_percent_escapes(
        allocator: Option<&CFAllocator>,
        original_string: Option<&CFString>,
        characters_to_leave_escaped: Option<&CFString>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCreateStringByReplacingPercentEscapes(
                allocator: Option<&CFAllocator>,
                original_string: Option<&CFString>,
                characters_to_leave_escaped: Option<&CFString>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe {
            CFURLCreateStringByReplacingPercentEscapes(
                allocator,
                original_string,
                characters_to_leave_escaped,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateStringByReplacingPercentEscapesUsingEncoding")]
    #[cfg(feature = "CFString")]
    #[deprecated = "Use [NSString stringByRemovingPercentEncoding] or CFURLCreateStringByReplacingPercentEscapes() instead, which always uses the recommended UTF-8 encoding."]
    #[inline]
    pub unsafe fn new_string_by_replacing_percent_escapes_using_encoding(
        allocator: Option<&CFAllocator>,
        orig_string: Option<&CFString>,
        chars_to_leave_escaped: Option<&CFString>,
        encoding: CFStringEncoding,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
                allocator: Option<&CFAllocator>,
                orig_string: Option<&CFString>,
                chars_to_leave_escaped: Option<&CFString>,
                encoding: CFStringEncoding,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe {
            CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
                allocator,
                orig_string,
                chars_to_leave_escaped,
                encoding,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateStringByAddingPercentEscapes")]
    #[cfg(feature = "CFString")]
    #[deprecated = "Use [NSString stringByAddingPercentEncodingWithAllowedCharacters:] instead, which always uses the recommended UTF-8 encoding, and which encodes for a specific URL component or subcomponent (since each URL component or subcomponent has different rules for what characters are valid)."]
    #[inline]
    pub unsafe fn new_string_by_adding_percent_escapes(
        allocator: Option<&CFAllocator>,
        original_string: Option<&CFString>,
        characters_to_leave_unescaped: Option<&CFString>,
        legal_url_characters_to_be_escaped: Option<&CFString>,
        encoding: CFStringEncoding,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFURLCreateStringByAddingPercentEscapes(
                allocator: Option<&CFAllocator>,
                original_string: Option<&CFString>,
                characters_to_leave_unescaped: Option<&CFString>,
                legal_url_characters_to_be_escaped: Option<&CFString>,
                encoding: CFStringEncoding,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe {
            CFURLCreateStringByAddingPercentEscapes(
                allocator,
                original_string,
                characters_to_leave_unescaped,
                legal_url_characters_to_be_escaped,
                encoding,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLIsFileReferenceURL")]
    #[inline]
    pub fn is_file_reference_url(self: &CFURL) -> bool {
        extern "C-unwind" {
            fn CFURLIsFileReferenceURL(url: &CFURL) -> Boolean;
        }
        let ret = unsafe { CFURLIsFileReferenceURL(self) };
        ret != 0
    }

    #[doc(alias = "CFURLCreateFileReferenceURL")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub unsafe fn new_file_reference_url(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
        error: *mut *mut CFError,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateFileReferenceURL(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
                error: *mut *mut CFError,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCreateFileReferenceURL(allocator, url, error) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateFilePathURL")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub unsafe fn new_file_path_url(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
        error: *mut *mut CFError,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateFilePathURL(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
                error: *mut *mut CFError,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFURLCreateFilePathURL(allocator, url, error) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCopyResourcePropertyForKey")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub unsafe fn resource_property_for_key(
        self: &CFURL,
        key: Option<&CFString>,
        property_value_type_ref_ptr: *mut c_void,
        error: *mut *mut CFError,
    ) -> bool {
        extern "C-unwind" {
            fn CFURLCopyResourcePropertyForKey(
                url: &CFURL,
                key: Option<&CFString>,
                property_value_type_ref_ptr: *mut c_void,
                error: *mut *mut CFError,
            ) -> Boolean;
        }
        let ret = unsafe {
            CFURLCopyResourcePropertyForKey(self, key, property_value_type_ref_ptr, error)
        };
        ret != 0
    }

    #[doc(alias = "CFURLCopyResourcePropertiesForKeys")]
    #[cfg(all(feature = "CFArray", feature = "CFDictionary", feature = "CFError"))]
    #[inline]
    pub unsafe fn resource_properties_for_keys(
        self: &CFURL,
        keys: Option<&CFArray>,
        error: *mut *mut CFError,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFURLCopyResourcePropertiesForKeys(
                url: &CFURL,
                keys: Option<&CFArray>,
                error: *mut *mut CFError,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CFURLCopyResourcePropertiesForKeys(self, keys, error) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLSetResourcePropertyForKey")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub unsafe fn set_resource_property_for_key(
        self: &CFURL,
        key: Option<&CFString>,
        property_value: Option<&CFType>,
        error: *mut *mut CFError,
    ) -> bool {
        extern "C-unwind" {
            fn CFURLSetResourcePropertyForKey(
                url: &CFURL,
                key: Option<&CFString>,
                property_value: Option<&CFType>,
                error: *mut *mut CFError,
            ) -> Boolean;
        }
        let ret = unsafe { CFURLSetResourcePropertyForKey(self, key, property_value, error) };
        ret != 0
    }

    #[doc(alias = "CFURLSetResourcePropertiesForKeys")]
    #[cfg(all(feature = "CFDictionary", feature = "CFError"))]
    #[inline]
    pub unsafe fn set_resource_properties_for_keys(
        self: &CFURL,
        keyed_property_values: Option<&CFDictionary>,
        error: *mut *mut CFError,
    ) -> bool {
        extern "C-unwind" {
            fn CFURLSetResourcePropertiesForKeys(
                url: &CFURL,
                keyed_property_values: Option<&CFDictionary>,
                error: *mut *mut CFError,
            ) -> Boolean;
        }
        let ret = unsafe { CFURLSetResourcePropertiesForKeys(self, keyed_property_values, error) };
        ret != 0
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlkeysofunsetvalueskey?language=objc)
    pub static kCFURLKeysOfUnsetValuesKey: Option<&'static CFString>;
}

impl CFURL {
    #[doc(alias = "CFURLClearResourcePropertyCacheForKey")]
    #[inline]
    pub fn clear_resource_property_cache_for_key(self: &CFURL, key: Option<&CFString>) {
        extern "C-unwind" {
            fn CFURLClearResourcePropertyCacheForKey(url: &CFURL, key: Option<&CFString>);
        }
        unsafe { CFURLClearResourcePropertyCacheForKey(self, key) }
    }

    #[doc(alias = "CFURLClearResourcePropertyCache")]
    #[inline]
    pub fn clear_resource_property_cache(self: &CFURL) {
        extern "C-unwind" {
            fn CFURLClearResourcePropertyCache(url: &CFURL);
        }
        unsafe { CFURLClearResourcePropertyCache(self) }
    }

    #[doc(alias = "CFURLSetTemporaryResourcePropertyForKey")]
    #[inline]
    pub fn set_temporary_resource_property_for_key(
        self: &CFURL,
        key: Option<&CFString>,
        property_value: Option<&CFType>,
    ) {
        extern "C-unwind" {
            fn CFURLSetTemporaryResourcePropertyForKey(
                url: &CFURL,
                key: Option<&CFString>,
                property_value: Option<&CFType>,
            );
        }
        unsafe { CFURLSetTemporaryResourcePropertyForKey(self, key, property_value) }
    }

    #[doc(alias = "CFURLResourceIsReachable")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub unsafe fn resource_is_reachable(self: &CFURL, error: *mut *mut CFError) -> bool {
        extern "C-unwind" {
            fn CFURLResourceIsReachable(url: &CFURL, error: *mut *mut CFError) -> Boolean;
        }
        let ret = unsafe { CFURLResourceIsReachable(self, error) };
        ret != 0
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlnamekey?language=objc)
    pub static kCFURLNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllocalizednamekey?language=objc)
    pub static kCFURLLocalizedNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisregularfilekey?language=objc)
    pub static kCFURLIsRegularFileKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisdirectorykey?language=objc)
    pub static kCFURLIsDirectoryKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlissymboliclinkkey?language=objc)
    pub static kCFURLIsSymbolicLinkKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisvolumekey?language=objc)
    pub static kCFURLIsVolumeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlispackagekey?language=objc)
    pub static kCFURLIsPackageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisapplicationkey?language=objc)
    pub static kCFURLIsApplicationKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlapplicationisscriptablekey?language=objc)
    pub static kCFURLApplicationIsScriptableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlissystemimmutablekey?language=objc)
    pub static kCFURLIsSystemImmutableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisuserimmutablekey?language=objc)
    pub static kCFURLIsUserImmutableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlishiddenkey?language=objc)
    pub static kCFURLIsHiddenKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlhashiddenextensionkey?language=objc)
    pub static kCFURLHasHiddenExtensionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcreationdatekey?language=objc)
    pub static kCFURLCreationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcontentaccessdatekey?language=objc)
    pub static kCFURLContentAccessDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcontentmodificationdatekey?language=objc)
    pub static kCFURLContentModificationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlattributemodificationdatekey?language=objc)
    pub static kCFURLAttributeModificationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileidentifierkey?language=objc)
    pub static kCFURLFileIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfilecontentidentifierkey?language=objc)
    pub static kCFURLFileContentIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlmaysharefilecontentkey?language=objc)
    pub static kCFURLMayShareFileContentKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlmayhaveextendedattributeskey?language=objc)
    pub static kCFURLMayHaveExtendedAttributesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlispurgeablekey?language=objc)
    pub static kCFURLIsPurgeableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlissparsekey?language=objc)
    pub static kCFURLIsSparseKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllinkcountkey?language=objc)
    pub static kCFURLLinkCountKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlparentdirectoryurlkey?language=objc)
    pub static kCFURLParentDirectoryURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeurlkey?language=objc)
    pub static kCFURLVolumeURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltypeidentifierkey?language=objc)
    pub static kCFURLTypeIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllocalizedtypedescriptionkey?language=objc)
    pub static kCFURLLocalizedTypeDescriptionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllabelnumberkey?language=objc)
    pub static kCFURLLabelNumberKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllabelcolorkey?language=objc)
    pub static kCFURLLabelColorKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllocalizedlabelkey?language=objc)
    pub static kCFURLLocalizedLabelKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurleffectiveiconkey?language=objc)
    pub static kCFURLEffectiveIconKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcustomiconkey?language=objc)
    pub static kCFURLCustomIconKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourceidentifierkey?language=objc)
    pub static kCFURLFileResourceIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeidentifierkey?language=objc)
    pub static kCFURLVolumeIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlpreferredioblocksizekey?language=objc)
    pub static kCFURLPreferredIOBlockSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisreadablekey?language=objc)
    pub static kCFURLIsReadableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurliswritablekey?language=objc)
    pub static kCFURLIsWritableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisexecutablekey?language=objc)
    pub static kCFURLIsExecutableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfilesecuritykey?language=objc)
    pub static kCFURLFileSecurityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisexcludedfrombackupkey?language=objc)
    pub static kCFURLIsExcludedFromBackupKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltagnameskey?language=objc)
    pub static kCFURLTagNamesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlpathkey?language=objc)
    pub static kCFURLPathKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcanonicalpathkey?language=objc)
    pub static kCFURLCanonicalPathKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlismounttriggerkey?language=objc)
    pub static kCFURLIsMountTriggerKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlgenerationidentifierkey?language=objc)
    pub static kCFURLGenerationIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurldocumentidentifierkey?language=objc)
    pub static kCFURLDocumentIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurladdedtodirectorydatekey?language=objc)
    pub static kCFURLAddedToDirectoryDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlquarantinepropertieskey?language=objc)
    pub static kCFURLQuarantinePropertiesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypekey?language=objc)
    pub static kCFURLFileResourceTypeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypenamedpipe?language=objc)
    pub static kCFURLFileResourceTypeNamedPipe: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypecharacterspecial?language=objc)
    pub static kCFURLFileResourceTypeCharacterSpecial: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypedirectory?language=objc)
    pub static kCFURLFileResourceTypeDirectory: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypeblockspecial?language=objc)
    pub static kCFURLFileResourceTypeBlockSpecial: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetyperegular?language=objc)
    pub static kCFURLFileResourceTypeRegular: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypesymboliclink?language=objc)
    pub static kCFURLFileResourceTypeSymbolicLink: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypesocket?language=objc)
    pub static kCFURLFileResourceTypeSocket: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypeunknown?language=objc)
    pub static kCFURLFileResourceTypeUnknown: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfilesizekey?language=objc)
    pub static kCFURLFileSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileallocatedsizekey?language=objc)
    pub static kCFURLFileAllocatedSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltotalfilesizekey?language=objc)
    pub static kCFURLTotalFileSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltotalfileallocatedsizekey?language=objc)
    pub static kCFURLTotalFileAllocatedSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisaliasfilekey?language=objc)
    pub static kCFURLIsAliasFileKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectionkey?language=objc)
    pub static kCFURLFileProtectionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectionnone?language=objc)
    pub static kCFURLFileProtectionNone: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncomplete?language=objc)
    pub static kCFURLFileProtectionComplete: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncompleteunlessopen?language=objc)
    pub static kCFURLFileProtectionCompleteUnlessOpen: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncompleteuntilfirstuserauthentication?language=objc)
    pub static kCFURLFileProtectionCompleteUntilFirstUserAuthentication: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncompletewhenuserinactive?language=objc)
    pub static kCFURLFileProtectionCompleteWhenUserInactive: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurldirectoryentrycountkey?language=objc)
    pub static kCFURLDirectoryEntryCountKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumelocalizedformatdescriptionkey?language=objc)
    pub static kCFURLVolumeLocalizedFormatDescriptionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumetotalcapacitykey?language=objc)
    pub static kCFURLVolumeTotalCapacityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeavailablecapacitykey?language=objc)
    pub static kCFURLVolumeAvailableCapacityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeavailablecapacityforimportantusagekey?language=objc)
    pub static kCFURLVolumeAvailableCapacityForImportantUsageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeavailablecapacityforopportunisticusagekey?language=objc)
    pub static kCFURLVolumeAvailableCapacityForOpportunisticUsageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeresourcecountkey?language=objc)
    pub static kCFURLVolumeResourceCountKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportspersistentidskey?language=objc)
    pub static kCFURLVolumeSupportsPersistentIDsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportssymboliclinkskey?language=objc)
    pub static kCFURLVolumeSupportsSymbolicLinksKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportshardlinkskey?language=objc)
    pub static kCFURLVolumeSupportsHardLinksKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsjournalingkey?language=objc)
    pub static kCFURLVolumeSupportsJournalingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisjournalingkey?language=objc)
    pub static kCFURLVolumeIsJournalingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportssparsefileskey?language=objc)
    pub static kCFURLVolumeSupportsSparseFilesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportszerorunskey?language=objc)
    pub static kCFURLVolumeSupportsZeroRunsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportscasesensitivenameskey?language=objc)
    pub static kCFURLVolumeSupportsCaseSensitiveNamesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportscasepreservednameskey?language=objc)
    pub static kCFURLVolumeSupportsCasePreservedNamesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsrootdirectorydateskey?language=objc)
    pub static kCFURLVolumeSupportsRootDirectoryDatesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsvolumesizeskey?language=objc)
    pub static kCFURLVolumeSupportsVolumeSizesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsrenamingkey?language=objc)
    pub static kCFURLVolumeSupportsRenamingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsadvisoryfilelockingkey?language=objc)
    pub static kCFURLVolumeSupportsAdvisoryFileLockingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsextendedsecuritykey?language=objc)
    pub static kCFURLVolumeSupportsExtendedSecurityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisbrowsablekey?language=objc)
    pub static kCFURLVolumeIsBrowsableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumemaximumfilesizekey?language=objc)
    pub static kCFURLVolumeMaximumFileSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisejectablekey?language=objc)
    pub static kCFURLVolumeIsEjectableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisremovablekey?language=objc)
    pub static kCFURLVolumeIsRemovableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisinternalkey?language=objc)
    pub static kCFURLVolumeIsInternalKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisautomountedkey?language=objc)
    pub static kCFURLVolumeIsAutomountedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeislocalkey?language=objc)
    pub static kCFURLVolumeIsLocalKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisreadonlykey?language=objc)
    pub static kCFURLVolumeIsReadOnlyKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumecreationdatekey?language=objc)
    pub static kCFURLVolumeCreationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeurlforremountingkey?language=objc)
    pub static kCFURLVolumeURLForRemountingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeuuidstringkey?language=objc)
    pub static kCFURLVolumeUUIDStringKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumenamekey?language=objc)
    pub static kCFURLVolumeNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumelocalizednamekey?language=objc)
    pub static kCFURLVolumeLocalizedNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisencryptedkey?language=objc)
    pub static kCFURLVolumeIsEncryptedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisrootfilesystemkey?language=objc)
    pub static kCFURLVolumeIsRootFileSystemKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportscompressionkey?language=objc)
    pub static kCFURLVolumeSupportsCompressionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsfilecloningkey?language=objc)
    pub static kCFURLVolumeSupportsFileCloningKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsswaprenamingkey?language=objc)
    pub static kCFURLVolumeSupportsSwapRenamingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsexclusiverenamingkey?language=objc)
    pub static kCFURLVolumeSupportsExclusiveRenamingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsimmutablefileskey?language=objc)
    pub static kCFURLVolumeSupportsImmutableFilesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsaccesspermissionskey?language=objc)
    pub static kCFURLVolumeSupportsAccessPermissionsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsfileprotectionkey?language=objc)
    pub static kCFURLVolumeSupportsFileProtectionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumetypenamekey?language=objc)
    pub static kCFURLVolumeTypeNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesubtypekey?language=objc)
    pub static kCFURLVolumeSubtypeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumemountfromlocationkey?language=objc)
    pub static kCFURLVolumeMountFromLocationKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisubiquitousitemkey?language=objc)
    pub static kCFURLIsUbiquitousItemKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemhasunresolvedconflictskey?language=objc)
    pub static kCFURLUbiquitousItemHasUnresolvedConflictsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisdownloadedkey?language=objc)
    pub static kCFURLUbiquitousItemIsDownloadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisdownloadingkey?language=objc)
    pub static kCFURLUbiquitousItemIsDownloadingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisuploadedkey?language=objc)
    pub static kCFURLUbiquitousItemIsUploadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisuploadingkey?language=objc)
    pub static kCFURLUbiquitousItemIsUploadingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitempercentdownloadedkey?language=objc)
    pub static kCFURLUbiquitousItemPercentDownloadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitempercentuploadedkey?language=objc)
    pub static kCFURLUbiquitousItemPercentUploadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatuskey?language=objc)
    pub static kCFURLUbiquitousItemDownloadingStatusKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingerrorkey?language=objc)
    pub static kCFURLUbiquitousItemDownloadingErrorKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemuploadingerrorkey?language=objc)
    pub static kCFURLUbiquitousItemUploadingErrorKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisexcludedfromsynckey?language=objc)
    pub static kCFURLUbiquitousItemIsExcludedFromSyncKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatusnotdownloaded?language=objc)
    pub static kCFURLUbiquitousItemDownloadingStatusNotDownloaded: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatusdownloaded?language=objc)
    pub static kCFURLUbiquitousItemDownloadingStatusDownloaded: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatuscurrent?language=objc)
    pub static kCFURLUbiquitousItemDownloadingStatusCurrent: Option<&'static CFString>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlbookmarkcreationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLBookmarkCreationOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFURLBookmarkCreationOptions: CFOptionFlags {
        #[doc(alias = "kCFURLBookmarkCreationMinimalBookmarkMask")]
        const MinimalBookmarkMask = 1<<9;
        #[doc(alias = "kCFURLBookmarkCreationSuitableForBookmarkFile")]
        const SuitableForBookmarkFile = 1<<10;
        #[doc(alias = "kCFURLBookmarkCreationWithSecurityScope")]
        const WithSecurityScope = 1<<11;
        #[doc(alias = "kCFURLBookmarkCreationSecurityScopeAllowOnlyReadAccess")]
        const SecurityScopeAllowOnlyReadAccess = 1<<12;
        #[doc(alias = "kCFURLBookmarkCreationWithoutImplicitSecurityScope")]
        const WithoutImplicitSecurityScope = 1<<29;
        #[doc(alias = "kCFURLBookmarkCreationPreferFileIDResolutionMask")]
#[deprecated = "kCFURLBookmarkCreationPreferFileIDResolutionMask does nothing and has no effect on bookmark resolution"]
        const PreferFileIDResolutionMask = 1<<8;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFURLBookmarkCreationOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFURLBookmarkCreationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlbookmarkresolutionoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLBookmarkResolutionOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFURLBookmarkResolutionOptions: CFOptionFlags {
        #[doc(alias = "kCFURLBookmarkResolutionWithoutUIMask")]
        const CFURLBookmarkResolutionWithoutUIMask = 1<<8;
        #[doc(alias = "kCFURLBookmarkResolutionWithoutMountingMask")]
        const CFURLBookmarkResolutionWithoutMountingMask = 1<<9;
        #[doc(alias = "kCFURLBookmarkResolutionWithSecurityScope")]
        const CFURLBookmarkResolutionWithSecurityScope = 1<<10;
        #[doc(alias = "kCFURLBookmarkResolutionWithoutImplicitStartAccessing")]
        const CFURLBookmarkResolutionWithoutImplicitStartAccessing = 1<<15;
        #[doc(alias = "kCFBookmarkResolutionWithoutUIMask")]
        const CFBookmarkResolutionWithoutUIMask = CFURLBookmarkResolutionOptions::CFURLBookmarkResolutionWithoutUIMask.0;
        #[doc(alias = "kCFBookmarkResolutionWithoutMountingMask")]
        const CFBookmarkResolutionWithoutMountingMask = CFURLBookmarkResolutionOptions::CFURLBookmarkResolutionWithoutMountingMask.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFURLBookmarkResolutionOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFURLBookmarkResolutionOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlbookmarkfilecreationoptions?language=objc)
pub type CFURLBookmarkFileCreationOptions = CFOptionFlags;

impl CFURL {
    #[doc(alias = "CFURLCreateBookmarkData")]
    #[cfg(all(feature = "CFArray", feature = "CFData", feature = "CFError"))]
    #[inline]
    pub unsafe fn new_bookmark_data(
        allocator: Option<&CFAllocator>,
        url: Option<&CFURL>,
        options: CFURLBookmarkCreationOptions,
        resource_properties_to_include: Option<&CFArray>,
        relative_to_url: Option<&CFURL>,
        error: *mut *mut CFError,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFURLCreateBookmarkData(
                allocator: Option<&CFAllocator>,
                url: Option<&CFURL>,
                options: CFURLBookmarkCreationOptions,
                resource_properties_to_include: Option<&CFArray>,
                relative_to_url: Option<&CFURL>,
                error: *mut *mut CFError,
            ) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe {
            CFURLCreateBookmarkData(
                allocator,
                url,
                options,
                resource_properties_to_include,
                relative_to_url,
                error,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateByResolvingBookmarkData")]
    #[cfg(all(feature = "CFArray", feature = "CFData", feature = "CFError"))]
    #[inline]
    pub unsafe fn new_by_resolving_bookmark_data(
        allocator: Option<&CFAllocator>,
        bookmark: Option<&CFData>,
        options: CFURLBookmarkResolutionOptions,
        relative_to_url: Option<&CFURL>,
        resource_properties_to_include: Option<&CFArray>,
        is_stale: *mut Boolean,
        error: *mut *mut CFError,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFURLCreateByResolvingBookmarkData(
                allocator: Option<&CFAllocator>,
                bookmark: Option<&CFData>,
                options: CFURLBookmarkResolutionOptions,
                relative_to_url: Option<&CFURL>,
                resource_properties_to_include: Option<&CFArray>,
                is_stale: *mut Boolean,
                error: *mut *mut CFError,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFURLCreateByResolvingBookmarkData(
                allocator,
                bookmark,
                options,
                relative_to_url,
                resource_properties_to_include,
                is_stale,
                error,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateResourcePropertiesForKeysFromBookmarkData")]
    #[cfg(all(feature = "CFArray", feature = "CFData", feature = "CFDictionary"))]
    #[inline]
    pub unsafe fn new_resource_properties_for_keys_from_bookmark_data(
        allocator: Option<&CFAllocator>,
        resource_properties_to_return: Option<&CFArray>,
        bookmark: Option<&CFData>,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFURLCreateResourcePropertiesForKeysFromBookmarkData(
                allocator: Option<&CFAllocator>,
                resource_properties_to_return: Option<&CFArray>,
                bookmark: Option<&CFData>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe {
            CFURLCreateResourcePropertiesForKeysFromBookmarkData(
                allocator,
                resource_properties_to_return,
                bookmark,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateResourcePropertyForKeyFromBookmarkData")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub unsafe fn new_resource_property_for_key_from_bookmark_data(
        allocator: Option<&CFAllocator>,
        resource_property_key: Option<&CFString>,
        bookmark: Option<&CFData>,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CFURLCreateResourcePropertyForKeyFromBookmarkData(
                allocator: Option<&CFAllocator>,
                resource_property_key: Option<&CFString>,
                bookmark: Option<&CFData>,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe {
            CFURLCreateResourcePropertyForKeyFromBookmarkData(
                allocator,
                resource_property_key,
                bookmark,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLCreateBookmarkDataFromFile")]
    #[cfg(all(feature = "CFData", feature = "CFError"))]
    #[inline]
    pub unsafe fn new_bookmark_data_from_file(
        allocator: Option<&CFAllocator>,
        file_url: Option<&CFURL>,
        error_ref: *mut *mut CFError,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFURLCreateBookmarkDataFromFile(
                allocator: Option<&CFAllocator>,
                file_url: Option<&CFURL>,
                error_ref: *mut *mut CFError,
            ) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CFURLCreateBookmarkDataFromFile(allocator, file_url, error_ref) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLWriteBookmarkDataToFile")]
    #[cfg(all(feature = "CFData", feature = "CFError"))]
    #[inline]
    pub unsafe fn write_bookmark_data_to_file(
        bookmark_ref: Option<&CFData>,
        file_url: Option<&CFURL>,
        options: CFURLBookmarkFileCreationOptions,
        error_ref: *mut *mut CFError,
    ) -> bool {
        extern "C-unwind" {
            fn CFURLWriteBookmarkDataToFile(
                bookmark_ref: Option<&CFData>,
                file_url: Option<&CFURL>,
                options: CFURLBookmarkFileCreationOptions,
                error_ref: *mut *mut CFError,
            ) -> Boolean;
        }
        let ret =
            unsafe { CFURLWriteBookmarkDataToFile(bookmark_ref, file_url, options, error_ref) };
        ret != 0
    }

    #[doc(alias = "CFURLCreateBookmarkDataFromAliasRecord")]
    #[cfg(feature = "CFData")]
    #[deprecated = "The Carbon Alias Manager is deprecated. This function should only be used to convert Carbon AliasRecords to bookmark data."]
    #[inline]
    pub unsafe fn new_bookmark_data_from_alias_record(
        allocator_ref: Option<&CFAllocator>,
        alias_record_data_ref: Option<&CFData>,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFURLCreateBookmarkDataFromAliasRecord(
                allocator_ref: Option<&CFAllocator>,
                alias_record_data_ref: Option<&CFData>,
            ) -> Option<NonNull<CFData>>;
        }
        let ret =
            unsafe { CFURLCreateBookmarkDataFromAliasRecord(allocator_ref, alias_record_data_ref) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLStartAccessingSecurityScopedResource")]
    #[inline]
    pub unsafe fn start_accessing_security_scoped_resource(self: &CFURL) -> bool {
        extern "C-unwind" {
            fn CFURLStartAccessingSecurityScopedResource(url: &CFURL) -> Boolean;
        }
        let ret = unsafe { CFURLStartAccessingSecurityScopedResource(self) };
        ret != 0
    }

    #[doc(alias = "CFURLStopAccessingSecurityScopedResource")]
    #[inline]
    pub unsafe fn stop_accessing_security_scoped_resource(self: &CFURL) {
        extern "C-unwind" {
            fn CFURLStopAccessingSecurityScopedResource(url: &CFURL);
        }
        unsafe { CFURLStopAccessingSecurityScopedResource(self) }
    }
}

#[cfg(feature = "CFString")]
#[deprecated = "renamed to `CFURL::with_bytes`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateWithBytes(
    allocator: Option<&CFAllocator>,
    url_bytes: *const u8,
    length: CFIndex,
    encoding: CFStringEncoding,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithBytes(
            allocator: Option<&CFAllocator>,
            url_bytes: *const u8,
            length: CFIndex,
            encoding: CFStringEncoding,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateWithBytes(allocator, url_bytes, length, encoding, base_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFData", feature = "CFString"))]
#[deprecated = "renamed to `CFURL::new_data`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateData(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    encoding: CFStringEncoding,
    escape_whitespace: bool,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateData(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            encoding: CFStringEncoding,
            escape_whitespace: Boolean,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFURLCreateData(allocator, url, encoding, escape_whitespace as _) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::__from_string`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateWithString(
    allocator: Option<&CFAllocator>,
    url_string: Option<&CFString>,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithString(
            allocator: Option<&CFAllocator>,
            url_string: Option<&CFString>,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateWithString(allocator, url_string, base_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFString")]
#[deprecated = "renamed to `CFURL::new_absolute_url_with_bytes`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateAbsoluteURLWithBytes(
    alloc: Option<&CFAllocator>,
    relative_url_bytes: *const u8,
    length: CFIndex,
    encoding: CFStringEncoding,
    base_url: Option<&CFURL>,
    use_compatibility_mode: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateAbsoluteURLWithBytes(
            alloc: Option<&CFAllocator>,
            relative_url_bytes: *const u8,
            length: CFIndex,
            encoding: CFStringEncoding,
            base_url: Option<&CFURL>,
            use_compatibility_mode: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateAbsoluteURLWithBytes(
            alloc,
            relative_url_bytes,
            length,
            encoding,
            base_url,
            use_compatibility_mode as _,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::with_file_system_path`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateWithFileSystemPath(
    allocator: Option<&CFAllocator>,
    file_path: Option<&CFString>,
    path_style: CFURLPathStyle,
    is_directory: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithFileSystemPath(
            allocator: Option<&CFAllocator>,
            file_path: Option<&CFString>,
            path_style: CFURLPathStyle,
            is_directory: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateWithFileSystemPath(allocator, file_path, path_style, is_directory as _)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::from_file_system_representation`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFromFileSystemRepresentation(
    allocator: Option<&CFAllocator>,
    buffer: *const u8,
    buf_len: CFIndex,
    is_directory: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFromFileSystemRepresentation(
            allocator: Option<&CFAllocator>,
            buffer: *const u8,
            buf_len: CFIndex,
            is_directory: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateFromFileSystemRepresentation(allocator, buffer, buf_len, is_directory as _)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::with_file_system_path_relative_to_base`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateWithFileSystemPathRelativeToBase(
    allocator: Option<&CFAllocator>,
    file_path: Option<&CFString>,
    path_style: CFURLPathStyle,
    is_directory: bool,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithFileSystemPathRelativeToBase(
            allocator: Option<&CFAllocator>,
            file_path: Option<&CFString>,
            path_style: CFURLPathStyle,
            is_directory: Boolean,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateWithFileSystemPathRelativeToBase(
            allocator,
            file_path,
            path_style,
            is_directory as _,
            base_url,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::from_file_system_representation_relative_to_base`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFromFileSystemRepresentationRelativeToBase(
    allocator: Option<&CFAllocator>,
    buffer: *const u8,
    buf_len: CFIndex,
    is_directory: bool,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFromFileSystemRepresentationRelativeToBase(
            allocator: Option<&CFAllocator>,
            buffer: *const u8,
            buf_len: CFIndex,
            is_directory: Boolean,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateFromFileSystemRepresentationRelativeToBase(
            allocator,
            buffer,
            buf_len,
            is_directory as _,
            base_url,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::file_system_representation`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLGetFileSystemRepresentation(
    url: &CFURL,
    resolve_against_base: bool,
    buffer: *mut u8,
    max_buf_len: CFIndex,
) -> bool {
    extern "C-unwind" {
        fn CFURLGetFileSystemRepresentation(
            url: &CFURL,
            resolve_against_base: Boolean,
            buffer: *mut u8,
            max_buf_len: CFIndex,
        ) -> Boolean;
    }
    let ret = unsafe {
        CFURLGetFileSystemRepresentation(url, resolve_against_base as _, buffer, max_buf_len)
    };
    ret != 0
}

#[deprecated = "renamed to `CFURL::absolute_url`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyAbsoluteURL(relative_url: &CFURL) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCopyAbsoluteURL(relative_url: &CFURL) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCopyAbsoluteURL(relative_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::__string`"]
#[inline]
pub extern "C-unwind" fn CFURLGetString(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLGetString(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLGetString(an_url) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFURL::base_url`"]
#[inline]
pub extern "C-unwind" fn CFURLGetBaseURL(an_url: &CFURL) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLGetBaseURL(an_url: &CFURL) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLGetBaseURL(an_url) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFURL::can_be_decomposed`"]
#[inline]
pub extern "C-unwind" fn CFURLCanBeDecomposed(an_url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLCanBeDecomposed(an_url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLCanBeDecomposed(an_url) };
    ret != 0
}

#[deprecated = "renamed to `CFURL::scheme`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyScheme(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyScheme(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyScheme(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::net_location`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyNetLocation(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyNetLocation(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyNetLocation(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::path`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyPath(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyPath(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyPath(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::strict_path`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyStrictPath(
    an_url: &CFURL,
    is_absolute: *mut Boolean,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyStrictPath(
            an_url: &CFURL,
            is_absolute: *mut Boolean,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyStrictPath(an_url, is_absolute) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::file_system_path`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyFileSystemPath(
    an_url: &CFURL,
    path_style: CFURLPathStyle,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyFileSystemPath(
            an_url: &CFURL,
            path_style: CFURLPathStyle,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyFileSystemPath(an_url, path_style) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::has_directory_path`"]
#[inline]
pub extern "C-unwind" fn CFURLHasDirectoryPath(an_url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLHasDirectoryPath(an_url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLHasDirectoryPath(an_url) };
    ret != 0
}

#[deprecated = "renamed to `CFURL::resource_specifier`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyResourceSpecifier(
    an_url: &CFURL,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyResourceSpecifier(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyResourceSpecifier(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::host_name`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyHostName(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyHostName(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyHostName(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::port_number`"]
#[inline]
pub extern "C-unwind" fn CFURLGetPortNumber(an_url: &CFURL) -> i32 {
    extern "C-unwind" {
        fn CFURLGetPortNumber(an_url: &CFURL) -> i32;
    }
    unsafe { CFURLGetPortNumber(an_url) }
}

#[deprecated = "renamed to `CFURL::user_name`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyUserName(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyUserName(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyUserName(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::password`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyPassword(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyPassword(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyPassword(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::parameter_string`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyParameterString(
    an_url: &CFURL,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyParameterString(
            an_url: &CFURL,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyParameterString(an_url, characters_to_leave_escaped) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::query_string`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyQueryString(
    an_url: &CFURL,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyQueryString(
            an_url: &CFURL,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyQueryString(an_url, characters_to_leave_escaped) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::fragment`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyFragment(
    an_url: &CFURL,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyFragment(
            an_url: &CFURL,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyFragment(an_url, characters_to_leave_escaped) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::last_path_component`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyLastPathComponent(url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyLastPathComponent(url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyLastPathComponent(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::path_extension`"]
#[inline]
pub extern "C-unwind" fn CFURLCopyPathExtension(url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyPathExtension(url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyPathExtension(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::new_copy_appending_path_component`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateCopyAppendingPathComponent(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    path_component: Option<&CFString>,
    is_directory: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyAppendingPathComponent(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            path_component: Option<&CFString>,
            is_directory: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateCopyAppendingPathComponent(allocator, url, path_component, is_directory as _)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::new_copy_deleting_last_path_component`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateCopyDeletingLastPathComponent(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyDeletingLastPathComponent(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateCopyDeletingLastPathComponent(allocator, url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::new_copy_appending_path_extension`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateCopyAppendingPathExtension(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    extension: Option<&CFString>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyAppendingPathExtension(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            extension: Option<&CFString>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateCopyAppendingPathExtension(allocator, url, extension) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::new_copy_deleting_path_extension`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateCopyDeletingPathExtension(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyDeletingPathExtension(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateCopyDeletingPathExtension(allocator, url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFURL::bytes`"]
    pub fn CFURLGetBytes(url: &CFURL, buffer: *mut u8, buffer_length: CFIndex) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFURL::byte_range_for_component`"]
    pub fn CFURLGetByteRangeForComponent(
        url: &CFURL,
        component: CFURLComponentType,
        range_including_separators: *mut CFRange,
    ) -> CFRange;
}

#[deprecated = "renamed to `CFURL::new_string_by_replacing_percent_escapes`"]
#[inline]
pub extern "C-unwind" fn CFURLCreateStringByReplacingPercentEscapes(
    allocator: Option<&CFAllocator>,
    original_string: Option<&CFString>,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCreateStringByReplacingPercentEscapes(
            allocator: Option<&CFAllocator>,
            original_string: Option<&CFString>,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFURLCreateStringByReplacingPercentEscapes(
            allocator,
            original_string,
            characters_to_leave_escaped,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFString")]
#[deprecated = "renamed to `CFURL::new_string_by_replacing_percent_escapes_using_encoding`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
    allocator: Option<&CFAllocator>,
    orig_string: Option<&CFString>,
    chars_to_leave_escaped: Option<&CFString>,
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
            allocator: Option<&CFAllocator>,
            orig_string: Option<&CFString>,
            chars_to_leave_escaped: Option<&CFString>,
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
            allocator,
            orig_string,
            chars_to_leave_escaped,
            encoding,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFString")]
#[deprecated = "renamed to `CFURL::new_string_by_adding_percent_escapes`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateStringByAddingPercentEscapes(
    allocator: Option<&CFAllocator>,
    original_string: Option<&CFString>,
    characters_to_leave_unescaped: Option<&CFString>,
    legal_url_characters_to_be_escaped: Option<&CFString>,
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCreateStringByAddingPercentEscapes(
            allocator: Option<&CFAllocator>,
            original_string: Option<&CFString>,
            characters_to_leave_unescaped: Option<&CFString>,
            legal_url_characters_to_be_escaped: Option<&CFString>,
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFURLCreateStringByAddingPercentEscapes(
            allocator,
            original_string,
            characters_to_leave_unescaped,
            legal_url_characters_to_be_escaped,
            encoding,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::is_file_reference_url`"]
#[inline]
pub extern "C-unwind" fn CFURLIsFileReferenceURL(url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLIsFileReferenceURL(url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLIsFileReferenceURL(url) };
    ret != 0
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFURL::new_file_reference_url`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFileReferenceURL(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFileReferenceURL(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateFileReferenceURL(allocator, url, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFURL::new_file_path_url`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFilePathURL(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFilePathURL(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateFilePathURL(allocator, url, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFURL::resource_property_for_key`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyResourcePropertyForKey(
    url: &CFURL,
    key: Option<&CFString>,
    property_value_type_ref_ptr: *mut c_void,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLCopyResourcePropertyForKey(
            url: &CFURL,
            key: Option<&CFString>,
            property_value_type_ref_ptr: *mut c_void,
            error: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret =
        unsafe { CFURLCopyResourcePropertyForKey(url, key, property_value_type_ref_ptr, error) };
    ret != 0
}

#[cfg(all(feature = "CFArray", feature = "CFDictionary", feature = "CFError"))]
#[deprecated = "renamed to `CFURL::resource_properties_for_keys`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyResourcePropertiesForKeys(
    url: &CFURL,
    keys: Option<&CFArray>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFURLCopyResourcePropertiesForKeys(
            url: &CFURL,
            keys: Option<&CFArray>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFURLCopyResourcePropertiesForKeys(url, keys, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFURL::set_resource_property_for_key`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLSetResourcePropertyForKey(
    url: &CFURL,
    key: Option<&CFString>,
    property_value: Option<&CFType>,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLSetResourcePropertyForKey(
            url: &CFURL,
            key: Option<&CFString>,
            property_value: Option<&CFType>,
            error: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret = unsafe { CFURLSetResourcePropertyForKey(url, key, property_value, error) };
    ret != 0
}

#[cfg(all(feature = "CFDictionary", feature = "CFError"))]
#[deprecated = "renamed to `CFURL::set_resource_properties_for_keys`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLSetResourcePropertiesForKeys(
    url: &CFURL,
    keyed_property_values: Option<&CFDictionary>,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLSetResourcePropertiesForKeys(
            url: &CFURL,
            keyed_property_values: Option<&CFDictionary>,
            error: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret = unsafe { CFURLSetResourcePropertiesForKeys(url, keyed_property_values, error) };
    ret != 0
}

#[deprecated = "renamed to `CFURL::clear_resource_property_cache_for_key`"]
#[inline]
pub extern "C-unwind" fn CFURLClearResourcePropertyCacheForKey(
    url: &CFURL,
    key: Option<&CFString>,
) {
    extern "C-unwind" {
        fn CFURLClearResourcePropertyCacheForKey(url: &CFURL, key: Option<&CFString>);
    }
    unsafe { CFURLClearResourcePropertyCacheForKey(url, key) }
}

#[deprecated = "renamed to `CFURL::clear_resource_property_cache`"]
#[inline]
pub extern "C-unwind" fn CFURLClearResourcePropertyCache(url: &CFURL) {
    extern "C-unwind" {
        fn CFURLClearResourcePropertyCache(url: &CFURL);
    }
    unsafe { CFURLClearResourcePropertyCache(url) }
}

#[deprecated = "renamed to `CFURL::set_temporary_resource_property_for_key`"]
#[inline]
pub extern "C-unwind" fn CFURLSetTemporaryResourcePropertyForKey(
    url: &CFURL,
    key: Option<&CFString>,
    property_value: Option<&CFType>,
) {
    extern "C-unwind" {
        fn CFURLSetTemporaryResourcePropertyForKey(
            url: &CFURL,
            key: Option<&CFString>,
            property_value: Option<&CFType>,
        );
    }
    unsafe { CFURLSetTemporaryResourcePropertyForKey(url, key, property_value) }
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFURL::resource_is_reachable`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLResourceIsReachable(
    url: &CFURL,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLResourceIsReachable(url: &CFURL, error: *mut *mut CFError) -> Boolean;
    }
    let ret = unsafe { CFURLResourceIsReachable(url, error) };
    ret != 0
}

#[cfg(all(feature = "CFArray", feature = "CFData", feature = "CFError"))]
#[deprecated = "renamed to `CFURL::new_bookmark_data`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateBookmarkData(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    options: CFURLBookmarkCreationOptions,
    resource_properties_to_include: Option<&CFArray>,
    relative_to_url: Option<&CFURL>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateBookmarkData(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            options: CFURLBookmarkCreationOptions,
            resource_properties_to_include: Option<&CFArray>,
            relative_to_url: Option<&CFURL>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe {
        CFURLCreateBookmarkData(
            allocator,
            url,
            options,
            resource_properties_to_include,
            relative_to_url,
            error,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFData", feature = "CFError"))]
#[deprecated = "renamed to `CFURL::new_by_resolving_bookmark_data`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateByResolvingBookmarkData(
    allocator: Option<&CFAllocator>,
    bookmark: Option<&CFData>,
    options: CFURLBookmarkResolutionOptions,
    relative_to_url: Option<&CFURL>,
    resource_properties_to_include: Option<&CFArray>,
    is_stale: *mut Boolean,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateByResolvingBookmarkData(
            allocator: Option<&CFAllocator>,
            bookmark: Option<&CFData>,
            options: CFURLBookmarkResolutionOptions,
            relative_to_url: Option<&CFURL>,
            resource_properties_to_include: Option<&CFArray>,
            is_stale: *mut Boolean,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateByResolvingBookmarkData(
            allocator,
            bookmark,
            options,
            relative_to_url,
            resource_properties_to_include,
            is_stale,
            error,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFData", feature = "CFDictionary"))]
#[deprecated = "renamed to `CFURL::new_resource_properties_for_keys_from_bookmark_data`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateResourcePropertiesForKeysFromBookmarkData(
    allocator: Option<&CFAllocator>,
    resource_properties_to_return: Option<&CFArray>,
    bookmark: Option<&CFData>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFURLCreateResourcePropertiesForKeysFromBookmarkData(
            allocator: Option<&CFAllocator>,
            resource_properties_to_return: Option<&CFArray>,
            bookmark: Option<&CFData>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe {
        CFURLCreateResourcePropertiesForKeysFromBookmarkData(
            allocator,
            resource_properties_to_return,
            bookmark,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFURL::new_resource_property_for_key_from_bookmark_data`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateResourcePropertyForKeyFromBookmarkData(
    allocator: Option<&CFAllocator>,
    resource_property_key: Option<&CFString>,
    bookmark: Option<&CFData>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFURLCreateResourcePropertyForKeyFromBookmarkData(
            allocator: Option<&CFAllocator>,
            resource_property_key: Option<&CFString>,
            bookmark: Option<&CFData>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe {
        CFURLCreateResourcePropertyForKeyFromBookmarkData(
            allocator,
            resource_property_key,
            bookmark,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFData", feature = "CFError"))]
#[deprecated = "renamed to `CFURL::new_bookmark_data_from_file`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateBookmarkDataFromFile(
    allocator: Option<&CFAllocator>,
    file_url: Option<&CFURL>,
    error_ref: *mut *mut CFError,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateBookmarkDataFromFile(
            allocator: Option<&CFAllocator>,
            file_url: Option<&CFURL>,
            error_ref: *mut *mut CFError,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFURLCreateBookmarkDataFromFile(allocator, file_url, error_ref) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFData", feature = "CFError"))]
#[deprecated = "renamed to `CFURL::write_bookmark_data_to_file`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLWriteBookmarkDataToFile(
    bookmark_ref: Option<&CFData>,
    file_url: Option<&CFURL>,
    options: CFURLBookmarkFileCreationOptions,
    error_ref: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLWriteBookmarkDataToFile(
            bookmark_ref: Option<&CFData>,
            file_url: Option<&CFURL>,
            options: CFURLBookmarkFileCreationOptions,
            error_ref: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret = unsafe { CFURLWriteBookmarkDataToFile(bookmark_ref, file_url, options, error_ref) };
    ret != 0
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFURL::new_bookmark_data_from_alias_record`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateBookmarkDataFromAliasRecord(
    allocator_ref: Option<&CFAllocator>,
    alias_record_data_ref: Option<&CFData>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateBookmarkDataFromAliasRecord(
            allocator_ref: Option<&CFAllocator>,
            alias_record_data_ref: Option<&CFData>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret =
        unsafe { CFURLCreateBookmarkDataFromAliasRecord(allocator_ref, alias_record_data_ref) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFURL::start_accessing_security_scoped_resource`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLStartAccessingSecurityScopedResource(url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLStartAccessingSecurityScopedResource(url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLStartAccessingSecurityScopedResource(url) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFURL::stop_accessing_security_scoped_resource`"]
    pub fn CFURLStopAccessingSecurityScopedResource(url: &CFURL);
}
