; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=powerpc64le < %s | FileCheck %s

; Tests from pr85066
define i64 @test_shl_zext_cttz(i16 %x) {
; CHECK-LABEL: test_shl_zext_cttz:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    oris 3, 3, 1
; CHECK-NEXT:    neg 4, 3
; CHECK-NEXT:    and 3, 3, 4
; CHECK-NEXT:    clrldi 3, 3, 32
; CHECK-NEXT:    blr
entry:
  %cttz = tail call i16 @llvm.cttz.i16(i16 %x, i1 false)
  %zext = zext i16 %cttz to i64
  %res = shl i64 1, %zext
  ret i64 %res
}

define i64 @test_shl_zext_cttz_zero_is_poison(i16 %x) {
; CHECK-LABEL: test_shl_zext_cttz_zero_is_poison:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    neg 4, 3
; CHECK-NEXT:    and 3, 3, 4
; CHECK-NEXT:    clrldi 3, 3, 32
; CHECK-NEXT:    blr
entry:
  %cttz = tail call i16 @llvm.cttz.i16(i16 %x, i1 true)
  %zext = zext i16 %cttz to i64
  %res = shl i64 1, %zext
  ret i64 %res
}

define i16 @test_shl_trunc_cttz(i32 %x) {
; CHECK-LABEL: test_shl_trunc_cttz:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    neg 4, 3
; CHECK-NEXT:    and 3, 3, 4
; CHECK-NEXT:    blr
entry:
  %cttz = tail call i32 @llvm.cttz.i32(i32 %x, i1 false)
  %trunc = trunc i32 %cttz to i16
  %res = shl i16 1, %trunc
  ret i16 %res
}
