/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Maxim MAX77705 definitions.
 *
 * Copyright (C) 2015 Samsung Electronics, Inc.
 * Copyright (C) 2025 Dzmitry Sankouski <dsankouski@gmail.com>
 */

#ifndef __MAX77705_CHARGER_H
#define __MAX77705_CHARGER_H __FILE__

/* MAX77705_CHG_REG_CHG_INT */
#define MAX77705_BYP_I		BIT(0)
#define MAX77705_INP_LIMIT_I	BIT(1)
#define MAX77705_BATP_I		BIT(2)
#define MAX77705_BAT_I		BIT(3)
#define MAX77705_CHG_I		BIT(4)
#define MAX77705_WCIN_I		BIT(5)
#define MAX77705_CHGIN_I	BIT(6)
#define MAX77705_AICL_I		BIT(7)

/* MAX77705_CHG_REG_CHG_INT_MASK */
#define MAX77705_BYP_IM		BIT(0)
#define MAX77705_INP_LIMIT_IM	BIT(1)
#define MAX77705_BATP_IM	BIT(2)
#define MAX77705_BAT_IM		BIT(3)
#define MAX77705_CHG_IM		BIT(4)
#define MAX77705_WCIN_IM	BIT(5)
#define MAX77705_CHGIN_IM	BIT(6)
#define MAX77705_AICL_IM	BIT(7)

/* MAX77705_CHG_REG_CHG_INT_OK */
#define MAX77705_BYP_OK		BIT(0)
#define MAX77705_DISQBAT_OK	BIT(1)
#define MAX77705_BATP_OK	BIT(2)
#define MAX77705_BAT_OK		BIT(3)
#define MAX77705_CHG_OK		BIT(4)
#define MAX77705_WCIN_OK	BIT(5)
#define MAX77705_CHGIN_OK	BIT(6)
#define MAX77705_AICL_OK	BIT(7)

/* MAX77705_CHG_REG_DETAILS_00 */
#define MAX77705_BATP_DTLS		BIT(0)
#define MAX77705_WCIN_DTLS		GENMASK(4, 3)
#define MAX77705_WCIN_DTLS_SHIFT	3
#define MAX77705_CHGIN_DTLS		GENMASK(6, 5)
#define MAX77705_CHGIN_DTLS_SHIFT	5

/* MAX77705_CHG_REG_DETAILS_01 */
#define MAX77705_CHG_DTLS	GENMASK(3, 0)
#define MAX77705_CHG_DTLS_SHIFT	0
#define MAX77705_BAT_DTLS	GENMASK(6, 4)
#define MAX77705_BAT_DTLS_SHIFT	4

/* MAX77705_CHG_REG_DETAILS_02 */
#define MAX77705_BYP_DTLS	GENMASK(3, 0)
#define MAX77705_BYP_DTLS_SHIFT	0

/* MAX77705_CHG_REG_CNFG_00 */
#define MAX77705_CHG_SHIFT	0
#define MAX77705_UNO_SHIFT	1
#define MAX77705_OTG_SHIFT	1
#define MAX77705_BUCK_SHIFT	2
#define MAX77705_BOOST_SHIFT	3
#define MAX77705_WDTEN_SHIFT	4
#define MAX77705_MODE_MASK	GENMASK(3, 0)
#define MAX77705_CHG_MASK	BIT(MAX77705_CHG_SHIFT)
#define MAX77705_UNO_MASK	BIT(MAX77705_UNO_SHIFT)
#define MAX77705_OTG_MASK	BIT(MAX77705_OTG_SHIFT)
#define MAX77705_BUCK_MASK	BIT(MAX77705_BUCK_SHIFT)
#define MAX77705_BOOST_MASK	BIT(MAX77705_BOOST_SHIFT)
#define MAX77705_WDTEN_MASK	BIT(MAX77705_WDTEN_SHIFT)
#define MAX77705_UNO_CTRL	(MAX77705_UNO_MASK | MAX77705_BOOST_MASK)
#define MAX77705_OTG_CTRL	(MAX77705_OTG_MASK | MAX77705_BOOST_MASK)

/* MAX77705_CHG_REG_CNFG_01 */
#define MAX77705_FCHGTIME_SHIFT		0
#define MAX77705_FCHGTIME_MASK		GENMASK(2, 0)
#define MAX77705_CHG_RSTRT_SHIFT	4
#define MAX77705_CHG_RSTRT_MASK		GENMASK(5, 4)
#define MAX77705_FCHGTIME_DISABLE	0
#define MAX77705_CHG_RSTRT_DISABLE	0x3

#define MAX77705_PQEN_SHIFT		7
#define MAX77705_PQEN_MASK		BIT(7)
#define MAX77705_CHG_PQEN_DISABLE	0
#define MAX77705_CHG_PQEN_ENABLE	1

/* MAX77705_CHG_REG_CNFG_02 */
#define MAX77705_OTG_ILIM_SHIFT		6
#define MAX77705_OTG_ILIM_MASK		GENMASK(7, 6)
#define MAX77705_OTG_ILIM_500		0
#define MAX77705_OTG_ILIM_900		1
#define MAX77705_OTG_ILIM_1200		2
#define MAX77705_OTG_ILIM_1500		3
#define MAX77705_CHG_CC			GENMASK(5, 0)

/* MAX77705_CHG_REG_CNFG_03 */
#define MAX77705_TO_ITH_SHIFT		0
#define MAX77705_TO_ITH_MASK		GENMASK(2, 0)
#define MAX77705_TO_TIME_SHIFT		3
#define MAX77705_TO_TIME_MASK		GENMASK(5, 3)
#define MAX77705_SYS_TRACK_DIS_SHIFT	7
#define MAX77705_SYS_TRACK_DIS_MASK	BIT(7)
#define MAX77705_TO_ITH_150MA		0
#define MAX77705_TO_TIME_30M		3
#define MAX77705_SYS_TRACK_ENABLE	0
#define MAX77705_SYS_TRACK_DISABLE	1

/* MAX77705_CHG_REG_CNFG_04 */
#define MAX77705_CHG_MINVSYS_SHIFT	6
#define MAX77705_CHG_MINVSYS_MASK	GENMASK(7, 6)
#define MAX77705_CHG_PRM_SHIFT		0
#define MAX77705_CHG_PRM_MASK		GENMASK(5, 0)

#define MAX77705_CHG_CV_PRM_SHIFT	0
#define MAX77705_CHG_CV_PRM_MASK	GENMASK(5, 0)

/* MAX77705_CHG_REG_CNFG_05 */
#define MAX77705_REG_B2SOVRC_SHIFT	0
#define MAX77705_REG_B2SOVRC_MASK	GENMASK(3, 0)
#define MAX77705_B2SOVRC_DISABLE	0
#define MAX77705_B2SOVRC_4_5A		6
#define MAX77705_B2SOVRC_4_8A		8
#define MAX77705_B2SOVRC_5_0A		9

/* MAX77705_CHG_CNFG_06 */
#define MAX77705_WDTCLR_SHIFT		0
#define MAX77705_WDTCLR_MASK		GENMASK(1, 0)
#define MAX77705_WDTCLR			1
#define MAX77705_CHGPROT_MASK		GENMASK(3, 2)
#define MAX77705_CHGPROT_UNLOCKED	GENMASK(3, 2)
#define MAX77705_SLOWEST_LX_SLOPE	GENMASK(6, 5)

/* MAX77705_CHG_REG_CNFG_07 */
#define MAX77705_CHG_FMBST		4
#define MAX77705_REG_FMBST_SHIFT	2
#define MAX77705_REG_FMBST_MASK		BIT(MAX77705_REG_FMBST_SHIFT)
#define MAX77705_REG_FGSRC_SHIFT	1
#define MAX77705_REG_FGSRC_MASK		BIT(MAX77705_REG_FGSRC_SHIFT)

/* MAX77705_CHG_REG_CNFG_08 */
#define MAX77705_REG_FSW_SHIFT		0
#define MAX77705_REG_FSW_MASK		GENMASK(1, 0)
#define MAX77705_CHG_FSW_3MHz		0
#define MAX77705_CHG_FSW_2MHz		1
#define MAX77705_CHG_FSW_1_5MHz		2

/* MAX77705_CHG_REG_CNFG_09 */
#define MAX77705_CHG_CHGIN_LIM_MASK		GENMASK(6, 0)
#define MAX77705_CHG_EN_MASK			BIT(7)
#define MAX77705_CHG_DISABLE			0
#define MAX77705_CHARGER_CHG_CHARGING(_reg) \
				(((_reg) & MAX77705_CHG_EN_MASK) > 1)


/* MAX77705_CHG_REG_CNFG_10 */
#define MAX77705_CHG_WCIN_LIM		GENMASK(5, 0)

/* MAX77705_CHG_REG_CNFG_11 */
#define MAX77705_VBYPSET_SHIFT		0
#define MAX77705_VBYPSET_MASK		GENMASK(6, 0)

/* MAX77705_CHG_REG_CNFG_12 */
#define MAX77705_CHGINSEL_SHIFT		5
#define MAX77705_CHGINSEL_MASK		BIT(MAX77705_CHGINSEL_SHIFT)
#define MAX77705_WCINSEL_SHIFT		6
#define MAX77705_WCINSEL_MASK		BIT(MAX77705_WCINSEL_SHIFT)
#define MAX77705_VCHGIN_REG_MASK	GENMASK(4, 3)
#define MAX77705_WCIN_REG_MASK		GENMASK(2, 1)
#define MAX77705_REG_DISKIP_SHIFT	0
#define MAX77705_REG_DISKIP_MASK	BIT(MAX77705_REG_DISKIP_SHIFT)
/* REG=4.5V, UVLO=4.7V */
#define MAX77705_VCHGIN_4_5		0
/* REG=4.5V, UVLO=4.7V */
#define MAX77705_WCIN_4_5		0
#define MAX77705_DISABLE_SKIP		1
#define MAX77705_AUTO_SKIP		0

/* uA */
#define MAX77705_CURRENT_CHGIN_STEP	25000
#define MAX77705_CURRENT_CHG_STEP	50000
#define MAX77705_CURRENT_CHGIN_MIN	100000
#define MAX77705_CURRENT_CHGIN_MAX	3200000

struct max77705_charger_data {
	struct device			*dev;
	struct regmap		*regmap;
	struct power_supply_battery_info *bat_info;
	struct workqueue_struct *wqueue;
	struct work_struct	chgin_work;
	struct power_supply	*psy_chg;
};

#endif /* __MAX77705_CHARGER_H */
