# Northern Andes

## Introduction

The Northern Andes have a complex laboratory that teaches us about the different sciences that humanity has contemplated in its history; starting from observation to the various elements that surround us, with the need to ensure our survival as a species and lineage, the human being learned to understand the signals that the cosmos, plants, animals, the climate and other elements emit constantly. Then the wise learned to warn about the changes that affect living beings.

## Description

In order to replicate the ancestral measurements in the Andean observatories, we propose the use of a wide-mouth container; in the open we will place it and level properly. In order to create a star mirror we will fill it with water, in this reflection of the sky, the Andean sage can admire and record the movements of the sun, the moon, planets or the stars.

The Stellarium simulator allows us to recreate these "cosmic mirrors" and analyze the specific stellar dynamics that are seen in the Northern Andes as well as the millenarian wise men in their patient observation through the ages. These beings have registered the cosmic movements in the current prehispanic heritage of the Andean peoples and produced graphic configurations, which after much joint work by several researchers in several generations at the beginning of the 21st century have been partially decoded.

Here we tell what we found in the equatorial skies:

### The Sun (Punchao o Wilca)

When we find ourselves in the center of the planet, the apparent movement that the sun makes through our annual journey around it is equidistant and proportional. At the equinoxes the sun will cross the center of the sky, on the solstice of June it will travel its southernmost road (it will go north) and on the solstice of December the northernmost path will be traveled (more to the south). These natural phenomena are the marks of the four main festivals that celebrate a specific part of the agricultural calendar because they are the points of inflection between the climatic seasons.

According to the colonial chronicler Juan de Betanzos "the Indians knew the leap years"; thanks to the research of Gustavo Guayasamín, a cyclic movement is identified in a four-year interval in the sun; to observe it, we suggest placing ourselves at the March equinox (approximately the March equinoxes are the 21st day in the Gregorian calendar), at the solar daytime (12:20 in the civil time for the year 2018). We can then move forward in time thanks to the "Date / Time Window" from year to year and we will notice that the sun moves, returning to the point where the observation begins in periods of four years, for example: It starts in 2016, moves to the left of the spectator in 2017, continues moving to the left in 2018, also moves in 2019 and in 2020 returns to its initial position; then start the cycle again.

### Clear Constellations, Asterisms and Guidelines in the Andes.

We consider that by means of "stellar mirrors" the sages could register the stellar traffic. Through this observation they noticed that during the nightfalls of each equinox and solstice, specific stars appear in the sky, as if they were marking the climatic changes to which we are exposed, so these cosmic signals were recorded in the Andean prehispanic patrimony giving rise to the Andean geometrical forms.

#### March Equinox

**"Antonio Quinatoa" Cross:** At dusk the first stars to appear are: Sirius - Procyon - Rigel - Betelgeuse, who form the cross named "Antonio Quinatoa". It is the constellation that governs the masculine cycle.

#### September Equinox

**Molestina Triangle:** The first stars to appear are: Altair - Vega - Antares who make up the triangle named "Molestina"

**Constellation Daniela Alejandra Ayala:** Thanks to the hard work in the registration of the designs, we have identified the clear constellation named "Daniela Alejandra Ayala", cosmic set that accompanies the image of the "Mono Andino", will appear in the center of the sky at nightfall of the female equinox.

#### June Solstice

**South Cross:** The most outstanding stars in the evening of the Summer Solstice for the Northern Hemisphere are: Acrux, Mimosa, δ Crucis, ζ Crucis, λ Crucis and μ Crucis who form the "Southern Cross".

#### December Solstice

**The “Jorge Trujillo” Arrow:** The most outstanding stars in the evening of the winter solstice for the southern hemisphere are Caph - Shedar - Navi - κ Cas, they are part of the western constellation of Cassiopeia, the resulting form evokes the shape of an arrow that at the end of the December solstice It is in an East - West direction.

The asterisms that we include are the first stars to appear at the end of each equinox or solstice. Like the constellations, these basic forms (diamond, square, triangle and arrow), mark the beginning or end of a cycle, apparently human beings discovered and recorded them before the forms in the dark constellations.

### The Sacred Beings in the Cosmos. The Dark Constellations.

#### The Milky Way

Our planet belongs to the galaxy of the Milky Way, whose shape is that of a large disk with two bulging arms; this form and the rotation of the earth means that at the evenings of the equinoxes and solstices we can appreciate a specific part of it, thus becoming a signal that the ancestors appreciated to measure the times. Called in the Andes as the "Muyun" for many peoples, it represents a gigantic life-giving serpent.

Contrary to the West, the constellations are not made up of bright points or stars; the astral beings are housed in the "dark spots" existing in the brilliance of the Milky Way, so at each of the turning points in our annual path around the sun (Solstices and Equinoxes), we will find a guiding constellation in each "visible end" of the galaxy. As with lunar or solar movements, the movements of the constellations in the Northern Andes marked the beginning or end of specific eras, agricultural, civil, reproductive or festive. They determined the fate of beings, receiving respect and veneration for those who came for their wisdom; thus developing a religious thought similar to that of the sun or the moon throughout the continent.

Here we describe the constellations decoded to date:

#### Dark Constellations

|Image|Description|
|-----|-----------|
|<img src="illustrations/jaguar.png" width="100" height="107" />|Estelina Quinatoa (The Jaguar): Constellation that governs the male cycle, also called "Wilca" or "Otorongo", indicates the arrival of the crops of tender grains.|
|<img src="illustrations/mono.png" width="100" height="107" />|Mercedes Cotacachi (The Monkey): Constellation that governs the female cycle, indicates the arrival of rains and the start of agricultural processes.|
|<img src="illustrations/sapo.png" width="100" height="107" />|Hernán Crespo Toral (The Frog): The "Hampatu" is the animal that has several stages, like the Andean thought, it appears on the night of the June solstice and it is related to the contact with the world of the dead.|
|<img src="illustrations/guerrero.png" width="100" height="107" />|Ana Jaramillo de Velasteguí (The Warrior): Known as "the Man and the Spear" or "The Dancer", the constellation governs the December solstice.|

## Authors

These constellations, asterisms and measurements are part of **the legacy of Ancestral Knowledge** protected and compiled by the **Clan Quinatoa, guardians of the millenary knowledge of the Lundauco Valley in Imbabura - Ecuador**
.
The astral information is based on the study of Andrés Alejandro Ayala Quinatoa in "Millenary Astronomy, what my teachers and ancestors taught me"; Servio Jr. Paladines collaborates for the computer integration.

The present illustrations are inspired by the pre-Hispanic designs of the Pasto nation investigated by Estelina Quinatoa for the book "Ancestral Representations and Colors of the Cosmos" (Ministry of Culture and Heritage of Ecuador).

## License

GNU GPL v2.0
