\name{CompositeTransform}
\alias{CompositeTransform}
\title{CompositeTransform}
\Rdversion{1.1}
\docType{class}
\description{
This class contains a stack of transforms and concatenates them by
composition.
CompositeTransform}
\details{
The transforms are composed in reverse order with the back being applied first: \eqn{ T_0 o T_1 = T_0(T_1(x)) } Transforms are stored in a queue, in the following order: \eqn{ T_0, T_1, ... , T_N-1 }
Transforms are added via AddTransform(). This adds the transforms to the back of the queue.
The only parameters of the transform at the back of the queue are
exposed and optimizable for registration.
Inverse: The inverse transform is created by retrieving the inverse
from each sub transform and adding them to a composite transform in
reverse order. The m_TransformsToOptimizeFlags is copied in reverse
for the inverse.
See:
itk::CompositeTransform
CompositeTransform}
%C++ includes: sitkCompositeTransform.h
\section{Methods}{
\describe{
\item{Self AddTransform(Transform t):}{
Add a transform to the back of the stack.
A deep-copy of the transform is performed. The added transform will
have the optimizable parameters, while the other parameters are part
of the fixed parameters.
}
\item{void ClearTransforms():}{
Remove all transforms from the stack.
}
\item{ CompositeTransform(const CompositeTransform &):}{
A lazy copy constructor.
The new SimpleITK object will reference to the same underlying ITK CompositeTransform. A deep-copy will be made when the object is modified.
}
\item{ CompositeTransform(const std::vector< Transform > &):}{
Create a composite from a vector of Transform.
The CompositeTransform is constructed from deep copies of the Transforms. If the vector
contains additional composite transforms, deep copies will be made and
nested composite transforms will be constructed.
An exception is thrown if the vector is empty.
}
\item{ CompositeTransform(const Transform &):}{
Create CompositeTransform converted or holding the transform argument.
If the Transform is internally a CompositeTransform, a shallow copy to the internal transform will be made. Otherwise a
new CompositeTransform is constructed which holds the transform argument.
}
\item{ CompositeTransform(unsigned int dimensions):}{
Construct an empty CompositeTransform.
The created CompositeTransform is initialized with zero transforms. Additional transforms of
dimensions can be added.
}
\item{Self FlattenTransform():}{
Removes nested composite transforms.
If this transform contains additional composite transforms, then these
nested composite transformed are removed, while preserving the order
of the regular transforms and transferring ownership to the parent CompositeTransform.
Nested composite transform may not be written to a file.
}
\item{Transform GetBackTransform():}{
Get a copy of the back transform.
If the stack is empty an exception will be thrown.
}
\item{std::string GetName() const override:}{
Name of this class
}
\item{Transform GetNthTransform(unsigned int n):}{
Get a copy of a transform in the stack.
If n is equal or greater than the number of transforms, then an
exception will be thrown.
}
\item{unsigned int GetNumberOfTransforms() const:}{
The number of transforms in the stack.
}
\item{void RemoveTransform():}{
Remove the active transform at the back.
If the stack is empty an exception will be thrown.
}
\item{ ~CompositeTransform() override:}{}
}
}
