# The PEP 484 type hints stub file for the QtWebEngineQuick module.
#
# Generated by SIP 6.13.1
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-WebEngine.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtNetwork
from PyQt6 import QtQml
from PyQt6 import QtGui
from PyQt6 import QtWebChannel
from PyQt6 import QtWebEngineCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QQuickWebEngineProfile(QtCore.QObject):

    class PersistentPermissionsPolicy(enum.Enum):
        AskEveryTime = ... # type: QQuickWebEngineProfile.PersistentPermissionsPolicy
        StoreInMemory = ... # type: QQuickWebEngineProfile.PersistentPermissionsPolicy
        StoreOnDisk = ... # type: QQuickWebEngineProfile.PersistentPermissionsPolicy

    class PersistentCookiesPolicy(enum.Enum):
        NoPersistentCookies = ... # type: QQuickWebEngineProfile.PersistentCookiesPolicy
        AllowPersistentCookies = ... # type: QQuickWebEngineProfile.PersistentCookiesPolicy
        ForcePersistentCookies = ... # type: QQuickWebEngineProfile.PersistentCookiesPolicy

    class HttpCacheType(enum.Enum):
        MemoryHttpCache = ... # type: QQuickWebEngineProfile.HttpCacheType
        DiskHttpCache = ... # type: QQuickWebEngineProfile.HttpCacheType
        NoCache = ... # type: QQuickWebEngineProfile.HttpCacheType

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, storageName: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def extensionManager(self) -> typing.Optional[QtWebEngineCore.QWebEngineExtensionManager]: ...
    persistentPermissionsPolicyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def listPermissionsForPermissionType(self, permissionType: QtWebEngineCore.QWebEnginePermission.PermissionType) -> list[QtWebEngineCore.QWebEnginePermission]: ...
    def listPermissionsForOrigin(self, securityOrigin: QtCore.QUrl) -> list[QtWebEngineCore.QWebEnginePermission]: ...
    def listAllPermissions(self) -> list[QtWebEngineCore.QWebEnginePermission]: ...
    def queryPermission(self, securityOrigin: QtCore.QUrl, permissionType: QtWebEngineCore.QWebEnginePermission.PermissionType) -> QtWebEngineCore.QWebEnginePermission: ...
    def clientHints(self) -> typing.Optional[QtWebEngineCore.QWebEngineClientHints]: ...
    def setPersistentPermissionsPolicy(self, a0: 'QQuickWebEngineProfile.PersistentPermissionsPolicy') -> None: ...
    def persistentPermissionsPolicy(self) -> 'QQuickWebEngineProfile.PersistentPermissionsPolicy': ...
    clearHttpCacheCompleted: typing.ClassVar[QtCore.pyqtSignal]
    pushServiceEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setPushServiceEnabled(self, enable: bool) -> None: ...
    def isPushServiceEnabled(self) -> bool: ...
    presentNotification: typing.ClassVar[QtCore.pyqtSignal]
    downloadPathChanged: typing.ClassVar[QtCore.pyqtSignal]
    def clientCertificateStore(self) -> typing.Optional[QtWebEngineCore.QWebEngineClientCertificateStore]: ...
    def setDownloadPath(self, path: typing.Optional[str]) -> None: ...
    def downloadPath(self) -> str: ...
    spellCheckEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    spellCheckLanguagesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isSpellCheckEnabled(self) -> bool: ...
    def setSpellCheckEnabled(self, enabled: bool) -> None: ...
    def spellCheckLanguages(self) -> list[str]: ...
    def setSpellCheckLanguages(self, languages: collections.abc.Iterable[typing.Optional[str]]) -> None: ...
    httpAcceptLanguageChanged: typing.ClassVar[QtCore.pyqtSignal]
    httpCacheMaximumSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    persistentCookiesPolicyChanged: typing.ClassVar[QtCore.pyqtSignal]
    httpCacheTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    httpUserAgentChanged: typing.ClassVar[QtCore.pyqtSignal]
    cachePathChanged: typing.ClassVar[QtCore.pyqtSignal]
    persistentStoragePathChanged: typing.ClassVar[QtCore.pyqtSignal]
    offTheRecordChanged: typing.ClassVar[QtCore.pyqtSignal]
    storageNameChanged: typing.ClassVar[QtCore.pyqtSignal]
    @staticmethod
    def defaultProfile() -> typing.Optional['QQuickWebEngineProfile']: ...
    def clearHttpCache(self) -> None: ...
    def removeAllUrlSchemeHandlers(self) -> None: ...
    def removeUrlSchemeHandler(self, a0: typing.Optional[QtWebEngineCore.QWebEngineUrlSchemeHandler]) -> None: ...
    def removeUrlScheme(self, scheme: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def installUrlSchemeHandler(self, scheme: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview], a1: typing.Optional[QtWebEngineCore.QWebEngineUrlSchemeHandler]) -> None: ...
    def urlSchemeHandler(self, a0: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> typing.Optional[QtWebEngineCore.QWebEngineUrlSchemeHandler]: ...
    def setUrlRequestInterceptor(self, interceptor: typing.Optional[QtWebEngineCore.QWebEngineUrlRequestInterceptor]) -> None: ...
    def cookieStore(self) -> typing.Optional[QtWebEngineCore.QWebEngineCookieStore]: ...
    def setHttpAcceptLanguage(self, httpAcceptLanguage: typing.Optional[str]) -> None: ...
    def httpAcceptLanguage(self) -> str: ...
    def setHttpCacheMaximumSize(self, maxSize: int) -> None: ...
    def httpCacheMaximumSize(self) -> int: ...
    def setPersistentCookiesPolicy(self, a0: 'QQuickWebEngineProfile.PersistentCookiesPolicy') -> None: ...
    def persistentCookiesPolicy(self) -> 'QQuickWebEngineProfile.PersistentCookiesPolicy': ...
    def setHttpCacheType(self, a0: 'QQuickWebEngineProfile.HttpCacheType') -> None: ...
    def httpCacheType(self) -> 'QQuickWebEngineProfile.HttpCacheType': ...
    def setHttpUserAgent(self, userAgent: typing.Optional[str]) -> None: ...
    def httpUserAgent(self) -> str: ...
    def setCachePath(self, path: typing.Optional[str]) -> None: ...
    def cachePath(self) -> str: ...
    def setPersistentStoragePath(self, path: typing.Optional[str]) -> None: ...
    def persistentStoragePath(self) -> str: ...
    def setOffTheRecord(self, offTheRecord: bool) -> None: ...
    def isOffTheRecord(self) -> bool: ...
    def setStorageName(self, name: typing.Optional[str]) -> None: ...
    def storageName(self) -> str: ...


class QtWebEngineQuick(PyQt6.sip.simplewrapper):

    def initialize(self) -> None: ...
