/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.repo.ClonePathProvider;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.FilePathDocumentChildPathHandle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001=B3\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eB)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000fJ\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006H\u0002J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H&J\u0006\u00107\u001a\u00020\u0006J\u0010\u00108\u001a\u0002042\u0006\u0010+\u001a\u00020\u0006H\u0016J\u0006\u00109\u001a\u00020\u0006J\b\u0010:\u001a\u000204H\u0016J\b\u0010;\u001a\u00020/H\u0015J\u0010\u0010<\u001a\u0002042\u0006\u0010\t\u001a\u00020\nH\u0005R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006>"}, d2={"Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent;", "Lcom/intellij/openapi/vcs/ui/VcsCloneComponent;", "Lcom/intellij/openapi/vcs/ui/VcsCloneComponent$WithSettableUrl;", "project", "Lcom/intellij/openapi/project/Project;", "vcsDirectoryName", "", "rememberedInputs", "Lcom/intellij/dvcs/DvcsRememberedInputs;", "dialogStateListener", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;", "mainPanelCustomizer", "Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent$MainPanelCustomizer;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/dvcs/DvcsRememberedInputs;Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent$MainPanelCustomizer;)V", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/dvcs/DvcsRememberedInputs;Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "getRememberedInputs", "()Lcom/intellij/dvcs/DvcsRememberedInputs;", "getMainPanelCustomizer", "()Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent$MainPanelCustomizer;", "mainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getMainPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "urlEditor", "Lcom/intellij/ui/TextFieldWithHistory;", "directoryField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "cloneDirectoryChildHandle", "Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle;", "errorComponent", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getErrorComponent", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "setErrorComponent", "(Lcom/intellij/util/ui/components/BorderLayoutPanel;)V", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "defaultDirectoryPath", "url", "getView", "Ljavax/swing/JPanel;", "isOkEnabled", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "doClone", "", "listener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "getDirectory", "setUrl", "getUrl", "dispose", "isOkActionEnabled", "updateOkActionState", "MainPanelCustomizer", "intellij.platform.vcs.dvcs.impl"})
public abstract class DvcsCloneDialogComponent
implements VcsCloneComponent,
VcsCloneComponent.WithSettableUrl {
    @NotNull
    private Project project;
    @NotNull
    private String vcsDirectoryName;
    @NotNull
    private final DvcsRememberedInputs rememberedInputs;
    @NotNull
    private final VcsCloneDialogComponentStateListener dialogStateListener;
    @ApiStatus.Internal
    @Nullable
    private final MainPanelCustomizer mainPanelCustomizer;
    @NotNull
    private final DialogPanel mainPanel;
    @NotNull
    private final TextFieldWithHistory urlEditor;
    @NotNull
    private final TextFieldWithBrowseButton directoryField;
    @NotNull
    private final FilePathDocumentChildPathHandle cloneDirectoryChildHandle;
    protected BorderLayoutPanel errorComponent;

    @ApiStatus.Internal
    public DvcsCloneDialogComponent(@NotNull Project project, @NotNull String vcsDirectoryName, @NotNull DvcsRememberedInputs rememberedInputs, @NotNull VcsCloneDialogComponentStateListener dialogStateListener, @Nullable MainPanelCustomizer mainPanelCustomizer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcsDirectoryName, (String)"vcsDirectoryName");
        Intrinsics.checkNotNullParameter((Object)rememberedInputs, (String)"rememberedInputs");
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        this.project = project;
        this.vcsDirectoryName = vcsDirectoryName;
        this.rememberedInputs = rememberedInputs;
        this.dialogStateListener = dialogStateListener;
        this.mainPanelCustomizer = mainPanelCustomizer;
        this.urlEditor = new TextFieldWithHistory();
        this.directoryField = new TextFieldWithBrowseButton();
        Document document = this.directoryField.getTextField().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String string = ClonePathProvider.defaultParentDirectoryPath(this.project, this.rememberedInputs);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultParentDirectoryPath(...)");
        this.cloneDirectoryChildHandle = FilePathDocumentChildPathHandle.Companion.install(document, string);
        this.directoryField.addBrowseFolderListener(this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(DvcsBundle.message((String)"clone.destination.directory.browser.title", (Object[])new Object[0])).withDescription(DvcsBundle.message((String)"clone.destination.directory.browser.description", (Object[])new Object[0])).withShowFileSystemRoots(true).withHideIgnored(false));
        this.mainPanel = BuilderKt.panel(arg_0 -> DvcsCloneDialogComponent._init_$lambda$5(this, arg_0));
        this.mainPanel.registerValidators((Disposable)this);
        Insets insets = UIUtil.PANEL_REGULAR_INSETS;
        this.mainPanel.setBorder((Border)new JBEmptyBorder(insets.top / 2, insets.left, insets.bottom, insets.right));
        this.urlEditor.setHistory(this.rememberedInputs.getVisitedUrls());
        this.urlEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilePathDocumentChildPathHandle filePathDocumentChildPathHandle = cloneDirectoryChildHandle;
                String string = urlEditor.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                filePathDocumentChildPathHandle.trySetChildPath(this.defaultDirectoryPath(((Object)StringsKt.trim((CharSequence)string)).toString()));
                this.updateOkActionState(dialogStateListener);
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    protected final DvcsRememberedInputs getRememberedInputs() {
        return this.rememberedInputs;
    }

    @Nullable
    protected final MainPanelCustomizer getMainPanelCustomizer() {
        return this.mainPanelCustomizer;
    }

    @NotNull
    protected final DialogPanel getMainPanel() {
        return this.mainPanel;
    }

    @NotNull
    protected final BorderLayoutPanel getErrorComponent() {
        BorderLayoutPanel borderLayoutPanel = this.errorComponent;
        if (borderLayoutPanel != null) {
            return borderLayoutPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"errorComponent");
        return null;
    }

    protected final void setErrorComponent(@NotNull BorderLayoutPanel borderLayoutPanel) {
        Intrinsics.checkNotNullParameter((Object)borderLayoutPanel, (String)"<set-?>");
        this.errorComponent = borderLayoutPanel;
    }

    public DvcsCloneDialogComponent(@NotNull Project project, @NotNull String vcsDirectoryName, @NotNull DvcsRememberedInputs rememberedInputs, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcsDirectoryName, (String)"vcsDirectoryName");
        Intrinsics.checkNotNullParameter((Object)rememberedInputs, (String)"rememberedInputs");
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        this(project, vcsDirectoryName, rememberedInputs, dialogStateListener, null);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.urlEditor;
    }

    private final String defaultDirectoryPath(String url) {
        String string = StringUtil.trimEnd((String)ClonePathProvider.relativeDirectoryPathForVcsUrl(this.project, url), (String)this.vcsDirectoryName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        return string;
    }

    @NotNull
    public JPanel getView() {
        return (JPanel)this.mainPanel;
    }

    public boolean isOkEnabled() {
        return false;
    }

    @NotNull
    public List<ValidationInfo> doValidateAll() {
        return this.mainPanel.validateAll();
    }

    public abstract void doClone(@NotNull CheckoutProvider.Listener var1);

    @NotNull
    public final String getDirectory() {
        String string = this.directoryField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    public void setUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.urlEditor.setText(url);
    }

    @NotNull
    public final String getUrl() {
        String string = CloneDvcsValidationUtils.sanitizeCloneUrl(this.urlEditor.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeCloneUrl(...)");
        return string;
    }

    public void dispose() {
    }

    @RequiresEdt
    protected boolean isOkActionEnabled() {
        return !StringsKt.isBlank((CharSequence)this.getUrl());
    }

    @RequiresEdt
    protected final void updateOkActionState(@NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        dialogStateListener.onOkActionEnabled(this.isOkActionEnabled());
    }

    private static final ValidationInfo lambda$5$lambda$1$lambda$0(ValidationInfoBuilder $this$validationOnApply, TextFieldWithHistory it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JComponent jComponent = (JComponent)it;
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return CloneDvcsValidationUtils.checkRepositoryURL(jComponent, ((Object)StringsKt.trim((CharSequence)string)).toString());
    }

    private static final Unit lambda$5$lambda$1(DvcsCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.urlEditor).align((Align)AlignX.FILL.INSTANCE).validationOnApply(DvcsCloneDialogComponent::lambda$5$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo lambda$5$lambda$3$lambda$2(ValidationInfoBuilder $this$validationOnApply, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CloneDvcsValidationUtils.checkDirectory(it.getText(), it.getTextField());
    }

    private static final Unit lambda$5$lambda$3(DvcsCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.directoryField).align((Align)AlignX.FILL.INSTANCE).validationOnApply(DvcsCloneDialogComponent::lambda$5$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4(DvcsCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setErrorComponent(new BorderLayoutPanel(10, 0));
        $this$row.cell((JComponent)this$0.getErrorComponent()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(DvcsCloneDialogComponent this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = VcsBundle.message((String)"vcs.common.labels.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> DvcsCloneDialogComponent.lambda$5$lambda$1(this$0, arg_0));
        String string2 = VcsBundle.message((String)"vcs.common.labels.directory", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> DvcsCloneDialogComponent.lambda$5$lambda$3(this$0, arg_0)).bottomGap(BottomGap.SMALL);
        MainPanelCustomizer mainPanelCustomizer = this$0.mainPanelCustomizer;
        if (mainPanelCustomizer != null) {
            mainPanelCustomizer.configure($this$panel);
        }
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DvcsCloneDialogComponent.lambda$5$lambda$4(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent$MainPanelCustomizer;", "", "<init>", "()V", "configure", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "intellij.platform.vcs.dvcs.impl"})
    @ApiStatus.Internal
    public static abstract class MainPanelCustomizer {
        public abstract void configure(@NotNull Panel var1);
    }
}

