/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public final class OpenRepositoryVersionAction
extends AnAction
implements DumbAware {
    public OpenRepositoryVersionAction() {
        super(VcsBundle.messagePointer((String)"open.repository.version.text", (Object[])new Object[0]), VcsBundle.messagePointer((String)"open.repository.version.description", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        if (changes == null) {
            return;
        }
        OpenRepositoryVersionAction.openRepositoryVersion(project, changes);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        boolean isModalContext = e.getData(PlatformCoreDataKeys.IS_MODAL_CONTEXT) == Boolean.TRUE;
        boolean isEnabled = project != null && changes != null && !isModalContext && !CommittedChangesBrowserUseCase.IN_AIR.equals(e.getData(CommittedChangesBrowserUseCase.DATA_KEY)) && OpenRepositoryVersionAction.hasValidChanges(changes);
        e.getPresentation().setEnabled(isEnabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static boolean hasValidChanges(Change @NotNull [] changes) {
        if (changes == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists((Object[])changes, c -> c.getAfterRevision() != null && !c.getAfterRevision().getFile().isDirectory());
    }

    private static void openRepositoryVersion(@NotNull Project project, Change @NotNull [] changes) {
        if (project == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(4);
        }
        if (changes == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(5);
        }
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null || revision.getFile().isDirectory()) continue;
            ContentRevisionVirtualFile vFile = ContentRevisionVirtualFile.create(revision);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(project, (VirtualFile)vFile);
            navigatable.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/OpenRepositoryVersionAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/OpenRepositoryVersionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasValidChanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openRepositoryVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

