/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.util;

import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.filter.SecurityRequest;

public class AuthTokenUtils {
    private static final String ON_BEHALF_OF_SUFFIX = "api/generateonbehalfoftoken";
    private static final String ACCOUNT_SUFFIX = "api/account";

    public static Boolean isAccessToRestrictedEndpoints(SecurityRequest request, String suffix) {
        if (suffix == null) {
            return false;
        }
        switch (suffix) {
            case "api/generateonbehalfoftoken": {
                return request.method() == RestRequest.Method.POST;
            }
            case "api/account": {
                return request.method() == RestRequest.Method.PUT;
            }
        }
        return false;
    }

    public static Boolean isKeyNull(Settings settings, String key) {
        return settings.get(key) == null;
    }
}

