/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.TlsContext;

public class StsCredentialsProvider
extends CredentialsProvider {
    public static StsCredentialsProvider create() {
        return StsCredentialsProvider.builder().build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static byte[] toByteArray(String string) {
        return string == null ? null : string.getBytes(StandardCharsets.UTF_8);
    }

    private static long toNativeHandle(CrtResource crtResource) {
        return crtResource == null ? 0L : crtResource.getNativeHandle();
    }

    private StsCredentialsProvider(BuilderImpl builder) {
        try (ClientBootstrap bootstrap = builder.clientBootstrap == null ? new ClientBootstrap(null, null) : builder.clientBootstrap;){
            long nativeHandle = StsCredentialsProvider.stsCredentialsProviderNew(this, StsCredentialsProvider.toNativeHandle(bootstrap), StsCredentialsProvider.toNativeHandle(builder.tlsContext), builder.credsProvider.getNativeHandle(), StsCredentialsProvider.toByteArray(builder.roleArn), StsCredentialsProvider.toByteArray(builder.sessionName), builder.durationSeconds);
            this.acquireNativeHandle(nativeHandle);
            this.addReferenceTo(bootstrap);
            this.addReferenceTo(builder.tlsContext);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static native long stsCredentialsProviderNew(StsCredentialsProvider var0, long var1, long var3, long var5, byte[] var7, byte[] var8, int var9);

    static final class BuilderImpl
    implements Builder {
        private ClientBootstrap clientBootstrap;
        private TlsContext tlsContext;
        private CredentialsProvider credsProvider;
        private String roleArn;
        private String sessionName;
        private int durationSeconds;

        BuilderImpl() {
        }

        @Override
        public Builder withClientBootstrap(ClientBootstrap clientBootstrap) {
            this.clientBootstrap = clientBootstrap;
            return this;
        }

        @Override
        public Builder withTlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        @Override
        public Builder withCredsProvider(CredentialsProvider credsProvider) {
            this.credsProvider = credsProvider;
            return this;
        }

        @Override
        public Builder withRoleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder withSessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        @Override
        public Builder withDurationSeconds(int durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public StsCredentialsProvider build() {
            if (this.tlsContext == null) {
                throw new IllegalArgumentException("TlsContext must be provided");
            }
            return new StsCredentialsProvider(this);
        }
    }

    public static interface Builder {
        public Builder withClientBootstrap(ClientBootstrap var1);

        public Builder withTlsContext(TlsContext var1);

        public Builder withCredsProvider(CredentialsProvider var1);

        public Builder withRoleArn(String var1);

        public Builder withSessionName(String var1);

        public Builder withDurationSeconds(int var1);

        public StsCredentialsProvider build();
    }
}

