/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.jooq.BetweenAndStep;
import org.jooq.Binding;
import org.jooq.CaseValueStep;
import org.jooq.CaseWhenStep;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.DatePart;
import org.jooq.Field;
import org.jooq.LikeEscapeStep;
import org.jooq.Name;
import org.jooq.QuantifiedSelect;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.WindowIgnoreNullsStep;
import org.jooq.WindowPartitionByStep;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.BetweenCondition;
import org.jooq.impl.Cast;
import org.jooq.impl.Coerce;
import org.jooq.impl.CompareCondition;
import org.jooq.impl.ConstantSortField;
import org.jooq.impl.Contains;
import org.jooq.impl.ContainsIgnoreCase;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.Expression;
import org.jooq.impl.ExpressionOperator;
import org.jooq.impl.FieldAlias;
import org.jooq.impl.InCondition;
import org.jooq.impl.IsDistinctFrom;
import org.jooq.impl.IsNull;
import org.jooq.impl.Mod;
import org.jooq.impl.Neg;
import org.jooq.impl.QuantifiedComparisonCondition;
import org.jooq.impl.RegexpLike;
import org.jooq.impl.ScalarSubquery;
import org.jooq.impl.SortFieldImpl;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;
import org.jooq.tools.StringUtils;

abstract class AbstractField<T>
extends AbstractQueryPart
implements Field<T> {
    private static final long serialVersionUID = 2884811923648354905L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD};
    private final Name name;
    private final String comment;
    private final DataType<T> dataType;

    AbstractField(Name name, DataType<T> type) {
        this(name, type, null, type.getBinding());
    }

    AbstractField(Name name, DataType<T> type, String comment, Binding<?, T> binding) {
        this.name = name;
        this.comment = StringUtils.defaultString(comment);
        this.dataType = type.asConvertedDataType(binding);
    }

    @Override
    public abstract void accept(Context<?> var1);

    @Override
    public Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Field<T> field(Record record) {
        return record.field(this);
    }

    @Override
    public final T get(Record record) {
        return record.get(this);
    }

    @Override
    public final T getValue(Record record) {
        return record.getValue(this);
    }

    @Override
    public final T original(Record record) {
        return record.original(this);
    }

    @Override
    public final boolean changed(Record record) {
        return record.changed(this);
    }

    @Override
    public final void reset(Record record) {
        record.reset(this);
    }

    @Override
    public final Record1<T> from(Record record) {
        return record.into(this);
    }

    @Override
    public final Field<T> as(String alias) {
        return this.as(DSL.name(alias));
    }

    @Override
    public Field<T> as(Name alias) {
        return new FieldAlias(this, alias);
    }

    @Override
    public final Field<T> as(Field<?> otherField) {
        return this.as(otherField.getUnqualifiedName());
    }

    @Override
    public final Field<T> as(Function<? super Field<T>, ? extends String> aliasFunction) {
        return this.as(aliasFunction.apply(this));
    }

    @Override
    public final String getName() {
        return StringUtils.defaultIfNull(this.name.last(), "");
    }

    @Override
    public final Name getQualifiedName() {
        return this.name;
    }

    @Override
    public final Name getUnqualifiedName() {
        return this.name.unqualifiedName();
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public final Converter<?, T> getConverter() {
        return this.getBinding().converter();
    }

    @Override
    public final Binding<?, T> getBinding() {
        return this.dataType.getBinding();
    }

    @Override
    public final DataType<T> getDataType() {
        return this.dataType;
    }

    @Override
    public final DataType<T> getDataType(Configuration configuration) {
        return this.dataType.getDataType(configuration);
    }

    @Override
    public final Class<T> getType() {
        return this.dataType.getType();
    }

    @Override
    public final <Z> Field<Z> cast(Field<Z> field) {
        return this.cast(field.getDataType());
    }

    @Override
    public final <Z> Field<Z> cast(DataType<Z> type) {
        if (this.getDataType().equals(type)) {
            return this;
        }
        return new Cast<Z>(this, type);
    }

    @Override
    public final <Z> Field<Z> cast(Class<Z> type) {
        if (this.getType() == type) {
            return this;
        }
        return this.cast(DefaultDataType.getDataType(null, type));
    }

    @Override
    public final <Z> Field<Z> coerce(Field<Z> field) {
        return this.coerce(field.getDataType());
    }

    @Override
    public final <Z> Field<Z> coerce(DataType<Z> type) {
        if (this.getDataType().equals(type)) {
            return this;
        }
        return new Coerce<Z>(this, type);
    }

    @Override
    public final <Z> Field<Z> coerce(Class<Z> type) {
        return this.coerce(DefaultDataType.getDataType(null, type));
    }

    @Override
    public final SortField<T> asc() {
        return this.sort(SortOrder.ASC);
    }

    @Override
    public final SortField<T> desc() {
        return this.sort(SortOrder.DESC);
    }

    @Override
    public final SortField<T> sortDefault() {
        return this.sort(SortOrder.DEFAULT);
    }

    @Override
    public final SortField<T> sort(SortOrder order) {
        return new SortFieldImpl(this, order);
    }

    @Override
    public final SortField<Integer> sortAsc(Collection<T> sortList) {
        LinkedHashMap<T, Integer> map = new LinkedHashMap<T, Integer>();
        int i = 0;
        for (T value : sortList) {
            map.put(value, i++);
        }
        return this.sort(map);
    }

    @Override
    @SafeVarargs
    public final SortField<Integer> sortAsc(T ... sortList) {
        return this.sortAsc((Collection<T>)Arrays.asList(sortList));
    }

    @Override
    public final SortField<Integer> sortDesc(Collection<T> sortList) {
        LinkedHashMap<T, Integer> map = new LinkedHashMap<T, Integer>();
        int i = 0;
        for (T value : sortList) {
            map.put(value, i--);
        }
        return this.sort(map);
    }

    @Override
    @SafeVarargs
    public final SortField<Integer> sortDesc(T ... sortList) {
        return this.sortDesc((Collection<T>)Arrays.asList(sortList));
    }

    @Override
    public final <Z> SortField<Z> sort(Map<T, Z> sortMap) {
        CaseValueStep<T> decode = DSL.choose(this);
        CaseWhenStep<T, Z> result = null;
        for (Map.Entry<T, Z> entry : sortMap.entrySet()) {
            if (result == null) {
                result = decode.when(entry.getKey(), DSL.inline(entry.getValue()));
                continue;
            }
            result.when(entry.getKey(), (Field<Z>)DSL.inline(entry.getValue()));
        }
        if (result == null) {
            return new SortFieldImpl(new ConstantSortField(this), SortOrder.DEFAULT);
        }
        return result.asc();
    }

    @Override
    public final Field<T> neg() {
        return new Neg(this, ExpressionOperator.SUBTRACT);
    }

    @Override
    public final Field<T> unaryMinus() {
        return this.neg();
    }

    @Override
    public final Field<T> unaryPlus() {
        return this;
    }

    @Override
    public final Field<T> add(Number value) {
        return this.add(Tools.field(value));
    }

    @Override
    public Field<T> add(Field<?> value) {
        return new Expression(ExpressionOperator.ADD, this, DSL.nullSafe(value, this.getDataType()));
    }

    @Override
    public final Field<T> sub(Number value) {
        return this.sub(Tools.field(value));
    }

    @Override
    public final Field<T> sub(Field<?> value) {
        return new Expression(ExpressionOperator.SUBTRACT, this, DSL.nullSafe(value, this.getDataType()));
    }

    @Override
    public final Field<T> mul(Number value) {
        return this.mul(Tools.field(value));
    }

    @Override
    public Field<T> mul(Field<? extends Number> value) {
        return new Expression(ExpressionOperator.MULTIPLY, this, DSL.nullSafe(value, this.getDataType()));
    }

    @Override
    public final Field<T> div(Number value) {
        return this.div(Tools.field(value));
    }

    @Override
    public final Field<T> div(Field<? extends Number> value) {
        return new Expression(ExpressionOperator.DIVIDE, this, DSL.nullSafe(value, this.getDataType()));
    }

    @Override
    public final Field<T> mod(Number value) {
        return this.mod(Tools.field(value));
    }

    @Override
    public final Field<T> mod(Field<? extends Number> value) {
        return new Mod(this, DSL.nullSafe(value, this.getDataType()));
    }

    @Override
    public final Field<T> plus(Number value) {
        return this.add(value);
    }

    @Override
    public final Field<T> plus(Field<?> value) {
        return this.add(value);
    }

    @Override
    public final Field<T> subtract(Number value) {
        return this.sub(value);
    }

    @Override
    public final Field<T> subtract(Field<?> value) {
        return this.sub(value);
    }

    @Override
    public final Field<T> minus(Number value) {
        return this.sub(value);
    }

    @Override
    public final Field<T> minus(Field<?> value) {
        return this.sub(value);
    }

    @Override
    public final Field<T> multiply(Number value) {
        return this.mul(value);
    }

    @Override
    public final Field<T> multiply(Field<? extends Number> value) {
        return this.mul(value);
    }

    @Override
    public final Field<T> times(Number value) {
        return this.mul(value);
    }

    @Override
    public final Field<T> times(Field<? extends Number> value) {
        return this.mul(value);
    }

    @Override
    public final Field<T> divide(Number value) {
        return this.div(value);
    }

    @Override
    public final Field<T> divide(Field<? extends Number> value) {
        return this.div(value);
    }

    @Override
    public final Field<T> modulo(Number value) {
        return this.mod(value);
    }

    @Override
    public final Field<T> modulo(Field<? extends Number> value) {
        return this.mod(value);
    }

    @Override
    public final Field<T> rem(Number value) {
        return this.mod(value);
    }

    @Override
    public final Field<T> rem(Field<? extends Number> value) {
        return this.mod(value);
    }

    @Override
    public final Field<T> bitNot() {
        Field result = DSL.bitNot(this);
        return result;
    }

    @Override
    public final Field<T> bitAnd(T value) {
        Field result = DSL.bitAnd(this, DSL.val(value, this));
        return result;
    }

    @Override
    public final Field<T> bitAnd(Field<T> value) {
        Field<T> result = DSL.bitAnd(this, value);
        return result;
    }

    @Override
    public final Field<T> bitNand(T value) {
        Field result = DSL.bitNand(this, DSL.val(value, this));
        return result;
    }

    @Override
    public final Field<T> bitNand(Field<T> value) {
        Field<T> result = DSL.bitNand(this, value);
        return result;
    }

    @Override
    public final Field<T> bitOr(T value) {
        Field result = DSL.bitOr(this, DSL.val(value, this));
        return result;
    }

    @Override
    public final Field<T> bitOr(Field<T> value) {
        Field<T> result = DSL.bitOr(this, value);
        return result;
    }

    @Override
    public final Field<T> bitNor(T value) {
        Field result = DSL.bitNor(this, DSL.val(value, this));
        return result;
    }

    @Override
    public final Field<T> bitNor(Field<T> value) {
        Field<T> result = DSL.bitNor(this, value);
        return result;
    }

    @Override
    public final Field<T> bitXor(T value) {
        Field result = DSL.bitXor(this, DSL.val(value, this));
        return result;
    }

    @Override
    public final Field<T> bitXor(Field<T> value) {
        Field<T> result = DSL.bitXor(this, value);
        return result;
    }

    @Override
    public final Field<T> bitXNor(T value) {
        Field result = DSL.bitXNor(this, DSL.val(value, this));
        return result;
    }

    @Override
    public final Field<T> bitXNor(Field<T> value) {
        Field<T> result = DSL.bitXNor(this, value);
        return result;
    }

    @Override
    public final Field<T> shl(Number value) {
        Field result = DSL.shl(this, Tools.field(value));
        return result;
    }

    @Override
    public final Field<T> shl(Field<? extends Number> value) {
        Field result = DSL.shl(this, value);
        return result;
    }

    @Override
    public final Field<T> shr(Number value) {
        Field result = DSL.shr(this, Tools.field(value));
        return result;
    }

    @Override
    public final Field<T> shr(Field<? extends Number> value) {
        Field result = DSL.shr(this, value);
        return result;
    }

    @Override
    public final Condition isNull() {
        return new IsNull(this, true);
    }

    @Override
    public final Condition isNotNull() {
        return new IsNull(this, false);
    }

    @Override
    public final Condition isDistinctFrom(T value) {
        return this.isDistinctFrom(Tools.field(value, this));
    }

    @Override
    public final Condition isDistinctFrom(Field<T> field) {
        return this.compare(Comparator.IS_DISTINCT_FROM, field);
    }

    @Override
    public final Condition isNotDistinctFrom(T value) {
        return this.isNotDistinctFrom(Tools.field(value, this));
    }

    @Override
    public final Condition isNotDistinctFrom(Field<T> field) {
        return this.compare(Comparator.IS_NOT_DISTINCT_FROM, field);
    }

    @Override
    public final Condition isTrue() {
        Class<T> type = this.getType();
        if (type == String.class) {
            return this.in((Collection<?>)Tools.inline(Convert.TRUE_VALUES.toArray(Tools.EMPTY_STRING)));
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.equal(DSL.inline((Number)this.getDataType().convert((Object)1)));
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return this.equal(DSL.inline(true));
        }
        return this.cast(String.class).in((Collection<?>)Convert.TRUE_VALUES);
    }

    @Override
    public final Condition isFalse() {
        Class<T> type = this.getType();
        if (type == String.class) {
            return this.in((Collection<?>)Tools.inline(Convert.FALSE_VALUES.toArray(Tools.EMPTY_STRING)));
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.equal(DSL.inline((Number)this.getDataType().convert((Object)0)));
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return this.equal(DSL.inline(false));
        }
        return this.cast(String.class).in((Collection<?>)Tools.inline(Convert.FALSE_VALUES.toArray(Tools.EMPTY_STRING)));
    }

    @Override
    public final LikeEscapeStep like(String value) {
        return this.like(Tools.field((Object)value, String.class));
    }

    @Override
    public final Condition like(String value, char escape) {
        return this.like(Tools.field((Object)value, String.class), escape);
    }

    @Override
    public final LikeEscapeStep like(Field<String> field) {
        return new CompareCondition(this, DSL.nullSafe(field, this.getDataType()), Comparator.LIKE);
    }

    @Override
    public final Condition like(Field<String> field, char escape) {
        return this.like(field).escape(escape);
    }

    @Override
    public final LikeEscapeStep likeIgnoreCase(String value) {
        return this.likeIgnoreCase(Tools.field((Object)value, String.class));
    }

    @Override
    public final Condition likeIgnoreCase(String value, char escape) {
        return this.likeIgnoreCase(Tools.field((Object)value, String.class), escape);
    }

    @Override
    public final LikeEscapeStep likeIgnoreCase(Field<String> field) {
        return new CompareCondition(this, DSL.nullSafe(field, this.getDataType()), Comparator.LIKE_IGNORE_CASE);
    }

    @Override
    public final Condition likeIgnoreCase(Field<String> field, char escape) {
        return this.likeIgnoreCase(field).escape(escape);
    }

    @Override
    public final Condition likeRegex(String pattern) {
        return this.likeRegex(Tools.field((Object)pattern, String.class));
    }

    @Override
    public final Condition likeRegex(Field<String> pattern) {
        return new RegexpLike(this, DSL.nullSafe(pattern, this.getDataType()));
    }

    @Override
    public final LikeEscapeStep notLike(String value) {
        return this.notLike(Tools.field((Object)value, String.class));
    }

    @Override
    public final Condition notLike(String value, char escape) {
        return this.notLike(Tools.field((Object)value, String.class), escape);
    }

    @Override
    public final LikeEscapeStep notLike(Field<String> field) {
        return new CompareCondition(this, DSL.nullSafe(field, this.getDataType()), Comparator.NOT_LIKE);
    }

    @Override
    public final Condition notLike(Field<String> field, char escape) {
        return this.notLike(field).escape(escape);
    }

    @Override
    public final LikeEscapeStep notLikeIgnoreCase(String value) {
        return this.notLikeIgnoreCase(Tools.field((Object)value, String.class));
    }

    @Override
    public final Condition notLikeIgnoreCase(String value, char escape) {
        return this.notLikeIgnoreCase(Tools.field((Object)value, String.class), escape);
    }

    @Override
    public final LikeEscapeStep notLikeIgnoreCase(Field<String> field) {
        return new CompareCondition(this, DSL.nullSafe(field, this.getDataType()), Comparator.NOT_LIKE_IGNORE_CASE);
    }

    @Override
    public final Condition notLikeIgnoreCase(Field<String> field, char escape) {
        return this.notLikeIgnoreCase(field).escape(escape);
    }

    @Override
    public final Condition notLikeRegex(String pattern) {
        return this.likeRegex(pattern).not();
    }

    @Override
    public final Condition notLikeRegex(Field<String> pattern) {
        return this.likeRegex(pattern).not();
    }

    @Override
    public final Condition contains(T value) {
        if (value instanceof Field) {
            return this.contains((Field)value);
        }
        return new Contains<T>(this, value);
    }

    @Override
    public final Condition contains(Field<T> value) {
        return new Contains<T>(this, value);
    }

    @Override
    public final Condition notContains(T value) {
        return this.contains(value).not();
    }

    @Override
    public final Condition notContains(Field<T> value) {
        return this.contains(value).not();
    }

    @Override
    public final Condition containsIgnoreCase(T value) {
        if (value instanceof Field) {
            return this.containsIgnoreCase((Field)value);
        }
        return new ContainsIgnoreCase<T>(this, value);
    }

    @Override
    public final Condition containsIgnoreCase(Field<T> value) {
        return new ContainsIgnoreCase<T>(this, value);
    }

    @Override
    public final Condition notContainsIgnoreCase(T value) {
        return this.containsIgnoreCase(value).not();
    }

    @Override
    public final Condition notContainsIgnoreCase(Field<T> value) {
        return this.containsIgnoreCase(value).not();
    }

    @Override
    public final Condition startsWith(T value) {
        if (value instanceof Field) {
            return this.startsWith((Field)value);
        }
        Field<String> concat = DSL.concat(Tools.escapeForLike(value), DSL.inline("%"));
        return this.like(concat, '!');
    }

    @Override
    public final Condition startsWith(Field<T> value) {
        Field<String> concat = DSL.concat(Tools.escapeForLike(value), DSL.inline("%"));
        return this.like(concat, '!');
    }

    @Override
    public final Condition endsWith(T value) {
        if (value instanceof Field) {
            return this.endsWith((Field)value);
        }
        Field<String> concat = DSL.concat(DSL.inline("%"), Tools.escapeForLike(value));
        return this.like(concat, '!');
    }

    @Override
    public final Condition endsWith(Field<T> value) {
        Field<String> concat = DSL.concat(DSL.inline("%"), Tools.escapeForLike(value));
        return this.like(concat, '!');
    }

    private final boolean isAccidentalSelect(T[] values) {
        return values != null && values.length == 1 && values[0] instanceof Select;
    }

    private final boolean isAccidentalCollection(T[] values) {
        return values != null && values.length == 1 && values[0] instanceof Collection;
    }

    @Override
    public final Condition in(T ... values) {
        if (this.isAccidentalSelect(values)) {
            return this.in((Select)values[0]);
        }
        if (this.isAccidentalCollection(values)) {
            return this.in((Collection)values[0]);
        }
        return this.in(Tools.fields((Object[])values, this).toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final Condition in(Field<?> ... values) {
        return new InCondition(this, DSL.nullSafe(values), Comparator.IN);
    }

    @Override
    public final Condition in(Collection<?> values) {
        ArrayList fields = new ArrayList();
        for (Object value : values) {
            fields.add(Tools.field(value, this));
        }
        return this.in(fields.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final Condition in(Result<? extends Record1<T>> result) {
        return this.in((Collection<?>)result.getValues(0, this.getType()));
    }

    @Override
    public final Condition in(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.IN, query);
    }

    @Override
    public final Condition notIn(T ... values) {
        if (this.isAccidentalSelect(values)) {
            return this.notIn((Select)values[0]);
        }
        if (this.isAccidentalCollection(values)) {
            return this.notIn((Collection)values[0]);
        }
        return this.notIn(Tools.fields((Object[])values, this).toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final Condition notIn(Field<?> ... values) {
        return new InCondition(this, DSL.nullSafe(values), Comparator.NOT_IN);
    }

    @Override
    public final Condition notIn(Collection<?> values) {
        ArrayList fields = new ArrayList();
        for (Object value : values) {
            fields.add(Tools.field(value, this));
        }
        return this.notIn(fields.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final Condition notIn(Result<? extends Record1<T>> result) {
        return this.notIn((Collection<?>)result.getValues(0, this.getType()));
    }

    @Override
    public final Condition notIn(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.NOT_IN, query);
    }

    @Override
    public final Condition between(T minValue, T maxValue) {
        return this.between(Tools.field(minValue, this), Tools.field(maxValue, this));
    }

    @Override
    public final Condition between(Field<T> minValue, Field<T> maxValue) {
        return this.between(DSL.nullSafe(minValue, this.getDataType())).and(DSL.nullSafe(maxValue, this.getDataType()));
    }

    @Override
    public final Condition betweenSymmetric(T minValue, T maxValue) {
        return this.betweenSymmetric(Tools.field(minValue, this), Tools.field(maxValue, this));
    }

    @Override
    public final Condition betweenSymmetric(Field<T> minValue, Field<T> maxValue) {
        return this.betweenSymmetric(DSL.nullSafe(minValue, this.getDataType())).and(DSL.nullSafe(maxValue, this.getDataType()));
    }

    @Override
    public final Condition notBetween(T minValue, T maxValue) {
        return this.notBetween(Tools.field(minValue, this), Tools.field(maxValue, this));
    }

    @Override
    public final Condition notBetween(Field<T> minValue, Field<T> maxValue) {
        return this.notBetween(DSL.nullSafe(minValue, this.getDataType())).and(DSL.nullSafe(maxValue, this.getDataType()));
    }

    @Override
    public final Condition notBetweenSymmetric(T minValue, T maxValue) {
        return this.notBetweenSymmetric(Tools.field(minValue, this), Tools.field(maxValue, this));
    }

    @Override
    public final Condition notBetweenSymmetric(Field<T> minValue, Field<T> maxValue) {
        return this.notBetweenSymmetric(DSL.nullSafe(minValue, this.getDataType())).and(DSL.nullSafe(maxValue, this.getDataType()));
    }

    @Override
    public final BetweenAndStep<T> between(T minValue) {
        return this.between(Tools.field(minValue, this));
    }

    @Override
    public final BetweenAndStep<T> between(Field<T> minValue) {
        return new BetweenCondition<T>(this, DSL.nullSafe(minValue, this.getDataType()), false, false);
    }

    @Override
    public final BetweenAndStep<T> betweenSymmetric(T minValue) {
        return this.betweenSymmetric(Tools.field(minValue, this));
    }

    @Override
    public final BetweenAndStep<T> betweenSymmetric(Field<T> minValue) {
        return new BetweenCondition<T>(this, DSL.nullSafe(minValue, this.getDataType()), false, true);
    }

    @Override
    public final BetweenAndStep<T> notBetween(T minValue) {
        return this.notBetween(Tools.field(minValue, this));
    }

    @Override
    public final BetweenAndStep<T> notBetween(Field<T> minValue) {
        return new BetweenCondition<T>(this, DSL.nullSafe(minValue, this.getDataType()), true, false);
    }

    @Override
    public final BetweenAndStep<T> notBetweenSymmetric(T minValue) {
        return this.notBetweenSymmetric(Tools.field(minValue, this));
    }

    @Override
    public final BetweenAndStep<T> notBetweenSymmetric(Field<T> minValue) {
        return new BetweenCondition<T>(this, DSL.nullSafe(minValue, this.getDataType()), true, true);
    }

    @Override
    public final Condition eq(T value) {
        return this.equal(value);
    }

    @Override
    public final Condition eq(Field<T> field) {
        return this.equal(field);
    }

    @Override
    public final Condition eq(Select<? extends Record1<T>> query) {
        return this.equal(query);
    }

    @Override
    public final Condition eq(QuantifiedSelect<? extends Record1<T>> query) {
        return this.equal(query);
    }

    @Override
    public final Condition ne(T value) {
        return this.notEqual(value);
    }

    @Override
    public final Condition ne(Field<T> field) {
        return this.notEqual(field);
    }

    @Override
    public final Condition ne(Select<? extends Record1<T>> query) {
        return this.notEqual(query);
    }

    @Override
    public final Condition ne(QuantifiedSelect<? extends Record1<T>> query) {
        return this.notEqual(query);
    }

    @Override
    public final Condition lt(T value) {
        return this.lessThan(value);
    }

    @Override
    public final Condition lt(Field<T> field) {
        return this.lessThan(field);
    }

    @Override
    public final Condition lt(Select<? extends Record1<T>> query) {
        return this.lessThan(query);
    }

    @Override
    public final Condition lt(QuantifiedSelect<? extends Record1<T>> query) {
        return this.lessThan(query);
    }

    @Override
    public final Condition le(T value) {
        return this.lessOrEqual(value);
    }

    @Override
    public final Condition le(Field<T> field) {
        return this.lessOrEqual(field);
    }

    @Override
    public final Condition le(Select<? extends Record1<T>> query) {
        return this.lessOrEqual(query);
    }

    @Override
    public final Condition le(QuantifiedSelect<? extends Record1<T>> query) {
        return this.lessOrEqual(query);
    }

    @Override
    public final Condition gt(T value) {
        return this.greaterThan(value);
    }

    @Override
    public final Condition gt(Field<T> field) {
        return this.greaterThan(field);
    }

    @Override
    public final Condition gt(Select<? extends Record1<T>> query) {
        return this.greaterThan(query);
    }

    @Override
    public final Condition gt(QuantifiedSelect<? extends Record1<T>> query) {
        return this.greaterThan(query);
    }

    @Override
    public final Condition ge(T value) {
        return this.greaterOrEqual(value);
    }

    @Override
    public final Condition ge(Field<T> field) {
        return this.greaterOrEqual(field);
    }

    @Override
    public final Condition ge(Select<? extends Record1<T>> query) {
        return this.greaterOrEqual(query);
    }

    @Override
    public final Condition ge(QuantifiedSelect<? extends Record1<T>> query) {
        return this.greaterOrEqual(query);
    }

    @Override
    public final Condition equal(T value) {
        return this.equal(Tools.field(value, this));
    }

    @Override
    public final Condition equal(Field<T> field) {
        return this.compare(Comparator.EQUALS, DSL.nullSafe(field, this.getDataType()));
    }

    @Override
    public final Condition equalIgnoreCase(String value) {
        return this.equalIgnoreCase(Tools.field((Object)value, String.class));
    }

    @Override
    public final Condition equalIgnoreCase(Field<String> value) {
        return DSL.lower(this.cast(String.class)).equal(DSL.lower(value));
    }

    @Override
    public final Condition equal(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.EQUALS, query);
    }

    @Override
    public final Condition equal(QuantifiedSelect<? extends Record1<T>> query) {
        return this.compare(Comparator.EQUALS, query);
    }

    @Override
    public final Condition notEqual(T value) {
        return this.notEqual(Tools.field(value, this));
    }

    @Override
    public final Condition notEqual(Field<T> field) {
        return this.compare(Comparator.NOT_EQUALS, DSL.nullSafe(field, this.getDataType()));
    }

    @Override
    public final Condition notEqualIgnoreCase(String value) {
        return this.notEqualIgnoreCase(Tools.field((Object)value, String.class));
    }

    @Override
    public final Condition notEqualIgnoreCase(Field<String> value) {
        return DSL.lower(this.cast(String.class)).notEqual(DSL.lower(value));
    }

    @Override
    public final Condition notEqual(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.NOT_EQUALS, query);
    }

    @Override
    public final Condition notEqual(QuantifiedSelect<? extends Record1<T>> query) {
        return this.compare(Comparator.NOT_EQUALS, query);
    }

    @Override
    public final Condition lessThan(T value) {
        return this.lessThan(Tools.field(value, this));
    }

    @Override
    public final Condition lessThan(Field<T> field) {
        return this.compare(Comparator.LESS, DSL.nullSafe(field, this.getDataType()));
    }

    @Override
    public final Condition lessThan(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.LESS, query);
    }

    @Override
    public final Condition lessThan(QuantifiedSelect<? extends Record1<T>> query) {
        return this.compare(Comparator.LESS, query);
    }

    @Override
    public final Condition lessOrEqual(T value) {
        return this.lessOrEqual(Tools.field(value, this));
    }

    @Override
    public final Condition lessOrEqual(Field<T> field) {
        return this.compare(Comparator.LESS_OR_EQUAL, DSL.nullSafe(field, this.getDataType()));
    }

    @Override
    public final Condition lessOrEqual(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.LESS_OR_EQUAL, query);
    }

    @Override
    public final Condition lessOrEqual(QuantifiedSelect<? extends Record1<T>> query) {
        return this.compare(Comparator.LESS_OR_EQUAL, query);
    }

    @Override
    public final Condition greaterThan(T value) {
        return this.greaterThan(Tools.field(value, this));
    }

    @Override
    public final Condition greaterThan(Field<T> field) {
        return this.compare(Comparator.GREATER, DSL.nullSafe(field, this.getDataType()));
    }

    @Override
    public final Condition greaterThan(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.GREATER, query);
    }

    @Override
    public final Condition greaterThan(QuantifiedSelect<? extends Record1<T>> query) {
        return this.compare(Comparator.GREATER, query);
    }

    @Override
    public final Condition greaterOrEqual(T value) {
        return this.greaterOrEqual(Tools.field(value, this));
    }

    @Override
    public final Condition greaterOrEqual(Field<T> field) {
        return this.compare(Comparator.GREATER_OR_EQUAL, DSL.nullSafe(field, this.getDataType()));
    }

    @Override
    public final Condition greaterOrEqual(Select<? extends Record1<T>> query) {
        return this.compare(Comparator.GREATER_OR_EQUAL, query);
    }

    @Override
    public final Condition greaterOrEqual(QuantifiedSelect<? extends Record1<T>> query) {
        return this.compare(Comparator.GREATER_OR_EQUAL, query);
    }

    @Override
    public final Condition compare(Comparator comparator, T value) {
        return this.compare(comparator, Tools.field(value, this));
    }

    @Override
    public final Condition compare(Comparator comparator, Field<T> field) {
        switch (comparator) {
            case IS_DISTINCT_FROM: 
            case IS_NOT_DISTINCT_FROM: {
                return new IsDistinctFrom<T>(this, DSL.nullSafe(field, this.getDataType()), comparator);
            }
        }
        return new CompareCondition(this, DSL.nullSafe(field, this.getDataType()), comparator);
    }

    @Override
    public final Condition compare(Comparator comparator, Select<? extends Record1<T>> query) {
        return this.compare(comparator, new ScalarSubquery<T>(query, this.getDataType()));
    }

    @Override
    public final Condition compare(Comparator comparator, QuantifiedSelect<? extends Record1<T>> query) {
        return new QuantifiedComparisonCondition(query, this, comparator);
    }

    private final <Z extends Number> Field<Z> numeric() {
        if (this.getDataType().isNumeric()) {
            return this;
        }
        return this.cast(BigDecimal.class);
    }

    private final Field<String> varchar() {
        if (this.getDataType().isString()) {
            return this;
        }
        return this.cast(String.class);
    }

    private final <Z extends Date> Field<Z> date() {
        if (this.getDataType().isTemporal()) {
            return this;
        }
        return this.cast(Timestamp.class);
    }

    @Override
    @Deprecated
    public final Field<Integer> sign() {
        return DSL.sign(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<T> abs() {
        return DSL.abs(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<T> round() {
        return DSL.round(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<T> round(int decimals) {
        return DSL.round(this.numeric(), decimals);
    }

    @Override
    @Deprecated
    public final Field<T> floor() {
        return DSL.floor(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<T> ceil() {
        return DSL.ceil(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> sqrt() {
        return DSL.sqrt(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> exp() {
        return DSL.exp(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> ln() {
        return DSL.ln(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> log(int base) {
        return DSL.log(this.numeric(), base);
    }

    @Override
    public final Field<BigDecimal> pow(Number exponent) {
        return DSL.power(this.numeric(), exponent);
    }

    @Override
    public final Field<BigDecimal> power(Number exponent) {
        return this.pow(exponent);
    }

    @Override
    public final Field<BigDecimal> pow(Field<? extends Number> exponent) {
        return DSL.power(this.numeric(), exponent);
    }

    @Override
    public final Field<BigDecimal> power(Field<? extends Number> exponent) {
        return this.pow(exponent);
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> acos() {
        return DSL.acos(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> asin() {
        return DSL.asin(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> atan() {
        return DSL.atan(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> atan2(Number y) {
        return DSL.atan2(this.numeric(), y);
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> atan2(Field<? extends Number> y) {
        return DSL.atan2(this.numeric(), y);
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> cos() {
        return DSL.cos(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> sin() {
        return DSL.sin(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> tan() {
        return DSL.tan(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> cot() {
        return DSL.cot(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> sinh() {
        return DSL.sinh(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> cosh() {
        return DSL.cosh(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> tanh() {
        return DSL.tanh(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> coth() {
        return DSL.coth(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> deg() {
        return DSL.deg(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> rad() {
        return DSL.rad(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<Integer> count() {
        return DSL.count(this);
    }

    @Override
    @Deprecated
    public final Field<Integer> countDistinct() {
        return DSL.countDistinct(this);
    }

    @Override
    @Deprecated
    public final Field<T> max() {
        return DSL.max(this);
    }

    @Override
    @Deprecated
    public final Field<T> min() {
        return DSL.min(this);
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> sum() {
        return DSL.sum(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> avg() {
        return DSL.avg(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> median() {
        return DSL.median(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> stddevPop() {
        return DSL.stddevPop(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> stddevSamp() {
        return DSL.stddevSamp(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> varPop() {
        return DSL.varPop(this.numeric());
    }

    @Override
    @Deprecated
    public final Field<BigDecimal> varSamp() {
        return DSL.varSamp(this.numeric());
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<Integer> countOver() {
        return DSL.count(this).over();
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<T> maxOver() {
        return DSL.max(this).over();
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<T> minOver() {
        return DSL.min(this).over();
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<BigDecimal> sumOver() {
        return DSL.sum(this.numeric()).over();
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<BigDecimal> avgOver() {
        return DSL.avg(this.numeric()).over();
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> firstValue() {
        return DSL.firstValue(this);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lastValue() {
        return DSL.lastValue(this);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lead() {
        return DSL.lead(this);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lead(int offset) {
        return DSL.lead(this, offset);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lead(int offset, T defaultValue) {
        return DSL.lead(this, offset, defaultValue);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lead(int offset, Field<T> defaultValue) {
        return DSL.lead(this, offset, defaultValue);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lag() {
        return DSL.lag(this);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lag(int offset) {
        return DSL.lag(this, offset);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lag(int offset, T defaultValue) {
        return DSL.lag(this, offset, defaultValue);
    }

    @Override
    @Deprecated
    public final WindowIgnoreNullsStep<T> lag(int offset, Field<T> defaultValue) {
        return DSL.lag(this, offset, defaultValue);
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<BigDecimal> stddevPopOver() {
        return DSL.stddevPop(this.numeric()).over();
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<BigDecimal> stddevSampOver() {
        return DSL.stddevSamp(this.numeric()).over();
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<BigDecimal> varPopOver() {
        return DSL.varPop(this.numeric()).over();
    }

    @Override
    @Deprecated
    public final WindowPartitionByStep<BigDecimal> varSampOver() {
        return DSL.varSamp(this.numeric()).over();
    }

    @Override
    @Deprecated
    public final Field<String> upper() {
        return DSL.upper(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<String> lower() {
        return DSL.lower(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<String> trim() {
        return DSL.trim(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<String> rtrim() {
        return DSL.rtrim(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<String> ltrim() {
        return DSL.ltrim(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<String> rpad(Field<? extends Number> length) {
        return DSL.rpad(this.varchar(), length);
    }

    @Override
    @Deprecated
    public final Field<String> rpad(int length) {
        return DSL.rpad(this.varchar(), length);
    }

    @Override
    @Deprecated
    public final Field<String> rpad(Field<? extends Number> length, Field<String> character) {
        return DSL.rpad(this.varchar(), length, character);
    }

    @Override
    @Deprecated
    public final Field<String> rpad(int length, char character) {
        return DSL.rpad(this.varchar(), length, character);
    }

    @Override
    @Deprecated
    public final Field<String> lpad(Field<? extends Number> length) {
        return DSL.lpad(this.varchar(), length);
    }

    @Override
    @Deprecated
    public final Field<String> lpad(int length) {
        return DSL.lpad(this.varchar(), length);
    }

    @Override
    @Deprecated
    public final Field<String> lpad(Field<? extends Number> length, Field<String> character) {
        return DSL.lpad(this.varchar(), length, character);
    }

    @Override
    @Deprecated
    public final Field<String> lpad(int length, char character) {
        return DSL.lpad(this.varchar(), length, character);
    }

    @Override
    @Deprecated
    public final Field<String> repeat(Number count) {
        return DSL.repeat(this.varchar(), count == null ? 0 : count.intValue());
    }

    @Override
    @Deprecated
    public final Field<String> repeat(Field<? extends Number> count) {
        return DSL.repeat(this.varchar(), count);
    }

    @Override
    @Deprecated
    public final Field<String> replace(Field<String> search) {
        return DSL.replace(this.varchar(), search);
    }

    @Override
    @Deprecated
    public final Field<String> replace(String search) {
        return DSL.replace(this.varchar(), search);
    }

    @Override
    @Deprecated
    public final Field<String> replace(Field<String> search, Field<String> replace) {
        return DSL.replace(this.varchar(), search, replace);
    }

    @Override
    @Deprecated
    public final Field<String> replace(String search, String replace) {
        return DSL.replace(this.varchar(), search, replace);
    }

    @Override
    @Deprecated
    public final Field<Integer> position(String search) {
        return DSL.position(this.varchar(), search);
    }

    @Override
    @Deprecated
    public final Field<Integer> position(Field<String> search) {
        return DSL.position(this.varchar(), search);
    }

    @Override
    @Deprecated
    public final Field<Integer> ascii() {
        return DSL.ascii(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<String> concat(Field<?> ... fields) {
        return DSL.concat(Tools.combine(this, fields));
    }

    @Override
    @Deprecated
    public final Field<String> concat(String ... values) {
        return DSL.concat(Tools.combine(this, Tools.fields(values).toArray(Tools.EMPTY_FIELD)));
    }

    @Override
    @Deprecated
    public final Field<String> substring(int startingPosition) {
        return DSL.substring(this.varchar(), startingPosition);
    }

    @Override
    @Deprecated
    public final Field<String> substring(Field<? extends Number> startingPosition) {
        return DSL.substring(this.varchar(), startingPosition);
    }

    @Override
    @Deprecated
    public final Field<String> substring(int startingPosition, int length) {
        return DSL.substring(this.varchar(), startingPosition, length);
    }

    @Override
    @Deprecated
    public final Field<String> substring(Field<? extends Number> startingPosition, Field<? extends Number> length) {
        return DSL.substring(this.varchar(), startingPosition, length);
    }

    @Override
    @Deprecated
    public final Field<Integer> length() {
        return DSL.length(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<Integer> charLength() {
        return DSL.charLength(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<Integer> bitLength() {
        return DSL.bitLength(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<Integer> octetLength() {
        return DSL.octetLength(this.varchar());
    }

    @Override
    @Deprecated
    public final Field<Integer> extract(DatePart datePart) {
        return DSL.extract(this.date(), datePart);
    }

    @Override
    @Deprecated
    @SafeVarargs
    public final Field<T> greatest(T ... others) {
        return DSL.greatest(this, Tools.fields(others).toArray(Tools.EMPTY_FIELD));
    }

    @Override
    @Deprecated
    public final Field<T> greatest(Field<?> ... others) {
        return DSL.greatest(this, others);
    }

    @Override
    @Deprecated
    @SafeVarargs
    public final Field<T> least(T ... others) {
        return DSL.least(this, Tools.fields(others).toArray(Tools.EMPTY_FIELD));
    }

    @Override
    @Deprecated
    public final Field<T> least(Field<?> ... others) {
        return DSL.least(this, others);
    }

    @Override
    @Deprecated
    public final Field<T> nvl(T defaultValue) {
        return DSL.nvl(this, defaultValue);
    }

    @Override
    @Deprecated
    public final Field<T> nvl(Field<T> defaultValue) {
        return DSL.nvl(this, defaultValue);
    }

    @Override
    @Deprecated
    public final <Z> Field<Z> nvl2(Z valueIfNotNull, Z valueIfNull) {
        return DSL.nvl2(this, valueIfNotNull, valueIfNull);
    }

    @Override
    @Deprecated
    public final <Z> Field<Z> nvl2(Field<Z> valueIfNotNull, Field<Z> valueIfNull) {
        return DSL.nvl2(this, valueIfNotNull, valueIfNull);
    }

    @Override
    @Deprecated
    public final Field<T> nullif(T other) {
        return DSL.nullif(this, other);
    }

    @Override
    @Deprecated
    public final Field<T> nullif(Field<T> other) {
        return DSL.nullif(this, other);
    }

    @Override
    @Deprecated
    public final <Z> Field<Z> decode(T search, Z result) {
        return DSL.decode(this, search, result);
    }

    @Override
    @Deprecated
    public final <Z> Field<Z> decode(T search, Z result, Object ... more) {
        return DSL.decode(this, search, result, more);
    }

    @Override
    @Deprecated
    public final <Z> Field<Z> decode(Field<T> search, Field<Z> result) {
        return DSL.decode(this, search, result);
    }

    @Override
    @Deprecated
    public final <Z> Field<Z> decode(Field<T> search, Field<Z> result, Field<?> ... more) {
        return DSL.decode(this, search, result, more);
    }

    @Override
    @Deprecated
    @SafeVarargs
    public final Field<T> coalesce(T option, T ... options) {
        return DSL.coalesce(this, Tools.combine(Tools.field(option), Tools.fields(options).toArray(Tools.EMPTY_FIELD)));
    }

    @Override
    @Deprecated
    public final Field<T> coalesce(Field<T> option, Field<?> ... options) {
        return DSL.coalesce(this, Tools.combine(option, options));
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof AbstractField) {
            if (StringUtils.equals(this.name.last(), ((AbstractField)that).name.last())) {
                return super.equals(that);
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.last().hashCode();
    }
}

