/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.postprocess;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.ml.common.connector.functions.postprocess.ConnectorPostProcessFunction;
import org.opensearch.ml.common.output.model.MLResultDataType;
import org.opensearch.ml.common.output.model.ModelTensor;

public class BedrockRerankPostProcessFunction
extends ConnectorPostProcessFunction<List<Map<String, Object>>> {
    @Override
    public void validate(Object input) {
        if (!(input instanceof List)) {
            throw new IllegalArgumentException("Post process function input is not a List.");
        }
        List outerList = (List)input;
        if (outerList.isEmpty()) {
            throw new IllegalArgumentException("Post process function input is empty.");
        }
        for (Object item : outerList) {
            if (!(item instanceof Map)) {
                throw new IllegalArgumentException("Rerank result is not a Map.");
            }
            Map innerMap = (Map)item;
            if (innerMap.isEmpty()) {
                throw new IllegalArgumentException("Rerank result is empty.");
            }
            if (!innerMap.containsKey("index") || !innerMap.containsKey("relevanceScore")) {
                throw new IllegalArgumentException("Rerank result should have both index and relevanceScore.");
            }
            if (innerMap.get("relevanceScore") instanceof BigDecimal || innerMap.get("relevanceScore") instanceof Double) continue;
            throw new IllegalArgumentException("relevanceScore is not BigDecimal or Double.");
        }
    }

    @Override
    public List<ModelTensor> process(List<Map<String, Object>> rerankResults, MLResultDataType dataType) {
        ArrayList<ModelTensor> modelTensors = new ArrayList<ModelTensor>();
        if (!rerankResults.isEmpty()) {
            Double[] scores = new Double[rerankResults.size()];
            for (Map<String, Object> rerankResult : rerankResults) {
                Integer index = (Integer)rerankResult.get("index");
                Object relevanceScore = rerankResult.get("relevanceScore");
                if (relevanceScore instanceof BigDecimal) {
                    scores[index.intValue()] = ((BigDecimal)relevanceScore).doubleValue();
                    continue;
                }
                if (!(relevanceScore instanceof Double)) continue;
                scores[index.intValue()] = (Double)relevanceScore;
            }
            for (Double score : scores) {
                modelTensors.add(ModelTensor.builder().name("similarity").shape(new long[]{1L}).data(new Number[]{score}).dataType(MLResultDataType.FLOAT32).build());
            }
        }
        return modelTensors;
    }
}

