/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.Subnet;

public class DescribeSubnetsPublisher
implements SdkPublisher<DescribeSubnetsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSubnetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSubnetsPublisher(Ec2AsyncClient client, DescribeSubnetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSubnetsPublisher(Ec2AsyncClient client, DescribeSubnetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSubnetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSubnetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Subnet> subnets() {
        Function<DescribeSubnetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subnets() != null) {
                return response.subnets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSubnetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSubnetsResponseFetcher
    implements AsyncPageFetcher<DescribeSubnetsResponse> {
        private DescribeSubnetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubnetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSubnetsResponse> nextPage(DescribeSubnetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubnetsPublisher.this.client.describeSubnets(DescribeSubnetsPublisher.this.firstRequest);
            }
            return DescribeSubnetsPublisher.this.client.describeSubnets((DescribeSubnetsRequest)((Object)DescribeSubnetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

