/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ByoipCidr;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse;

public class DescribeByoipCidrsIterable
implements SdkIterable<DescribeByoipCidrsResponse> {
    private final Ec2Client client;
    private final DescribeByoipCidrsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeByoipCidrsIterable(Ec2Client client, DescribeByoipCidrsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeByoipCidrsResponseFetcher();
    }

    public Iterator<DescribeByoipCidrsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ByoipCidr> byoipCidrs() {
        Function<DescribeByoipCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.byoipCidrs() != null) {
                return response.byoipCidrs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeByoipCidrsResponseFetcher
    implements SyncPageFetcher<DescribeByoipCidrsResponse> {
        private DescribeByoipCidrsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeByoipCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeByoipCidrsResponse nextPage(DescribeByoipCidrsResponse previousPage) {
            if (previousPage == null) {
                return DescribeByoipCidrsIterable.this.client.describeByoipCidrs(DescribeByoipCidrsIterable.this.firstRequest);
            }
            return DescribeByoipCidrsIterable.this.client.describeByoipCidrs((DescribeByoipCidrsRequest)((Object)DescribeByoipCidrsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

