/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseCapacityBlockRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, PurchaseCapacityBlockRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(PurchaseCapacityBlockRequest.getter(PurchaseCapacityBlockRequest::dryRun)).setter(PurchaseCapacityBlockRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(PurchaseCapacityBlockRequest.getter(PurchaseCapacityBlockRequest::tagSpecifications)).setter(PurchaseCapacityBlockRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CAPACITY_BLOCK_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityBlockOfferingId").getter(PurchaseCapacityBlockRequest.getter(PurchaseCapacityBlockRequest::capacityBlockOfferingId)).setter(PurchaseCapacityBlockRequest.setter(Builder::capacityBlockOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockOfferingId").unmarshallLocationName("CapacityBlockOfferingId").build()}).build();
    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstancePlatform").getter(PurchaseCapacityBlockRequest.getter(PurchaseCapacityBlockRequest::instancePlatformAsString)).setter(PurchaseCapacityBlockRequest.setter(Builder::instancePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform").unmarshallLocationName("InstancePlatform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD, CAPACITY_BLOCK_OFFERING_ID_FIELD, INSTANCE_PLATFORM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseCapacityBlockRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final List<TagSpecification> tagSpecifications;
    private final String capacityBlockOfferingId;
    private final String instancePlatform;

    private PurchaseCapacityBlockRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
        this.capacityBlockOfferingId = builder.capacityBlockOfferingId;
        this.instancePlatform = builder.instancePlatform;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String capacityBlockOfferingId() {
        return this.capacityBlockOfferingId;
    }

    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(this.instancePlatform);
    }

    public final String instancePlatformAsString() {
        return this.instancePlatform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePlatformAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseCapacityBlockRequest)) {
            return false;
        }
        PurchaseCapacityBlockRequest other = (PurchaseCapacityBlockRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.capacityBlockOfferingId(), other.capacityBlockOfferingId()) && Objects.equals(this.instancePlatformAsString(), other.instancePlatformAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseCapacityBlockRequest").add("DryRun", (Object)this.dryRun()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("CapacityBlockOfferingId", (Object)this.capacityBlockOfferingId()).add("InstancePlatform", (Object)this.instancePlatformAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "CapacityBlockOfferingId": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockOfferingId()));
            }
            case "InstancePlatform": {
                return Optional.ofNullable(clazz.cast(this.instancePlatformAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("CapacityBlockOfferingId", CAPACITY_BLOCK_OFFERING_ID_FIELD);
        map.put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseCapacityBlockRequest, T> g) {
        return obj -> g.apply((PurchaseCapacityBlockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String capacityBlockOfferingId;
        private String instancePlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseCapacityBlockRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.tagSpecifications(model.tagSpecifications);
            this.capacityBlockOfferingId(model.capacityBlockOfferingId);
            this.instancePlatform(model.instancePlatform);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCapacityBlockOfferingId() {
            return this.capacityBlockOfferingId;
        }

        public final void setCapacityBlockOfferingId(String capacityBlockOfferingId) {
            this.capacityBlockOfferingId = capacityBlockOfferingId;
        }

        @Override
        public final Builder capacityBlockOfferingId(String capacityBlockOfferingId) {
            this.capacityBlockOfferingId = capacityBlockOfferingId;
            return this;
        }

        public final String getInstancePlatform() {
            return this.instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseCapacityBlockRequest build() {
            return new PurchaseCapacityBlockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseCapacityBlockRequest> {
        public Builder dryRun(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder capacityBlockOfferingId(String var1);

        public Builder instancePlatform(String var1);

        public Builder instancePlatform(CapacityReservationInstancePlatform var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

