/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeclarativePoliciesReport;
import software.amazon.awssdk.services.ec2.model.DeclarativePoliciesReportListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeclarativePoliciesReportsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeDeclarativePoliciesReportsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDeclarativePoliciesReportsResponse.getter(DescribeDeclarativePoliciesReportsResponse::nextToken)).setter(DescribeDeclarativePoliciesReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<DeclarativePoliciesReport>> REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reports").getter(DescribeDeclarativePoliciesReportsResponse.getter(DescribeDeclarativePoliciesReportsResponse::reports)).setter(DescribeDeclarativePoliciesReportsResponse.setter(Builder::reports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportSet").unmarshallLocationName("reportSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeclarativePoliciesReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REPORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDeclarativePoliciesReportsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DeclarativePoliciesReport> reports;

    private DescribeDeclarativePoliciesReportsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reports = builder.reports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReports() {
        return this.reports != null && !(this.reports instanceof SdkAutoConstructList);
    }

    public final List<DeclarativePoliciesReport> reports() {
        return this.reports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReports() ? this.reports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeclarativePoliciesReportsResponse)) {
            return false;
        }
        DescribeDeclarativePoliciesReportsResponse other = (DescribeDeclarativePoliciesReportsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReports() == other.hasReports() && Objects.equals(this.reports(), other.reports());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeclarativePoliciesReportsResponse").add("NextToken", (Object)this.nextToken()).add("Reports", this.hasReports() ? this.reports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Reports": {
                return Optional.ofNullable(clazz.cast(this.reports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ReportSet", REPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeclarativePoliciesReportsResponse, T> g) {
        return obj -> g.apply((DescribeDeclarativePoliciesReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DeclarativePoliciesReport> reports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeclarativePoliciesReportsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reports(model.reports);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DeclarativePoliciesReport.Builder> getReports() {
            List<DeclarativePoliciesReport.Builder> result = DeclarativePoliciesReportListCopier.copyToBuilder(this.reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReports(Collection<DeclarativePoliciesReport.BuilderImpl> reports) {
            this.reports = DeclarativePoliciesReportListCopier.copyFromBuilder(reports);
        }

        @Override
        public final Builder reports(Collection<DeclarativePoliciesReport> reports) {
            this.reports = DeclarativePoliciesReportListCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(DeclarativePoliciesReport ... reports) {
            this.reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<DeclarativePoliciesReport.Builder> ... reports) {
            this.reports(Stream.of(reports).map(c -> (DeclarativePoliciesReport)((DeclarativePoliciesReport.Builder)DeclarativePoliciesReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDeclarativePoliciesReportsResponse build() {
            return new DescribeDeclarativePoliciesReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeclarativePoliciesReportsResponse> {
        public Builder nextToken(String var1);

        public Builder reports(Collection<DeclarativePoliciesReport> var1);

        public Builder reports(DeclarativePoliciesReport ... var1);

        public Builder reports(Consumer<DeclarativePoliciesReport.Builder> ... var1);
    }
}

