"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testTransformDisabled = exports.testTransform2 = exports.testTransform = exports.testRollup2 = exports.testRollup = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const testRollup = exports.testRollup = {
  _id: "test1",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  rollup: {
    rollup_id: "test1",
    enabled: true,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    last_updated_time: 1602100553,
    description: "An example job that rolls up the sample ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_rollup",
    page_size: 1000,
    delay: 0,
    continuous: false,
    metadata_id: null,
    enabledTime: null,
    lastUpdatedTime: null,
    schemaVersion: 1,
    dimensions: [{
      date_histogram: {
        source_field: "order_date",
        fixed_interval: "90m",
        timezone: "America/Los_Angeles"
      }
    }, {
      terms: {
        source_field: "customer_gender"
      }
    }, {
      terms: {
        source_field: "geoip.city_name"
      }
    }, {
      terms: {
        source_field: "geoip.region_name"
      }
    }, {
      terms: {
        source_field: "day_of_week"
      }
    }],
    metrics: [{
      source_field: "taxless_total_price",
      metrics: [{
        avg: {}
      }, {
        sum: {}
      }, {
        max: {}
      }, {
        min: {}
      }, {
        value_count: {}
      }]
    }, {
      source_field: "total_quantity",
      metrics: [{
        avg: {}
      }, {
        max: {}
      }]
    }]
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      rollup_metadata: {
        rollup_id: "test1",
        last_updated_time: 1605724690355,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          rollups_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
const testRollup2 = exports.testRollup2 = {
  _id: "test2",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  rollup: {
    rollup_id: "test2",
    enabled: false,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    last_updated_time: 1602100553,
    description: "Another example job that rolls up the sample ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_rollup2",
    page_size: 1000,
    delay: 0,
    continuous: false,
    dimensions: [{
      date_histogram: {
        source_field: "order_date",
        fixed_interval: "60m",
        timezone: "America/Los_Angeles"
      }
    }, {
      terms: {
        source_field: "customer_gender"
      }
    }, {
      terms: {
        source_field: "geoip.city_name"
      }
    }, {
      terms: {
        source_field: "geoip.region_name"
      }
    }, {
      terms: {
        source_field: "day_of_week"
      }
    }, {
      terms: {
        source_field: "day_of_week_i"
      }
    }],
    metrics: [{
      source_field: "taxless_total_price",
      metrics: [{
        avg: {}
      }, {
        sum: {}
      }, {
        max: {}
      }, {
        min: {}
      }, {
        value_count: {}
      }]
    }, {
      source_field: "total_quantity",
      metrics: [{
        avg: {}
      }, {
        max: {}
      }]
    }]
  },
  metadata: {
    test2: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      rollup_metadata: {
        rollup_id: "test2",
        last_updated_time: 1605724690355,
        status: "failed",
        failure_reason: "Cannot create target index.",
        stats: {
          pages_processed: 0,
          documents_processed: 0,
          rollups_indexed: 0,
          index_time_in_millis: 0,
          search_time_in_millis: 0
        }
      }
    }
  }
};
const testTransform = exports.testTransform = {
  _id: "test1",
  _seqNo: 6,
  _primaryTerm: 1,
  transform: {
    transform_id: "test1",
    schema_version: 11,
    schedule: {
      interval: {
        start_time: 1632951884470,
        period: 1,
        unit: "Minutes"
      }
    },
    metadata_id: "tFttMG7OTAehIakVVsAA-g",
    updated_at: 1632951944840,
    enabled: false,
    enabled_at: null,
    description: "",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    data_selection_query: {
      match: {
        customer_gender: {
          query: "FEMALE",
          operator: "OR",
          prefix_length: 0,
          max_expansions: 50,
          fuzzy_transpositions: true,
          lenient: false,
          zero_terms_query: "NONE",
          auto_generate_synonyms_phrase_query: true,
          boost: 1
        }
      }
    },
    target_index: "t",
    page_size: 1000,
    groups: [{
      terms: {
        source_field: "currency",
        target_field: "currency_terms"
      }
    }],
    aggregations: {}
  },
  metadata: {
    test1: {
      metadata_id: "tFttMG7OTAehIakVVsAA-g",
      transform_metadata: {
        transform_id: "test1",
        last_updated_at: 1632951944827,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 2,
          documents_processed: 2433,
          documents_indexed: 1,
          index_time_in_millis: 37,
          search_time_in_millis: 11
        }
      }
    }
  }
};
const testTransform2 = exports.testTransform2 = {
  _id: "test1",
  _version: 3,
  _seqNo: 7,
  _primaryTerm: 1,
  transform: {
    transform_id: "test1",
    enabled: true,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    metadata_id: null,
    updated_at: 1619725487957,
    enabled_at: 1619725487956,
    description: "Test transform using ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_transform",
    data_selection_query: {
      match_all: {}
    },
    page_size: 1000,
    roles: [],
    groups: [{
      terms: {
        source_field: "customer_gender",
        target_field: "gender"
      }
    }, {
      terms: {
        source_field: "day_of_week",
        target_field: "day"
      }
    }],
    aggregations: {
      quantity: {
        sum: {
          field: "total_quantity"
        }
      }
    }
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      transform_metadata: {
        transform_id: "test1",
        last_updated_time: 1605724690355,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          transforms_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
const testTransformDisabled = exports.testTransformDisabled = {
  _id: "test1",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  transform: {
    transform_id: "test1",
    enabled: false,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    metadata_id: null,
    updated_at: 1619725487957,
    enabled_at: 1619725487956,
    description: "Test transform using ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_transform",
    data_selection_query: {
      match_all: {}
    },
    page_size: 1000,
    roles: [],
    groups: [{
      terms: {
        source_field: "customer_gender",
        target_field: "gender"
      }
    }, {
      terms: {
        source_field: "day_of_week",
        target_field: "day"
      }
    }],
    aggregations: {
      quantity: {
        sum: {
          field: "total_quantity"
        }
      }
    }
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      transform_metadata: {
        transform_id: "test1",
        last_updated_time: 1605724690355,
        status: "started",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          transforms_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ0ZXN0Um9sbHVwIiwiZXhwb3J0cyIsIl9pZCIsIl92ZXJzaW9uIiwiX3NlcV9ubyIsIl9wcmltYXJ5X3Rlcm0iLCJyb2xsdXAiLCJyb2xsdXBfaWQiLCJlbmFibGVkIiwic2NoZWR1bGUiLCJpbnRlcnZhbCIsInBlcmlvZCIsInVuaXQiLCJzdGFydF90aW1lIiwibGFzdF91cGRhdGVkX3RpbWUiLCJkZXNjcmlwdGlvbiIsInNvdXJjZV9pbmRleCIsInRhcmdldF9pbmRleCIsInBhZ2Vfc2l6ZSIsImRlbGF5IiwiY29udGludW91cyIsIm1ldGFkYXRhX2lkIiwiZW5hYmxlZFRpbWUiLCJsYXN0VXBkYXRlZFRpbWUiLCJzY2hlbWFWZXJzaW9uIiwiZGltZW5zaW9ucyIsImRhdGVfaGlzdG9ncmFtIiwic291cmNlX2ZpZWxkIiwiZml4ZWRfaW50ZXJ2YWwiLCJ0aW1lem9uZSIsInRlcm1zIiwibWV0cmljcyIsImF2ZyIsInN1bSIsIm1heCIsIm1pbiIsInZhbHVlX2NvdW50IiwibWV0YWRhdGEiLCJ0ZXN0MSIsInJvbGx1cF9tZXRhZGF0YSIsInN0YXR1cyIsImZhaWx1cmVfcmVhc29uIiwic3RhdHMiLCJwYWdlc19wcm9jZXNzZWQiLCJkb2N1bWVudHNfcHJvY2Vzc2VkIiwicm9sbHVwc19pbmRleGVkIiwiaW5kZXhfdGltZV9pbl9taWxsaXMiLCJzZWFyY2hfdGltZV9pbl9taWxsaXMiLCJ0ZXN0Um9sbHVwMiIsInRlc3QyIiwidGVzdFRyYW5zZm9ybSIsIl9zZXFObyIsIl9wcmltYXJ5VGVybSIsInRyYW5zZm9ybSIsInRyYW5zZm9ybV9pZCIsInNjaGVtYV92ZXJzaW9uIiwidXBkYXRlZF9hdCIsImVuYWJsZWRfYXQiLCJkYXRhX3NlbGVjdGlvbl9xdWVyeSIsIm1hdGNoIiwiY3VzdG9tZXJfZ2VuZGVyIiwicXVlcnkiLCJvcGVyYXRvciIsInByZWZpeF9sZW5ndGgiLCJtYXhfZXhwYW5zaW9ucyIsImZ1enp5X3RyYW5zcG9zaXRpb25zIiwibGVuaWVudCIsInplcm9fdGVybXNfcXVlcnkiLCJhdXRvX2dlbmVyYXRlX3N5bm9ueW1zX3BocmFzZV9xdWVyeSIsImJvb3N0IiwiZ3JvdXBzIiwidGFyZ2V0X2ZpZWxkIiwiYWdncmVnYXRpb25zIiwidHJhbnNmb3JtX21ldGFkYXRhIiwibGFzdF91cGRhdGVkX2F0IiwiZG9jdW1lbnRzX2luZGV4ZWQiLCJ0ZXN0VHJhbnNmb3JtMiIsIm1hdGNoX2FsbCIsInJvbGVzIiwicXVhbnRpdHkiLCJmaWVsZCIsInRyYW5zZm9ybXNfaW5kZXhlZCIsInRlc3RUcmFuc2Zvcm1EaXNhYmxlZCJdLCJzb3VyY2VzIjpbImNvbnN0YW50cy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmV4cG9ydCBjb25zdCB0ZXN0Um9sbHVwID0ge1xuICBfaWQ6IFwidGVzdDFcIixcbiAgX3ZlcnNpb246IDMsXG4gIF9zZXFfbm86IDcsXG4gIF9wcmltYXJ5X3Rlcm06IDEsXG4gIHJvbGx1cDoge1xuICAgIHJvbGx1cF9pZDogXCJ0ZXN0MVwiLFxuICAgIGVuYWJsZWQ6IHRydWUsXG4gICAgc2NoZWR1bGU6IHtcbiAgICAgIGludGVydmFsOiB7XG4gICAgICAgIHBlcmlvZDogMSxcbiAgICAgICAgdW5pdDogXCJNaW51dGVzXCIsXG4gICAgICAgIHN0YXJ0X3RpbWU6IDE2MDIxMDA1NTMsXG4gICAgICB9LFxuICAgIH0sXG4gICAgbGFzdF91cGRhdGVkX3RpbWU6IDE2MDIxMDA1NTMsXG4gICAgZGVzY3JpcHRpb246IFwiQW4gZXhhbXBsZSBqb2IgdGhhdCByb2xscyB1cCB0aGUgc2FtcGxlIGVjb21tZXJjZSBkYXRhXCIsXG4gICAgc291cmNlX2luZGV4OiBcIm9wZW5zZWFyY2hfZGFzaGJvYXJkc19zYW1wbGVfZGF0YV9lY29tbWVyY2VcIixcbiAgICB0YXJnZXRfaW5kZXg6IFwidGVzdF9yb2xsdXBcIixcbiAgICBwYWdlX3NpemU6IDEwMDAsXG4gICAgZGVsYXk6IDAsXG4gICAgY29udGludW91czogZmFsc2UsXG4gICAgbWV0YWRhdGFfaWQ6IG51bGwsXG4gICAgZW5hYmxlZFRpbWU6IG51bGwsXG4gICAgbGFzdFVwZGF0ZWRUaW1lOiBudWxsLFxuICAgIHNjaGVtYVZlcnNpb246IDEsXG4gICAgZGltZW5zaW9uczogW1xuICAgICAge1xuICAgICAgICBkYXRlX2hpc3RvZ3JhbToge1xuICAgICAgICAgIHNvdXJjZV9maWVsZDogXCJvcmRlcl9kYXRlXCIsXG4gICAgICAgICAgZml4ZWRfaW50ZXJ2YWw6IFwiOTBtXCIsXG4gICAgICAgICAgdGltZXpvbmU6IFwiQW1lcmljYS9Mb3NfQW5nZWxlc1wiLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgdGVybXM6IHtcbiAgICAgICAgICBzb3VyY2VfZmllbGQ6IFwiY3VzdG9tZXJfZ2VuZGVyXCIsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAge1xuICAgICAgICB0ZXJtczoge1xuICAgICAgICAgIHNvdXJjZV9maWVsZDogXCJnZW9pcC5jaXR5X25hbWVcIixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICB7XG4gICAgICAgIHRlcm1zOiB7XG4gICAgICAgICAgc291cmNlX2ZpZWxkOiBcImdlb2lwLnJlZ2lvbl9uYW1lXCIsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAge1xuICAgICAgICB0ZXJtczoge1xuICAgICAgICAgIHNvdXJjZV9maWVsZDogXCJkYXlfb2Zfd2Vla1wiLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICBdLFxuICAgIG1ldHJpY3M6IFtcbiAgICAgIHtcbiAgICAgICAgc291cmNlX2ZpZWxkOiBcInRheGxlc3NfdG90YWxfcHJpY2VcIixcbiAgICAgICAgbWV0cmljczogW3sgYXZnOiB7fSB9LCB7IHN1bToge30gfSwgeyBtYXg6IHt9IH0sIHsgbWluOiB7fSB9LCB7IHZhbHVlX2NvdW50OiB7fSB9XSxcbiAgICAgIH0sXG4gICAgICB7XG4gICAgICAgIHNvdXJjZV9maWVsZDogXCJ0b3RhbF9xdWFudGl0eVwiLFxuICAgICAgICBtZXRyaWNzOiBbeyBhdmc6IHt9IH0sIHsgbWF4OiB7fSB9XSxcbiAgICAgIH0sXG4gICAgXSxcbiAgfSxcbiAgbWV0YWRhdGE6IHtcbiAgICB0ZXN0MToge1xuICAgICAgbWV0YWRhdGFfaWQ6IFwiR1NDbTNIVUJlR1JCNzhjRFFqdTZcIixcbiAgICAgIHJvbGx1cF9tZXRhZGF0YToge1xuICAgICAgICByb2xsdXBfaWQ6IFwidGVzdDFcIixcbiAgICAgICAgbGFzdF91cGRhdGVkX3RpbWU6IDE2MDU3MjQ2OTAzNTUsXG4gICAgICAgIHN0YXR1czogXCJmaW5pc2hlZFwiLFxuICAgICAgICBmYWlsdXJlX3JlYXNvbjogbnVsbCxcbiAgICAgICAgc3RhdHM6IHtcbiAgICAgICAgICBwYWdlc19wcm9jZXNzZWQ6IDUsXG4gICAgICAgICAgZG9jdW1lbnRzX3Byb2Nlc3NlZDogNDY3NSxcbiAgICAgICAgICByb2xsdXBzX2luZGV4ZWQ6IDM2MjcsXG4gICAgICAgICAgaW5kZXhfdGltZV9pbl9taWxsaXM6IDE1MjIsXG4gICAgICAgICAgc2VhcmNoX3RpbWVfaW5fbWlsbGlzOiAxMTY4LFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxufTtcblxuZXhwb3J0IGNvbnN0IHRlc3RSb2xsdXAyID0ge1xuICBfaWQ6IFwidGVzdDJcIixcbiAgX3ZlcnNpb246IDMsXG4gIF9zZXFfbm86IDcsXG4gIF9wcmltYXJ5X3Rlcm06IDEsXG4gIHJvbGx1cDoge1xuICAgIHJvbGx1cF9pZDogXCJ0ZXN0MlwiLFxuICAgIGVuYWJsZWQ6IGZhbHNlLFxuICAgIHNjaGVkdWxlOiB7XG4gICAgICBpbnRlcnZhbDoge1xuICAgICAgICBwZXJpb2Q6IDEsXG4gICAgICAgIHVuaXQ6IFwiTWludXRlc1wiLFxuICAgICAgICBzdGFydF90aW1lOiAxNjAyMTAwNTUzLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGxhc3RfdXBkYXRlZF90aW1lOiAxNjAyMTAwNTUzLFxuICAgIGRlc2NyaXB0aW9uOiBcIkFub3RoZXIgZXhhbXBsZSBqb2IgdGhhdCByb2xscyB1cCB0aGUgc2FtcGxlIGVjb21tZXJjZSBkYXRhXCIsXG4gICAgc291cmNlX2luZGV4OiBcIm9wZW5zZWFyY2hfZGFzaGJvYXJkc19zYW1wbGVfZGF0YV9lY29tbWVyY2VcIixcbiAgICB0YXJnZXRfaW5kZXg6IFwidGVzdF9yb2xsdXAyXCIsXG4gICAgcGFnZV9zaXplOiAxMDAwLFxuICAgIGRlbGF5OiAwLFxuICAgIGNvbnRpbnVvdXM6IGZhbHNlLFxuICAgIGRpbWVuc2lvbnM6IFtcbiAgICAgIHtcbiAgICAgICAgZGF0ZV9oaXN0b2dyYW06IHtcbiAgICAgICAgICBzb3VyY2VfZmllbGQ6IFwib3JkZXJfZGF0ZVwiLFxuICAgICAgICAgIGZpeGVkX2ludGVydmFsOiBcIjYwbVwiLFxuICAgICAgICAgIHRpbWV6b25lOiBcIkFtZXJpY2EvTG9zX0FuZ2VsZXNcIixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICB7XG4gICAgICAgIHRlcm1zOiB7XG4gICAgICAgICAgc291cmNlX2ZpZWxkOiBcImN1c3RvbWVyX2dlbmRlclwiLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgdGVybXM6IHtcbiAgICAgICAgICBzb3VyY2VfZmllbGQ6IFwiZ2VvaXAuY2l0eV9uYW1lXCIsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAge1xuICAgICAgICB0ZXJtczoge1xuICAgICAgICAgIHNvdXJjZV9maWVsZDogXCJnZW9pcC5yZWdpb25fbmFtZVwiLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgdGVybXM6IHtcbiAgICAgICAgICBzb3VyY2VfZmllbGQ6IFwiZGF5X29mX3dlZWtcIixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICB7XG4gICAgICAgIHRlcm1zOiB7XG4gICAgICAgICAgc291cmNlX2ZpZWxkOiBcImRheV9vZl93ZWVrX2lcIixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgXSxcbiAgICBtZXRyaWNzOiBbXG4gICAgICB7XG4gICAgICAgIHNvdXJjZV9maWVsZDogXCJ0YXhsZXNzX3RvdGFsX3ByaWNlXCIsXG4gICAgICAgIG1ldHJpY3M6IFt7IGF2Zzoge30gfSwgeyBzdW06IHt9IH0sIHsgbWF4OiB7fSB9LCB7IG1pbjoge30gfSwgeyB2YWx1ZV9jb3VudDoge30gfV0sXG4gICAgICB9LFxuICAgICAge1xuICAgICAgICBzb3VyY2VfZmllbGQ6IFwidG90YWxfcXVhbnRpdHlcIixcbiAgICAgICAgbWV0cmljczogW3sgYXZnOiB7fSB9LCB7IG1heDoge30gfV0sXG4gICAgICB9LFxuICAgIF0sXG4gIH0sXG4gIG1ldGFkYXRhOiB7XG4gICAgdGVzdDI6IHtcbiAgICAgIG1ldGFkYXRhX2lkOiBcIkdTQ20zSFVCZUdSQjc4Y0RRanU2XCIsXG4gICAgICByb2xsdXBfbWV0YWRhdGE6IHtcbiAgICAgICAgcm9sbHVwX2lkOiBcInRlc3QyXCIsXG4gICAgICAgIGxhc3RfdXBkYXRlZF90aW1lOiAxNjA1NzI0NjkwMzU1LFxuICAgICAgICBzdGF0dXM6IFwiZmFpbGVkXCIsXG4gICAgICAgIGZhaWx1cmVfcmVhc29uOiBcIkNhbm5vdCBjcmVhdGUgdGFyZ2V0IGluZGV4LlwiLFxuICAgICAgICBzdGF0czoge1xuICAgICAgICAgIHBhZ2VzX3Byb2Nlc3NlZDogMCxcbiAgICAgICAgICBkb2N1bWVudHNfcHJvY2Vzc2VkOiAwLFxuICAgICAgICAgIHJvbGx1cHNfaW5kZXhlZDogMCxcbiAgICAgICAgICBpbmRleF90aW1lX2luX21pbGxpczogMCxcbiAgICAgICAgICBzZWFyY2hfdGltZV9pbl9taWxsaXM6IDAsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG59O1xuXG5leHBvcnQgY29uc3QgdGVzdFRyYW5zZm9ybSA9IHtcbiAgX2lkOiBcInRlc3QxXCIsXG4gIF9zZXFObzogNixcbiAgX3ByaW1hcnlUZXJtOiAxLFxuICB0cmFuc2Zvcm06IHtcbiAgICB0cmFuc2Zvcm1faWQ6IFwidGVzdDFcIixcbiAgICBzY2hlbWFfdmVyc2lvbjogMTEsXG4gICAgc2NoZWR1bGU6IHtcbiAgICAgIGludGVydmFsOiB7XG4gICAgICAgIHN0YXJ0X3RpbWU6IDE2MzI5NTE4ODQ0NzAsXG4gICAgICAgIHBlcmlvZDogMSxcbiAgICAgICAgdW5pdDogXCJNaW51dGVzXCIsXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0YWRhdGFfaWQ6IFwidEZ0dE1HN09UQWVoSWFrVlZzQUEtZ1wiLFxuICAgIHVwZGF0ZWRfYXQ6IDE2MzI5NTE5NDQ4NDAsXG4gICAgZW5hYmxlZDogZmFsc2UsXG4gICAgZW5hYmxlZF9hdDogbnVsbCxcbiAgICBkZXNjcmlwdGlvbjogXCJcIixcbiAgICBzb3VyY2VfaW5kZXg6IFwib3BlbnNlYXJjaF9kYXNoYm9hcmRzX3NhbXBsZV9kYXRhX2Vjb21tZXJjZVwiLFxuICAgIGRhdGFfc2VsZWN0aW9uX3F1ZXJ5OiB7XG4gICAgICBtYXRjaDoge1xuICAgICAgICBjdXN0b21lcl9nZW5kZXI6IHtcbiAgICAgICAgICBxdWVyeTogXCJGRU1BTEVcIixcbiAgICAgICAgICBvcGVyYXRvcjogXCJPUlwiLFxuICAgICAgICAgIHByZWZpeF9sZW5ndGg6IDAsXG4gICAgICAgICAgbWF4X2V4cGFuc2lvbnM6IDUwLFxuICAgICAgICAgIGZ1enp5X3RyYW5zcG9zaXRpb25zOiB0cnVlLFxuICAgICAgICAgIGxlbmllbnQ6IGZhbHNlLFxuICAgICAgICAgIHplcm9fdGVybXNfcXVlcnk6IFwiTk9ORVwiLFxuICAgICAgICAgIGF1dG9fZ2VuZXJhdGVfc3lub255bXNfcGhyYXNlX3F1ZXJ5OiB0cnVlLFxuICAgICAgICAgIGJvb3N0OiAxLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIHRhcmdldF9pbmRleDogXCJ0XCIsXG4gICAgcGFnZV9zaXplOiAxMDAwLFxuICAgIGdyb3VwczogW1xuICAgICAge1xuICAgICAgICB0ZXJtczoge1xuICAgICAgICAgIHNvdXJjZV9maWVsZDogXCJjdXJyZW5jeVwiLFxuICAgICAgICAgIHRhcmdldF9maWVsZDogXCJjdXJyZW5jeV90ZXJtc1wiLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICBdLFxuICAgIGFnZ3JlZ2F0aW9uczoge30sXG4gIH0sXG4gIG1ldGFkYXRhOiB7XG4gICAgdGVzdDE6IHtcbiAgICAgIG1ldGFkYXRhX2lkOiBcInRGdHRNRzdPVEFlaElha1ZWc0FBLWdcIixcbiAgICAgIHRyYW5zZm9ybV9tZXRhZGF0YToge1xuICAgICAgICB0cmFuc2Zvcm1faWQ6IFwidGVzdDFcIixcbiAgICAgICAgbGFzdF91cGRhdGVkX2F0OiAxNjMyOTUxOTQ0ODI3LFxuICAgICAgICBzdGF0dXM6IFwiZmluaXNoZWRcIixcbiAgICAgICAgZmFpbHVyZV9yZWFzb246IG51bGwsXG4gICAgICAgIHN0YXRzOiB7XG4gICAgICAgICAgcGFnZXNfcHJvY2Vzc2VkOiAyLFxuICAgICAgICAgIGRvY3VtZW50c19wcm9jZXNzZWQ6IDI0MzMsXG4gICAgICAgICAgZG9jdW1lbnRzX2luZGV4ZWQ6IDEsXG4gICAgICAgICAgaW5kZXhfdGltZV9pbl9taWxsaXM6IDM3LFxuICAgICAgICAgIHNlYXJjaF90aW1lX2luX21pbGxpczogMTEsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG59O1xuXG5leHBvcnQgY29uc3QgdGVzdFRyYW5zZm9ybTIgPSB7XG4gIF9pZDogXCJ0ZXN0MVwiLFxuICBfdmVyc2lvbjogMyxcbiAgX3NlcU5vOiA3LFxuICBfcHJpbWFyeVRlcm06IDEsXG4gIHRyYW5zZm9ybToge1xuICAgIHRyYW5zZm9ybV9pZDogXCJ0ZXN0MVwiLFxuICAgIGVuYWJsZWQ6IHRydWUsXG4gICAgc2NoZWR1bGU6IHtcbiAgICAgIGludGVydmFsOiB7XG4gICAgICAgIHBlcmlvZDogMSxcbiAgICAgICAgdW5pdDogXCJNaW51dGVzXCIsXG4gICAgICAgIHN0YXJ0X3RpbWU6IDE2MDIxMDA1NTNcbiAgICAgIH1cbiAgICB9LFxuICAgIG1ldGFkYXRhX2lkOiBudWxsLFxuICAgIHVwZGF0ZWRfYXQ6IDE2MTk3MjU0ODc5NTcsXG4gICAgZW5hYmxlZF9hdDogMTYxOTcyNTQ4Nzk1NixcbiAgICBkZXNjcmlwdGlvbjogXCJUZXN0IHRyYW5zZm9ybSB1c2luZyBlY29tbWVyY2UgZGF0YVwiLFxuICAgIHNvdXJjZV9pbmRleDogXCJvcGVuc2VhcmNoX2Rhc2hib2FyZHNfc2FtcGxlX2RhdGFfZWNvbW1lcmNlXCIsXG4gICAgdGFyZ2V0X2luZGV4OiBcInRlc3RfdHJhbnNmb3JtXCIsXG4gICAgZGF0YV9zZWxlY3Rpb25fcXVlcnk6IHtcbiAgICAgIG1hdGNoX2FsbDoge31cbiAgICB9LFxuICAgIHBhZ2Vfc2l6ZTogMTAwMCxcbiAgICByb2xlczogWyBdLFxuICAgIGdyb3VwczogW1xuICAgICAge1xuICAgICAgICB0ZXJtczoge1xuICAgICAgICAgIHNvdXJjZV9maWVsZDogXCJjdXN0b21lcl9nZW5kZXJcIixcbiAgICAgICAgICB0YXJnZXRfZmllbGQ6IFwiZ2VuZGVyXCJcbiAgICAgICAgfVxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgdGVybXM6IHtcbiAgICAgICAgICBzb3VyY2VfZmllbGQ6IFwiZGF5X29mX3dlZWtcIixcbiAgICAgICAgICB0YXJnZXRfZmllbGQ6IFwiZGF5XCJcbiAgICAgICAgfVxuICAgICAgfVxuICAgIF0sXG4gICAgYWdncmVnYXRpb25zOiB7XG4gICAgICBxdWFudGl0eToge1xuICAgICAgICBzdW06IHtcbiAgICAgICAgICBmaWVsZDogXCJ0b3RhbF9xdWFudGl0eVwiXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIH0sXG4gIG1ldGFkYXRhOiB7XG4gICAgdGVzdDE6IHtcbiAgICAgIG1ldGFkYXRhX2lkOiBcIkdTQ20zSFVCZUdSQjc4Y0RRanU2XCIsXG4gICAgICB0cmFuc2Zvcm1fbWV0YWRhdGE6IHtcbiAgICAgICAgdHJhbnNmb3JtX2lkOiBcInRlc3QxXCIsXG4gICAgICAgIGxhc3RfdXBkYXRlZF90aW1lOiAxNjA1NzI0NjkwMzU1LFxuICAgICAgICBzdGF0dXM6IFwiZmluaXNoZWRcIixcbiAgICAgICAgZmFpbHVyZV9yZWFzb246IG51bGwsXG4gICAgICAgIHN0YXRzOiB7XG4gICAgICAgICAgcGFnZXNfcHJvY2Vzc2VkOiA1LFxuICAgICAgICAgIGRvY3VtZW50c19wcm9jZXNzZWQ6IDQ2NzUsXG4gICAgICAgICAgdHJhbnNmb3Jtc19pbmRleGVkOiAzNjI3LFxuICAgICAgICAgIGluZGV4X3RpbWVfaW5fbWlsbGlzOiAxNTIyLFxuICAgICAgICAgIHNlYXJjaF90aW1lX2luX21pbGxpczogMTE2OCxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfVxuICB9XG59XG5cbmV4cG9ydCBjb25zdCB0ZXN0VHJhbnNmb3JtRGlzYWJsZWQgPSB7XG4gIF9pZDogXCJ0ZXN0MVwiLFxuICBfdmVyc2lvbjogMyxcbiAgX3NlcV9ubzogNyxcbiAgX3ByaW1hcnlfdGVybTogMSxcbiAgdHJhbnNmb3JtOiB7XG4gICAgdHJhbnNmb3JtX2lkOiBcInRlc3QxXCIsXG4gICAgZW5hYmxlZDogZmFsc2UsXG4gICAgc2NoZWR1bGU6IHtcbiAgICAgIGludGVydmFsOiB7XG4gICAgICAgIHBlcmlvZDogMSxcbiAgICAgICAgdW5pdDogXCJNaW51dGVzXCIsXG4gICAgICAgIHN0YXJ0X3RpbWU6IDE2MDIxMDA1NTNcbiAgICAgIH1cbiAgICB9LFxuICAgIG1ldGFkYXRhX2lkOiBudWxsLFxuICAgIHVwZGF0ZWRfYXQ6IDE2MTk3MjU0ODc5NTcsXG4gICAgZW5hYmxlZF9hdDogMTYxOTcyNTQ4Nzk1NixcbiAgICBkZXNjcmlwdGlvbjogXCJUZXN0IHRyYW5zZm9ybSB1c2luZyBlY29tbWVyY2UgZGF0YVwiLFxuICAgIHNvdXJjZV9pbmRleDogXCJvcGVuc2VhcmNoX2Rhc2hib2FyZHNfc2FtcGxlX2RhdGFfZWNvbW1lcmNlXCIsXG4gICAgdGFyZ2V0X2luZGV4OiBcInRlc3RfdHJhbnNmb3JtXCIsXG4gICAgZGF0YV9zZWxlY3Rpb25fcXVlcnk6IHtcbiAgICAgIG1hdGNoX2FsbDoge31cbiAgICB9LFxuICAgIHBhZ2Vfc2l6ZTogMTAwMCxcbiAgICByb2xlczogWyBdLFxuICAgIGdyb3VwczogW1xuICAgICAge1xuICAgICAgICB0ZXJtczoge1xuICAgICAgICAgIHNvdXJjZV9maWVsZDogXCJjdXN0b21lcl9nZW5kZXJcIixcbiAgICAgICAgICB0YXJnZXRfZmllbGQ6IFwiZ2VuZGVyXCJcbiAgICAgICAgfVxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgdGVybXM6IHtcbiAgICAgICAgICBzb3VyY2VfZmllbGQ6IFwiZGF5X29mX3dlZWtcIixcbiAgICAgICAgICB0YXJnZXRfZmllbGQ6IFwiZGF5XCJcbiAgICAgICAgfVxuICAgICAgfVxuICAgIF0sXG4gICAgYWdncmVnYXRpb25zOiB7XG4gICAgICBxdWFudGl0eToge1xuICAgICAgICBzdW06IHtcbiAgICAgICAgICBmaWVsZDogXCJ0b3RhbF9xdWFudGl0eVwiXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIH0sXG4gIG1ldGFkYXRhOiB7XG4gICAgdGVzdDE6IHtcbiAgICAgIG1ldGFkYXRhX2lkOiBcIkdTQ20zSFVCZUdSQjc4Y0RRanU2XCIsXG4gICAgICB0cmFuc2Zvcm1fbWV0YWRhdGE6IHtcbiAgICAgICAgdHJhbnNmb3JtX2lkOiBcInRlc3QxXCIsXG4gICAgICAgIGxhc3RfdXBkYXRlZF90aW1lOiAxNjA1NzI0NjkwMzU1LFxuICAgICAgICBzdGF0dXM6IFwic3RhcnRlZFwiLFxuICAgICAgICBmYWlsdXJlX3JlYXNvbjogbnVsbCxcbiAgICAgICAgc3RhdHM6IHtcbiAgICAgICAgICBwYWdlc19wcm9jZXNzZWQ6IDUsXG4gICAgICAgICAgZG9jdW1lbnRzX3Byb2Nlc3NlZDogNDY3NSxcbiAgICAgICAgICB0cmFuc2Zvcm1zX2luZGV4ZWQ6IDM2MjcsXG4gICAgICAgICAgaW5kZXhfdGltZV9pbl9taWxsaXM6IDE1MjIsXG4gICAgICAgICAgc2VhcmNoX3RpbWVfaW5fbWlsbGlzOiAxMTY4LFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9XG4gIH1cbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBRU8sTUFBTUEsVUFBVSxHQUFBQyxPQUFBLENBQUFELFVBQUEsR0FBRztFQUN4QkUsR0FBRyxFQUFFLE9BQU87RUFDWkMsUUFBUSxFQUFFLENBQUM7RUFDWEMsT0FBTyxFQUFFLENBQUM7RUFDVkMsYUFBYSxFQUFFLENBQUM7RUFDaEJDLE1BQU0sRUFBRTtJQUNOQyxTQUFTLEVBQUUsT0FBTztJQUNsQkMsT0FBTyxFQUFFLElBQUk7SUFDYkMsUUFBUSxFQUFFO01BQ1JDLFFBQVEsRUFBRTtRQUNSQyxNQUFNLEVBQUUsQ0FBQztRQUNUQyxJQUFJLEVBQUUsU0FBUztRQUNmQyxVQUFVLEVBQUU7TUFDZDtJQUNGLENBQUM7SUFDREMsaUJBQWlCLEVBQUUsVUFBVTtJQUM3QkMsV0FBVyxFQUFFLHdEQUF3RDtJQUNyRUMsWUFBWSxFQUFFLDZDQUE2QztJQUMzREMsWUFBWSxFQUFFLGFBQWE7SUFDM0JDLFNBQVMsRUFBRSxJQUFJO0lBQ2ZDLEtBQUssRUFBRSxDQUFDO0lBQ1JDLFVBQVUsRUFBRSxLQUFLO0lBQ2pCQyxXQUFXLEVBQUUsSUFBSTtJQUNqQkMsV0FBVyxFQUFFLElBQUk7SUFDakJDLGVBQWUsRUFBRSxJQUFJO0lBQ3JCQyxhQUFhLEVBQUUsQ0FBQztJQUNoQkMsVUFBVSxFQUFFLENBQ1Y7TUFDRUMsY0FBYyxFQUFFO1FBQ2RDLFlBQVksRUFBRSxZQUFZO1FBQzFCQyxjQUFjLEVBQUUsS0FBSztRQUNyQkMsUUFBUSxFQUFFO01BQ1o7SUFDRixDQUFDLEVBQ0Q7TUFDRUMsS0FBSyxFQUFFO1FBQ0xILFlBQVksRUFBRTtNQUNoQjtJQUNGLENBQUMsRUFDRDtNQUNFRyxLQUFLLEVBQUU7UUFDTEgsWUFBWSxFQUFFO01BQ2hCO0lBQ0YsQ0FBQyxFQUNEO01BQ0VHLEtBQUssRUFBRTtRQUNMSCxZQUFZLEVBQUU7TUFDaEI7SUFDRixDQUFDLEVBQ0Q7TUFDRUcsS0FBSyxFQUFFO1FBQ0xILFlBQVksRUFBRTtNQUNoQjtJQUNGLENBQUMsQ0FDRjtJQUNESSxPQUFPLEVBQUUsQ0FDUDtNQUNFSixZQUFZLEVBQUUscUJBQXFCO01BQ25DSSxPQUFPLEVBQUUsQ0FBQztRQUFFQyxHQUFHLEVBQUUsQ0FBQztNQUFFLENBQUMsRUFBRTtRQUFFQyxHQUFHLEVBQUUsQ0FBQztNQUFFLENBQUMsRUFBRTtRQUFFQyxHQUFHLEVBQUUsQ0FBQztNQUFFLENBQUMsRUFBRTtRQUFFQyxHQUFHLEVBQUUsQ0FBQztNQUFFLENBQUMsRUFBRTtRQUFFQyxXQUFXLEVBQUUsQ0FBQztNQUFFLENBQUM7SUFDbkYsQ0FBQyxFQUNEO01BQ0VULFlBQVksRUFBRSxnQkFBZ0I7TUFDOUJJLE9BQU8sRUFBRSxDQUFDO1FBQUVDLEdBQUcsRUFBRSxDQUFDO01BQUUsQ0FBQyxFQUFFO1FBQUVFLEdBQUcsRUFBRSxDQUFDO01BQUUsQ0FBQztJQUNwQyxDQUFDO0VBRUwsQ0FBQztFQUNERyxRQUFRLEVBQUU7SUFDUkMsS0FBSyxFQUFFO01BQ0xqQixXQUFXLEVBQUUsc0JBQXNCO01BQ25Da0IsZUFBZSxFQUFFO1FBQ2ZoQyxTQUFTLEVBQUUsT0FBTztRQUNsQk8saUJBQWlCLEVBQUUsYUFBYTtRQUNoQzBCLE1BQU0sRUFBRSxVQUFVO1FBQ2xCQyxjQUFjLEVBQUUsSUFBSTtRQUNwQkMsS0FBSyxFQUFFO1VBQ0xDLGVBQWUsRUFBRSxDQUFDO1VBQ2xCQyxtQkFBbUIsRUFBRSxJQUFJO1VBQ3pCQyxlQUFlLEVBQUUsSUFBSTtVQUNyQkMsb0JBQW9CLEVBQUUsSUFBSTtVQUMxQkMscUJBQXFCLEVBQUU7UUFDekI7TUFDRjtJQUNGO0VBQ0Y7QUFDRixDQUFDO0FBRU0sTUFBTUMsV0FBVyxHQUFBL0MsT0FBQSxDQUFBK0MsV0FBQSxHQUFHO0VBQ3pCOUMsR0FBRyxFQUFFLE9BQU87RUFDWkMsUUFBUSxFQUFFLENBQUM7RUFDWEMsT0FBTyxFQUFFLENBQUM7RUFDVkMsYUFBYSxFQUFFLENBQUM7RUFDaEJDLE1BQU0sRUFBRTtJQUNOQyxTQUFTLEVBQUUsT0FBTztJQUNsQkMsT0FBTyxFQUFFLEtBQUs7SUFDZEMsUUFBUSxFQUFFO01BQ1JDLFFBQVEsRUFBRTtRQUNSQyxNQUFNLEVBQUUsQ0FBQztRQUNUQyxJQUFJLEVBQUUsU0FBUztRQUNmQyxVQUFVLEVBQUU7TUFDZDtJQUNGLENBQUM7SUFDREMsaUJBQWlCLEVBQUUsVUFBVTtJQUM3QkMsV0FBVyxFQUFFLDZEQUE2RDtJQUMxRUMsWUFBWSxFQUFFLDZDQUE2QztJQUMzREMsWUFBWSxFQUFFLGNBQWM7SUFDNUJDLFNBQVMsRUFBRSxJQUFJO0lBQ2ZDLEtBQUssRUFBRSxDQUFDO0lBQ1JDLFVBQVUsRUFBRSxLQUFLO0lBQ2pCSyxVQUFVLEVBQUUsQ0FDVjtNQUNFQyxjQUFjLEVBQUU7UUFDZEMsWUFBWSxFQUFFLFlBQVk7UUFDMUJDLGNBQWMsRUFBRSxLQUFLO1FBQ3JCQyxRQUFRLEVBQUU7TUFDWjtJQUNGLENBQUMsRUFDRDtNQUNFQyxLQUFLLEVBQUU7UUFDTEgsWUFBWSxFQUFFO01BQ2hCO0lBQ0YsQ0FBQyxFQUNEO01BQ0VHLEtBQUssRUFBRTtRQUNMSCxZQUFZLEVBQUU7TUFDaEI7SUFDRixDQUFDLEVBQ0Q7TUFDRUcsS0FBSyxFQUFFO1FBQ0xILFlBQVksRUFBRTtNQUNoQjtJQUNGLENBQUMsRUFDRDtNQUNFRyxLQUFLLEVBQUU7UUFDTEgsWUFBWSxFQUFFO01BQ2hCO0lBQ0YsQ0FBQyxFQUNEO01BQ0VHLEtBQUssRUFBRTtRQUNMSCxZQUFZLEVBQUU7TUFDaEI7SUFDRixDQUFDLENBQ0Y7SUFDREksT0FBTyxFQUFFLENBQ1A7TUFDRUosWUFBWSxFQUFFLHFCQUFxQjtNQUNuQ0ksT0FBTyxFQUFFLENBQUM7UUFBRUMsR0FBRyxFQUFFLENBQUM7TUFBRSxDQUFDLEVBQUU7UUFBRUMsR0FBRyxFQUFFLENBQUM7TUFBRSxDQUFDLEVBQUU7UUFBRUMsR0FBRyxFQUFFLENBQUM7TUFBRSxDQUFDLEVBQUU7UUFBRUMsR0FBRyxFQUFFLENBQUM7TUFBRSxDQUFDLEVBQUU7UUFBRUMsV0FBVyxFQUFFLENBQUM7TUFBRSxDQUFDO0lBQ25GLENBQUMsRUFDRDtNQUNFVCxZQUFZLEVBQUUsZ0JBQWdCO01BQzlCSSxPQUFPLEVBQUUsQ0FBQztRQUFFQyxHQUFHLEVBQUUsQ0FBQztNQUFFLENBQUMsRUFBRTtRQUFFRSxHQUFHLEVBQUUsQ0FBQztNQUFFLENBQUM7SUFDcEMsQ0FBQztFQUVMLENBQUM7RUFDREcsUUFBUSxFQUFFO0lBQ1JZLEtBQUssRUFBRTtNQUNMNUIsV0FBVyxFQUFFLHNCQUFzQjtNQUNuQ2tCLGVBQWUsRUFBRTtRQUNmaEMsU0FBUyxFQUFFLE9BQU87UUFDbEJPLGlCQUFpQixFQUFFLGFBQWE7UUFDaEMwQixNQUFNLEVBQUUsUUFBUTtRQUNoQkMsY0FBYyxFQUFFLDZCQUE2QjtRQUM3Q0MsS0FBSyxFQUFFO1VBQ0xDLGVBQWUsRUFBRSxDQUFDO1VBQ2xCQyxtQkFBbUIsRUFBRSxDQUFDO1VBQ3RCQyxlQUFlLEVBQUUsQ0FBQztVQUNsQkMsb0JBQW9CLEVBQUUsQ0FBQztVQUN2QkMscUJBQXFCLEVBQUU7UUFDekI7TUFDRjtJQUNGO0VBQ0Y7QUFDRixDQUFDO0FBRU0sTUFBTUcsYUFBYSxHQUFBakQsT0FBQSxDQUFBaUQsYUFBQSxHQUFHO0VBQzNCaEQsR0FBRyxFQUFFLE9BQU87RUFDWmlELE1BQU0sRUFBRSxDQUFDO0VBQ1RDLFlBQVksRUFBRSxDQUFDO0VBQ2ZDLFNBQVMsRUFBRTtJQUNUQyxZQUFZLEVBQUUsT0FBTztJQUNyQkMsY0FBYyxFQUFFLEVBQUU7SUFDbEI5QyxRQUFRLEVBQUU7TUFDUkMsUUFBUSxFQUFFO1FBQ1JHLFVBQVUsRUFBRSxhQUFhO1FBQ3pCRixNQUFNLEVBQUUsQ0FBQztRQUNUQyxJQUFJLEVBQUU7TUFDUjtJQUNGLENBQUM7SUFDRFMsV0FBVyxFQUFFLHdCQUF3QjtJQUNyQ21DLFVBQVUsRUFBRSxhQUFhO0lBQ3pCaEQsT0FBTyxFQUFFLEtBQUs7SUFDZGlELFVBQVUsRUFBRSxJQUFJO0lBQ2hCMUMsV0FBVyxFQUFFLEVBQUU7SUFDZkMsWUFBWSxFQUFFLDZDQUE2QztJQUMzRDBDLG9CQUFvQixFQUFFO01BQ3BCQyxLQUFLLEVBQUU7UUFDTEMsZUFBZSxFQUFFO1VBQ2ZDLEtBQUssRUFBRSxRQUFRO1VBQ2ZDLFFBQVEsRUFBRSxJQUFJO1VBQ2RDLGFBQWEsRUFBRSxDQUFDO1VBQ2hCQyxjQUFjLEVBQUUsRUFBRTtVQUNsQkMsb0JBQW9CLEVBQUUsSUFBSTtVQUMxQkMsT0FBTyxFQUFFLEtBQUs7VUFDZEMsZ0JBQWdCLEVBQUUsTUFBTTtVQUN4QkMsbUNBQW1DLEVBQUUsSUFBSTtVQUN6Q0MsS0FBSyxFQUFFO1FBQ1Q7TUFDRjtJQUNGLENBQUM7SUFDRHBELFlBQVksRUFBRSxHQUFHO0lBQ2pCQyxTQUFTLEVBQUUsSUFBSTtJQUNmb0QsTUFBTSxFQUFFLENBQ047TUFDRXhDLEtBQUssRUFBRTtRQUNMSCxZQUFZLEVBQUUsVUFBVTtRQUN4QjRDLFlBQVksRUFBRTtNQUNoQjtJQUNGLENBQUMsQ0FDRjtJQUNEQyxZQUFZLEVBQUUsQ0FBQztFQUNqQixDQUFDO0VBQ0RuQyxRQUFRLEVBQUU7SUFDUkMsS0FBSyxFQUFFO01BQ0xqQixXQUFXLEVBQUUsd0JBQXdCO01BQ3JDb0Qsa0JBQWtCLEVBQUU7UUFDbEJuQixZQUFZLEVBQUUsT0FBTztRQUNyQm9CLGVBQWUsRUFBRSxhQUFhO1FBQzlCbEMsTUFBTSxFQUFFLFVBQVU7UUFDbEJDLGNBQWMsRUFBRSxJQUFJO1FBQ3BCQyxLQUFLLEVBQUU7VUFDTEMsZUFBZSxFQUFFLENBQUM7VUFDbEJDLG1CQUFtQixFQUFFLElBQUk7VUFDekIrQixpQkFBaUIsRUFBRSxDQUFDO1VBQ3BCN0Isb0JBQW9CLEVBQUUsRUFBRTtVQUN4QkMscUJBQXFCLEVBQUU7UUFDekI7TUFDRjtJQUNGO0VBQ0Y7QUFDRixDQUFDO0FBRU0sTUFBTTZCLGNBQWMsR0FBQTNFLE9BQUEsQ0FBQTJFLGNBQUEsR0FBRztFQUM1QjFFLEdBQUcsRUFBRSxPQUFPO0VBQ1pDLFFBQVEsRUFBRSxDQUFDO0VBQ1hnRCxNQUFNLEVBQUUsQ0FBQztFQUNUQyxZQUFZLEVBQUUsQ0FBQztFQUNmQyxTQUFTLEVBQUU7SUFDVEMsWUFBWSxFQUFFLE9BQU87SUFDckI5QyxPQUFPLEVBQUUsSUFBSTtJQUNiQyxRQUFRLEVBQUU7TUFDUkMsUUFBUSxFQUFFO1FBQ1JDLE1BQU0sRUFBRSxDQUFDO1FBQ1RDLElBQUksRUFBRSxTQUFTO1FBQ2ZDLFVBQVUsRUFBRTtNQUNkO0lBQ0YsQ0FBQztJQUNEUSxXQUFXLEVBQUUsSUFBSTtJQUNqQm1DLFVBQVUsRUFBRSxhQUFhO0lBQ3pCQyxVQUFVLEVBQUUsYUFBYTtJQUN6QjFDLFdBQVcsRUFBRSxxQ0FBcUM7SUFDbERDLFlBQVksRUFBRSw2Q0FBNkM7SUFDM0RDLFlBQVksRUFBRSxnQkFBZ0I7SUFDOUJ5QyxvQkFBb0IsRUFBRTtNQUNwQm1CLFNBQVMsRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUNEM0QsU0FBUyxFQUFFLElBQUk7SUFDZjRELEtBQUssRUFBRSxFQUFHO0lBQ1ZSLE1BQU0sRUFBRSxDQUNOO01BQ0V4QyxLQUFLLEVBQUU7UUFDTEgsWUFBWSxFQUFFLGlCQUFpQjtRQUMvQjRDLFlBQVksRUFBRTtNQUNoQjtJQUNGLENBQUMsRUFDRDtNQUNFekMsS0FBSyxFQUFFO1FBQ0xILFlBQVksRUFBRSxhQUFhO1FBQzNCNEMsWUFBWSxFQUFFO01BQ2hCO0lBQ0YsQ0FBQyxDQUNGO0lBQ0RDLFlBQVksRUFBRTtNQUNaTyxRQUFRLEVBQUU7UUFDUjlDLEdBQUcsRUFBRTtVQUNIK0MsS0FBSyxFQUFFO1FBQ1Q7TUFDRjtJQUNGO0VBQ0YsQ0FBQztFQUNEM0MsUUFBUSxFQUFFO0lBQ1JDLEtBQUssRUFBRTtNQUNMakIsV0FBVyxFQUFFLHNCQUFzQjtNQUNuQ29ELGtCQUFrQixFQUFFO1FBQ2xCbkIsWUFBWSxFQUFFLE9BQU87UUFDckJ4QyxpQkFBaUIsRUFBRSxhQUFhO1FBQ2hDMEIsTUFBTSxFQUFFLFVBQVU7UUFDbEJDLGNBQWMsRUFBRSxJQUFJO1FBQ3BCQyxLQUFLLEVBQUU7VUFDTEMsZUFBZSxFQUFFLENBQUM7VUFDbEJDLG1CQUFtQixFQUFFLElBQUk7VUFDekJxQyxrQkFBa0IsRUFBRSxJQUFJO1VBQ3hCbkMsb0JBQW9CLEVBQUUsSUFBSTtVQUMxQkMscUJBQXFCLEVBQUU7UUFDekI7TUFDRjtJQUNGO0VBQ0Y7QUFDRixDQUFDO0FBRU0sTUFBTW1DLHFCQUFxQixHQUFBakYsT0FBQSxDQUFBaUYscUJBQUEsR0FBRztFQUNuQ2hGLEdBQUcsRUFBRSxPQUFPO0VBQ1pDLFFBQVEsRUFBRSxDQUFDO0VBQ1hDLE9BQU8sRUFBRSxDQUFDO0VBQ1ZDLGFBQWEsRUFBRSxDQUFDO0VBQ2hCZ0QsU0FBUyxFQUFFO0lBQ1RDLFlBQVksRUFBRSxPQUFPO0lBQ3JCOUMsT0FBTyxFQUFFLEtBQUs7SUFDZEMsUUFBUSxFQUFFO01BQ1JDLFFBQVEsRUFBRTtRQUNSQyxNQUFNLEVBQUUsQ0FBQztRQUNUQyxJQUFJLEVBQUUsU0FBUztRQUNmQyxVQUFVLEVBQUU7TUFDZDtJQUNGLENBQUM7SUFDRFEsV0FBVyxFQUFFLElBQUk7SUFDakJtQyxVQUFVLEVBQUUsYUFBYTtJQUN6QkMsVUFBVSxFQUFFLGFBQWE7SUFDekIxQyxXQUFXLEVBQUUscUNBQXFDO0lBQ2xEQyxZQUFZLEVBQUUsNkNBQTZDO0lBQzNEQyxZQUFZLEVBQUUsZ0JBQWdCO0lBQzlCeUMsb0JBQW9CLEVBQUU7TUFDcEJtQixTQUFTLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFDRDNELFNBQVMsRUFBRSxJQUFJO0lBQ2Y0RCxLQUFLLEVBQUUsRUFBRztJQUNWUixNQUFNLEVBQUUsQ0FDTjtNQUNFeEMsS0FBSyxFQUFFO1FBQ0xILFlBQVksRUFBRSxpQkFBaUI7UUFDL0I0QyxZQUFZLEVBQUU7TUFDaEI7SUFDRixDQUFDLEVBQ0Q7TUFDRXpDLEtBQUssRUFBRTtRQUNMSCxZQUFZLEVBQUUsYUFBYTtRQUMzQjRDLFlBQVksRUFBRTtNQUNoQjtJQUNGLENBQUMsQ0FDRjtJQUNEQyxZQUFZLEVBQUU7TUFDWk8sUUFBUSxFQUFFO1FBQ1I5QyxHQUFHLEVBQUU7VUFDSCtDLEtBQUssRUFBRTtRQUNUO01BQ0Y7SUFDRjtFQUNGLENBQUM7RUFDRDNDLFFBQVEsRUFBRTtJQUNSQyxLQUFLLEVBQUU7TUFDTGpCLFdBQVcsRUFBRSxzQkFBc0I7TUFDbkNvRCxrQkFBa0IsRUFBRTtRQUNsQm5CLFlBQVksRUFBRSxPQUFPO1FBQ3JCeEMsaUJBQWlCLEVBQUUsYUFBYTtRQUNoQzBCLE1BQU0sRUFBRSxTQUFTO1FBQ2pCQyxjQUFjLEVBQUUsSUFBSTtRQUNwQkMsS0FBSyxFQUFFO1VBQ0xDLGVBQWUsRUFBRSxDQUFDO1VBQ2xCQyxtQkFBbUIsRUFBRSxJQUFJO1VBQ3pCcUMsa0JBQWtCLEVBQUUsSUFBSTtVQUN4Qm5DLG9CQUFvQixFQUFFLElBQUk7VUFDMUJDLHFCQUFxQixFQUFFO1FBQ3pCO01BQ0Y7SUFDRjtFQUNGO0FBQ0YsQ0FBQyJ9