"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerResourceRoutes = registerResourceRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../../common");
var _resource_manager_service = require("../../connections/resource_manager_service");
var _ = require("..");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const body = _configSchema.schema.object({
  connection: _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string()
  }),
  resource: _configSchema.schema.object({
    name: _configSchema.schema.maybe(_configSchema.schema.string()),
    type: _configSchema.schema.string()
  }),
  content: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
/**
 * Defines routes for resource APIs.
 *
 * @experimental This function is experimental and might change in future releases.
 *
 * @param router - The router instance.
 */
function registerResourceRoutes(router) {
  router.post({
    path: `${_common.BASE_API}/resources`,
    validate: {
      body
    }
  }, async (context, request, response) => {
    const {
      type
    } = request.body.connection;
    const manager = _resource_manager_service.resourceManagerService.getManager(type);
    if (!manager) {
      return response.notFound();
    }
    try {
      const resourcesResponse = await manager.handlePostRequest(context, request);
      return response.ok({
        body: resourcesResponse
      });
    } catch (error) {
      var _ref;
      const errorObj = error;
      return response.customError({
        body: (_ref = 'Unable to get resources: ' + errorObj.message) !== null && _ref !== void 0 ? _ref : '',
        ...errorObj,
        statusCode: (0, _.coerceStatusCode)(errorObj.statusCode)
      });
    }
  });
}