function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { useMemo } from 'react';
import Diff from 'text-diff';
import classNames from 'classnames';
export var useOuiTextDiff = function useOuiTextDiff(_ref) {
  var className = _ref.className,
    _ref$insertComponent = _ref.insertComponent,
    insertComponent = _ref$insertComponent === void 0 ? 'ins' : _ref$insertComponent,
    _ref$deleteComponent = _ref.deleteComponent,
    deleteComponent = _ref$deleteComponent === void 0 ? 'del' : _ref$deleteComponent,
    sameComponent = _ref.sameComponent,
    _ref$beforeText = _ref.beforeText,
    beforeText = _ref$beforeText === void 0 ? '' : _ref$beforeText,
    _ref$afterText = _ref.afterText,
    afterText = _ref$afterText === void 0 ? '' : _ref$afterText,
    _ref$timeout = _ref.timeout,
    timeout = _ref$timeout === void 0 ? 0.1 : _ref$timeout,
    rest = _objectWithoutProperties(_ref, ["className", "insertComponent", "deleteComponent", "sameComponent", "beforeText", "afterText", "timeout"]);
  var textDiff = useMemo(function () {
    var diff = new Diff({
      timeout: timeout
    }); // options may be passed to constructor

    return diff.main(beforeText, afterText);
  }, [beforeText, afterText, timeout]); // produces diff array

  var classes = classNames('ouiTextDiff', className);
  var rendereredHtml = useMemo(function () {
    var html = [];
    if (textDiff) for (var i = 0; i < textDiff.length; i++) {
      var Element = void 0;
      var el = textDiff[i];
      if (el[0] === 1) Element = insertComponent;else if (el[0] === -1) Element = deleteComponent;else if (sameComponent) Element = sameComponent;
      if (Element) html.push(/*#__PURE__*/React.createElement(Element, {
        key: i
      }, el[1]));else html.push(el[1]);
    }
    return html;
  }, [textDiff, deleteComponent, insertComponent, sameComponent]); // produces diff array

  return [/*#__PURE__*/React.createElement("div", _extends({
    className: classes
  }, rest), rendereredHtml), textDiff];
};

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */export { useEuiTextDiff } from '../../eui_components/text_diff/text_diff';