/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

export { OuiDragDropContext } from './drag_drop_context';
export { OuiDraggable } from './draggable';
export { OuiDroppable } from './droppable';
export { ouiDragDropCopy, ouiDragDropMove, ouiDragDropReorder } from './services';

// Interfaces in react-beautiful-dnd that OUI abstracts over
// allows consumers to pull these from OUI instead of react-beautiful-dnd
export {} from 'react-beautiful-dnd';

/* OUI -> EUI Aliases: Build-Time */
export { EuiDragDropContext } from '../../eui_components/drag_and_drop/drag_drop_context';
/* OUI -> EUI Aliases: Build-Time */
export { EuiDraggable } from '../../eui_components/drag_and_drop/draggable';
/* OUI -> EUI Aliases: Build-Time */
export { EuiDroppable } from '../../eui_components/drag_and_drop/droppable';
/* OUI -> EUI Aliases: Build-Time */
export { euiDragDropCopy, euiDragDropMove, euiDragDropReorder } from '../../eui_components/drag_and_drop/services';