function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiScreenReaderOnly } from '../accessibility';
import { OuiI18n } from '../i18n';
var HUE_RANGE = 359;
export var OuiHue = function OuiHue(_ref) {
  var className = _ref.className,
    hex = _ref.hex,
    _ref$hue = _ref.hue,
    hue = _ref$hue === void 0 ? 1 : _ref$hue,
    id = _ref.id,
    onChange = _ref.onChange,
    rest = _objectWithoutProperties(_ref, ["className", "hex", "hue", "id", "onChange"]);
  var handleChange = function handleChange(e) {
    onChange(Number(e.target.value));
  };
  var classes = classNames('ouiHue', className);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(OuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("label", {
    htmlFor: "".concat(id, "-hue")
  }, /*#__PURE__*/React.createElement(OuiI18n, {
    token: "ouiHue.label",
    default: "Select the HSV color mode 'hue' value"
  }))), /*#__PURE__*/React.createElement(OuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", {
    "aria-live": "polite"
  }, hex)), /*#__PURE__*/React.createElement("div", {
    className: classes
  }, /*#__PURE__*/React.createElement("input", _extends({
    id: "".concat(id, "-hue"),
    min: 0,
    max: HUE_RANGE,
    step: 1,
    type: "range",
    className: "ouiHue__range",
    value: hue,
    onChange: handleChange
  }, rest))));
};

/* OUI -> EUI Aliases: Build-Time */
OuiHue.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  hex: PropTypes.string,
  hue: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]),
  onChange: PropTypes.func.isRequired
};
/* OUI -> EUI Aliases: Build-Time */export { EuiHue } from '../../eui_components/color_picker/hue';