/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Stack;

public class IndexIntervalManager {
    protected int capacity;
    protected int[] freeIndexesStart;
    protected int[] freeIndexesEnd;
    protected int lastInUse;

    public IndexIntervalManager(int capacity) {
        CommonUtils.checkArgument(capacity > 0, "incorrect parameters");
        this.freeIndexesEnd = new int[1];
        this.freeIndexesStart = new int[1];
        this.lastInUse = 1;
        this.capacity = capacity;
        this.freeIndexesStart[0] = 0;
        this.freeIndexesEnd[0] = capacity - 1;
    }

    static BitSet toBits(int[] refCount) {
        CommonUtils.checkArgument(refCount != null, "not a meaningful array input");
        BitSet bits = new BitSet(refCount.length);
        for (int i = 0; i < refCount.length; ++i) {
            if (refCount[i] <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public IndexIntervalManager(int[] refCount, int capacity) {
        this(capacity, refCount.length, IndexIntervalManager.toBits(refCount));
    }

    public IndexIntervalManager(int capacity, int length, BitSet bits) {
        CommonUtils.checkArgument(bits != null, " null bitset not allowed");
        this.capacity = capacity;
        int first = bits.nextClearBit(0);
        Stack<int[]> stack = new Stack<int[]>();
        while (first < length) {
            int last = bits.nextSetBit(first) - 1;
            if (last >= first) {
                stack.push(new int[]{first, last});
                first = bits.nextClearBit(last + 1);
                if (first >= 0) continue;
                break;
            }
            if (first < length - 1) {
                if (bits.nextClearBit(first + 1) == first + 1) {
                    stack.push(new int[]{first, length - 1});
                    break;
                }
                stack.push(new int[]{first, first});
                break;
            }
            stack.push(new int[]{length - 1, length - 1});
            break;
        }
        this.lastInUse = stack.size();
        this.freeIndexesEnd = new int[this.lastInUse + 1];
        this.freeIndexesStart = new int[this.lastInUse + 1];
        this.capacity = capacity;
        int count = 0;
        while (stack.size() > 0) {
            int[] interval = (int[])stack.pop();
            this.freeIndexesStart[count] = interval[0];
            this.freeIndexesEnd[count] = interval[1];
            ++count;
        }
    }

    public void extendCapacity(int newCapacity) {
        CommonUtils.checkArgument(newCapacity > this.capacity, " incorrect call, we can only increase capacity");
        if (this.freeIndexesStart.length == this.lastInUse) {
            this.freeIndexesStart = Arrays.copyOf(this.freeIndexesStart, this.lastInUse + 1);
            this.freeIndexesEnd = Arrays.copyOf(this.freeIndexesEnd, this.lastInUse + 1);
        }
        this.freeIndexesStart[this.lastInUse] = this.capacity;
        this.freeIndexesEnd[this.lastInUse] = newCapacity - 1;
        ++this.lastInUse;
        this.capacity = newCapacity;
    }

    public boolean isEmpty() {
        return this.lastInUse == 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int size() {
        int sum = 0;
        for (int i = 0; i < this.lastInUse; ++i) {
            sum += this.freeIndexesEnd[i] - this.freeIndexesStart[i] + 1;
        }
        return sum;
    }

    public int takeIndex() {
        CommonUtils.checkState(this.lastInUse > 0, "store is full");
        int answer = this.freeIndexesStart[this.lastInUse - 1];
        if (answer == this.freeIndexesEnd[this.lastInUse - 1]) {
            --this.lastInUse;
        } else {
            this.freeIndexesStart[this.lastInUse - 1] = answer + 1;
        }
        return answer;
    }

    public void releaseIndex(int index) {
        if (this.lastInUse > 0) {
            int start = this.freeIndexesStart[this.lastInUse - 1];
            int end = this.freeIndexesEnd[this.lastInUse - 1];
            if (start == index + 1) {
                this.freeIndexesStart[this.lastInUse - 1] = index;
                return;
            }
            if (end + 1 == index) {
                this.freeIndexesEnd[this.lastInUse - 1] = index;
                return;
            }
        }
        if (this.freeIndexesStart.length == this.lastInUse) {
            this.freeIndexesStart = Arrays.copyOf(this.freeIndexesStart, this.lastInUse + 1);
            this.freeIndexesEnd = Arrays.copyOf(this.freeIndexesEnd, this.lastInUse + 1);
        }
        this.freeIndexesStart[this.lastInUse] = index;
        this.freeIndexesEnd[this.lastInUse] = index;
        ++this.lastInUse;
    }
}

