/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.internal.hppc.CharCursor;
import org.apache.lucene.internal.hppc.ObjectCursor;
import org.egothor.stemmer.Cell;
import org.egothor.stemmer.Row;
import org.egothor.stemmer.Trie;

public class Reduce {
    public Trie optimize(Trie orig) {
        List<CharSequence> cmds = orig.cmds;
        List<Row> rows = new ArrayList<Row>();
        List<Row> orows = orig.rows;
        int[] remap = new int[orows.size()];
        Arrays.fill(remap, -1);
        rows = this.removeGaps(orig.root, rows, new ArrayList<Row>(), remap);
        return new Trie(orig.forward, remap[orig.root], cmds, rows);
    }

    List<Row> removeGaps(int ind, List<Row> old, List<Row> to, int[] remap) {
        remap[ind] = to.size();
        Row now = old.get(ind);
        to.add(now);
        Iterator i = now.cells.values().iterator();
        while (i.hasNext()) {
            Cell c = (Cell)((ObjectCursor)i.next()).value;
            if (c.ref < 0 || remap[c.ref] >= 0) continue;
            this.removeGaps(c.ref, old, to, remap);
        }
        to.set(remap[ind], new Remap(this, now, remap));
        return to;
    }

    class Remap
    extends Row {
        public Remap(Reduce this$0, Row old, int[] remap) {
            Iterator i = old.cells.keys().iterator();
            while (i.hasNext()) {
                Cell nc;
                char ch = ((CharCursor)i.next()).value;
                Cell c = old.at(ch);
                if (c.ref >= 0) {
                    nc = new Cell(c);
                    nc.ref = remap[nc.ref];
                } else {
                    nc = new Cell(c);
                }
                this.cells.put(ch, (Object)nc);
            }
        }
    }
}

