/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.document;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.opensearch.common.Numbers;

public abstract class SortedUnsignedLongDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;

    SortedUnsignedLongDocValuesRangeQuery(String field, BigInteger lowerValue, BigInteger upperValue) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue.longValue();
        this.upperValue = upperValue.longValue();
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedUnsignedLongDocValuesRangeQuery that = (SortedUnsignedLongDocValuesRangeQuery)((Object)obj);
        return Objects.equals(this.field, that.field) && this.lowerValue == that.lowerValue && this.upperValue == that.upperValue;
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Long.hashCode(this.lowerValue);
        h = 31 * h + Long.hashCode(this.upperValue);
        return h;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(Long.toUnsignedString(this.lowerValue)).append(" TO ").append(Long.toUnsignedString(this.upperValue)).append("]").toString();
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        if (Long.compareUnsigned(this.lowerValue, Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG) == 0 && Long.compareUnsigned(this.upperValue, Numbers.MAX_UNSIGNED_LONG_VALUE_AS_LONG) == 0) {
            return new FieldExistsQuery(this.field);
        }
        return super.rewrite(searcher);
    }

    abstract SortedNumericDocValues getValues(LeafReader var1, String var2) throws IOException;

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{SortedUnsignedLongDocValuesRangeQuery.this.field});
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = SortedUnsignedLongDocValuesRangeQuery.this.getValues(context.reader(), SortedUnsignedLongDocValuesRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator((DocIdSetIterator)singleton){

                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return Long.compareUnsigned(value, SortedUnsignedLongDocValuesRangeQuery.this.lowerValue) >= 0 && Long.compareUnsigned(value, SortedUnsignedLongDocValuesRangeQuery.this.upperValue) <= 0;
                    }

                    public float matchCost() {
                        return 2.0f;
                    }
                } : new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (Long.compareUnsigned(value, SortedUnsignedLongDocValuesRangeQuery.this.lowerValue) < 0) continue;
                            return Long.compareUnsigned(value, SortedUnsignedLongDocValuesRangeQuery.this.upperValue) <= 0;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 2.0f;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, iterator);
                return new Weight.DefaultScorerSupplier((Scorer)scorer);
            }
        };
    }

    public static Query newSlowRangeQuery(String field, BigInteger lowerValue, BigInteger upperValue) {
        return new SortedUnsignedLongDocValuesRangeQuery(field, lowerValue, upperValue){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                FieldInfo info = reader.getFieldInfos().fieldInfo(field);
                if (info == null) {
                    return null;
                }
                return DocValues.getSortedNumeric((LeafReader)reader, (String)field);
            }
        };
    }
}

