/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import org.opensearch.cluster.AckedClusterStateTaskListener;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.Priority;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;

public abstract class AckedClusterStateUpdateTask<Response>
extends ClusterStateUpdateTask
implements AckedClusterStateTaskListener {
    private final ActionListener<Response> listener;
    private final AckedRequest request;

    protected AckedClusterStateUpdateTask(AckedRequest request, ActionListener<Response> listener) {
        this(Priority.NORMAL, request, listener);
    }

    protected AckedClusterStateUpdateTask(Priority priority, AckedRequest request, ActionListener<Response> listener) {
        super(priority);
        this.listener = listener;
        this.request = request;
    }

    @Override
    public boolean mustAck(DiscoveryNode discoveryNode) {
        return true;
    }

    @Override
    public void onAllNodesAcked(@Nullable Exception e) {
        this.listener.onResponse(this.newResponse(e == null));
    }

    protected abstract Response newResponse(boolean var1);

    @Override
    public void onAckTimeout() {
        this.listener.onResponse(this.newResponse(false));
    }

    @Override
    public void onFailure(String source, Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public TimeValue ackTimeout() {
        return this.request.ackTimeout();
    }

    @Override
    public TimeValue timeout() {
        return this.request.clusterManagerNodeTimeout();
    }
}

