/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.document.bulk;

import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.Requests;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.common.RefreshProtoUtils;
import org.opensearch.transport.grpc.proto.request.document.bulk.ActiveShardCountProtoUtils;
import org.opensearch.transport.grpc.proto.request.document.bulk.BulkRequestParserProtoUtils;

public class BulkRequestProtoUtils {
    private BulkRequestProtoUtils() {
    }

    public static org.opensearch.action.bulk.BulkRequest prepareRequest(BulkRequest request) {
        Boolean defaultRequireAlias;
        String defaultPipeline;
        org.opensearch.action.bulk.BulkRequest bulkRequest = Requests.bulkRequest();
        String defaultIndex = request.hasIndex() ? request.getIndex() : null;
        String defaultRouting = request.hasRouting() ? request.getRouting() : null;
        FetchSourceContext defaultFetchSourceContext = FetchSourceContextProtoUtils.parseFromProtoRequest(request);
        String string = defaultPipeline = request.hasPipeline() ? request.getPipeline() : null;
        if (request.hasWaitForActiveShards()) {
            bulkRequest.waitForActiveShards(ActiveShardCountProtoUtils.parseProto(request.getWaitForActiveShards()));
        }
        Boolean bl = defaultRequireAlias = request.hasRequireAlias() ? Boolean.valueOf(request.getRequireAlias()) : null;
        if (request.hasTimeout()) {
            bulkRequest.timeout(request.getTimeout());
        } else {
            bulkRequest.timeout(BulkShardRequest.DEFAULT_TIMEOUT);
        }
        bulkRequest.setRefreshPolicy(RefreshProtoUtils.getRefreshPolicy(request.getRefresh()));
        bulkRequest.add(BulkRequestParserProtoUtils.getDocWriteRequests(request, defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias));
        return bulkRequest;
    }
}

