/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.util.Properties;

class EntropyGatherer
implements Runnable {
    private final int numBytes;
    private final SecureRandom baseRandom;
    private final AtomicBoolean seedAvailable;
    private final AtomicReference<byte[]> entropy;

    EntropyGatherer(int n, SecureRandom secureRandom, AtomicBoolean atomicBoolean, AtomicReference<byte[]> atomicReference) {
        this.numBytes = n;
        this.baseRandom = secureRandom;
        this.seedAvailable = atomicBoolean;
        this.entropy = atomicReference;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        byte[] byArray;
        int n;
        long l;
        String string = Properties.getPropertyValue("org.bouncycastle.drbg.gather_pause_secs");
        if (string != null) {
            try {
                l = Long.parseLong(string) * 1000L;
            }
            catch (Exception exception) {
                l = 5000L;
            }
        } else {
            l = 5000L;
        }
        byte[] byArray2 = new byte[this.numBytes];
        for (n = 0; n < this.numBytes / 8; ++n) {
            this.sleep(l);
            byArray = this.baseRandom.generateSeed(8);
            System.arraycopy(byArray, 0, byArray2, n * 8, byArray.length);
        }
        n = this.numBytes - this.numBytes / 8 * 8;
        if (n != 0) {
            this.sleep(l);
            byArray = this.baseRandom.generateSeed(n);
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        }
        this.entropy.set(byArray2);
        this.seedAvailable.set(true);
    }
}

