/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.rest;

import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rule.action.DeleteRuleAction;
import org.opensearch.rule.action.DeleteRuleRequest;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestDeleteRuleAction
extends BaseRestHandler {
    public String getName() {
        return "delete_rule";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "_rules/{featureType}/{id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        String ruleId = request.param("id");
        FeatureType featureType = FeatureType.from((String)request.param("featureType"));
        DeleteRuleRequest deleteRuleRequest = new DeleteRuleRequest(ruleId, featureType);
        return channel -> client.execute((ActionType)DeleteRuleAction.INSTANCE, (ActionRequest)deleteRuleRequest, this.deleteRuleResponse((RestChannel)channel));
    }

    private RestResponseListener<AcknowledgedResponse> deleteRuleResponse(RestChannel channel) {
        return new RestResponseListener<AcknowledgedResponse>(this, channel){

            public RestResponse buildResponse(AcknowledgedResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, this.channel.newBuilder().startObject().field("acknowledged", response.isAcknowledged()).endObject());
            }
        };
    }
}

