/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.converters;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.BooleanDeserializer;
import org.apache.kafka.common.serialization.BooleanSerializer;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.converters.BooleanConverterConfig;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.storage.HeaderConverter;

public class BooleanConverter
implements Converter,
HeaderConverter,
Versioned {
    private final BooleanSerializer serializer = new BooleanSerializer();
    private final BooleanDeserializer deserializer = new BooleanDeserializer();

    public ConfigDef config() {
        return BooleanConverterConfig.configDef();
    }

    public void configure(Map<String, ?> configs) {
        BooleanConverterConfig conf = new BooleanConverterConfig(configs);
        boolean isKey = conf.type() == ConverterType.KEY;
        this.serializer.configure(configs, isKey);
        this.deserializer.configure(configs, isKey);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        HashMap conf = new HashMap(configs);
        conf.put("converter.type", isKey ? ConverterType.KEY.getName() : ConverterType.VALUE.getName());
        this.configure(conf);
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        if (schema != null && schema.type() != Schema.Type.BOOLEAN) {
            throw new DataException("Invalid schema type for BooleanConverter: " + schema.type().toString());
        }
        try {
            return this.serializer.serialize(topic, (Boolean)value);
        }
        catch (ClassCastException e) {
            throw new DataException("BooleanConverter is not compatible with objects of type " + String.valueOf(value.getClass()));
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        try {
            return new SchemaAndValue(Schema.OPTIONAL_BOOLEAN_SCHEMA, (Object)this.deserializer.deserialize(topic, value));
        }
        catch (SerializationException e) {
            throw new DataException("Failed to deserialize boolean: ", (Throwable)e);
        }
    }

    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    public void close() {
        Utils.closeQuietly((AutoCloseable)this.serializer, (String)"boolean converter serializer");
        Utils.closeQuietly((AutoCloseable)this.deserializer, (String)"boolean converter deserializer");
    }

    public String version() {
        return AppInfoParser.getVersion();
    }
}

