/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;

public interface Group {
    public GroupType type();

    public String stateAsString();

    public String stateAsString(long var1);

    public ListGroupsResponseData.ListedGroup asListedGroup(long var1);

    public String groupId();

    public void validateOffsetCommit(String var1, String var2, int var3, boolean var4, int var5) throws KafkaException;

    public void validateOffsetFetch(String var1, int var2, long var3) throws KafkaException;

    public void validateOffsetDelete() throws KafkaException;

    public void validateDeleteGroup() throws KafkaException;

    public boolean isSubscribedToTopic(String var1);

    public void createGroupTombstoneRecords(List<CoordinatorRecord> var1);

    public boolean isEmpty();

    public Optional<OffsetExpirationCondition> offsetExpirationCondition();

    public boolean isInStates(Set<String> var1, long var2);

    public boolean hasMember(String var1);

    public int numMembers();

    public void requestMetadataRefresh();

    default public boolean shouldExpire() {
        return true;
    }

    public static enum GroupType {
        CONSUMER("consumer"),
        CLASSIC("classic"),
        SHARE("share"),
        STREAMS("streams"),
        UNKNOWN("unknown");

        private final String name;
        private static final Map<String, GroupType> NAME_TO_ENUM;

        private GroupType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static GroupType parse(String name) {
            if (name == null) {
                return UNKNOWN;
            }
            GroupType type = NAME_TO_ENUM.get(name.toLowerCase(Locale.ROOT));
            return type == null ? UNKNOWN : type;
        }

        static String[] documentValidValues() {
            return (String[])Arrays.stream(GroupType.values()).filter(type -> type != UNKNOWN).map(GroupType::toString).toArray(String[]::new);
        }

        static {
            NAME_TO_ENUM = Arrays.stream(GroupType.values()).collect(Collectors.toMap(type -> type.name.toLowerCase(Locale.ROOT), Function.identity()));
        }
    }
}

