/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.purgatory.DelayedOperationKey;

public class TopicPartitionOperationKey
implements DelayedOperationKey {
    public final String topic;
    public final int partition;

    public TopicPartitionOperationKey(String topic, int partition) {
        this.topic = topic;
        this.partition = partition;
    }

    public TopicPartitionOperationKey(TopicPartition tp) {
        this(tp.topic(), tp.partition());
    }

    public TopicPartitionOperationKey(TopicIdPartition tp) {
        this(tp.topic(), tp.partition());
    }

    @Override
    public String keyLabel() {
        return this.topic + "-" + this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionOperationKey that = (TopicPartitionOperationKey)o;
        return this.partition == that.partition && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition);
    }
}

