#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 parameterized-utils
version:              2.1.11.0
visibility:           public
id:                   parameterized-utils-2.1.11.0-2RpJFdrtvknE8xi1QlHoHt
key:                  parameterized-utils-2.1.11.0-2RpJFdrtvknE8xi1QlHoHt
license:              BSD-3-Clause
copyright:            ©2016-2022 Galois, Inc.
maintainer:           kquick@galois.com, rscott@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  ce1d06519b5574170875e6525adb48aa
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All Data.Parameterized.Axiom
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.Fin
    Data.Parameterized.FinMap Data.Parameterized.FinMap.Safe
    Data.Parameterized.FinMap.Unsafe Data.Parameterized.HashTable
    Data.Parameterized.List Data.Parameterized.Map
    Data.Parameterized.NatRepr Data.Parameterized.Nonce
    Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.TraversableFC.WithIndex
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-9.6.6/site-local/parameterized-utils-2.1.11.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/parameterized-utils-2.1.11.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/parameterized-utils-2.1.11.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-parameterized-utils
hs-libraries:         HSparameterized-utils-2.1.11.0-2RpJFdrtvknE8xi1QlHoHt
depends:
    base-4.18.2.1 base-orphans-0.9.3-D89JfwacGPN6VkSICfKyNk
    constraints-0.14.2-4oXgIWlCgTD7y1AcVwITbb containers-0.6.7
    deepseq-1.4.8.1 hashable-1.4.7.0-2TMrYujL0SWBJEdw6jCOMM
    hashtables-1.4.2-GEB0lN4qC2XQKPdFyG6oL
    indexed-traversable-0.1.4-8j5HZpShpE5BqFup9Ojenr
    lens-5.3.3-J3Ejqn7P12hA3GpyJcCxW8 mtl-2.3.1
    profunctors-5.6.3-HquDyi6g2qf1EJs45qiFNa template-haskell-2.20.0.0
    text-2.0.2 th-abstraction-0.5.0.0-HAFjiAO2nGN58SdxVZCnLH
    vector-0.13.2.0-8Ien1418VpU5tGTMA2qRu7

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

