/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeVisitor;

public class LimitingChangeVisitor
implements ChangeVisitor {
    private final int maxReportedChanges;
    private final ChangeVisitor delegate;
    private int visited;

    public LimitingChangeVisitor(int maxReportedChanges, ChangeVisitor delegate) {
        this.maxReportedChanges = maxReportedChanges;
        this.delegate = delegate;
    }

    @Override
    public boolean visitChange(Change change) {
        boolean delegateResult = this.delegate.visitChange(change);
        ++this.visited;
        return delegateResult && this.visited < this.maxReportedChanges;
    }
}

