/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr;

import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.kotlin.io.vavr.Value;
import org.jetbrains.kotlin.io.vavr.collection.Traversable;

interface ValueModule {
    public static <T, R extends Traversable<T>> R toTraversable(Value<T> value2, R empty, Function<T, R> ofElement, Function<Iterable<T>, R> ofAll) {
        if (value2.isEmpty()) {
            return empty;
        }
        if (value2.isSingleValued()) {
            return (R)((Traversable)ofElement.apply(value2.get()));
        }
        return (R)((Traversable)ofAll.apply(value2));
    }

    public static <T, R extends Collection<T>> R toJavaCollection(Value<T> value2, Function<Integer, R> containerSupplier) {
        return ValueModule.toJavaCollection(value2, containerSupplier, 16);
    }

    public static <T, R extends Collection<T>> R toJavaCollection(Value<T> value2, Function<Integer, R> containerSupplier, int defaultInitialCapacity) {
        int size = value2 instanceof Traversable && ((Traversable)value2).isTraversableAgain() && !value2.isLazy() ? ((Traversable)value2).size() : defaultInitialCapacity;
        Collection container = (Collection)containerSupplier.apply(size);
        value2.forEach(container::add);
        return (R)container;
    }
}

