/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.AbstractModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCacheEntry;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class InMemoryModuleVersionsCache
extends AbstractModuleVersionsCache {
    private final Map<ModuleAtRepositoryKey, ModuleVersionsCacheEntry> inMemoryCache = new ConcurrentHashMap<ModuleAtRepositoryKey, ModuleVersionsCacheEntry>();
    private final AbstractModuleVersionsCache delegate;

    public InMemoryModuleVersionsCache(BuildCommencedTimeProvider timeProvider) {
        super(timeProvider);
        this.delegate = null;
    }

    public InMemoryModuleVersionsCache(BuildCommencedTimeProvider timeProvider, AbstractModuleVersionsCache delegate) {
        super(timeProvider);
        this.delegate = delegate;
    }

    @Override
    protected void store(ModuleAtRepositoryKey key, ModuleVersionsCacheEntry entry) {
        this.inMemoryCache.put(key, entry);
        if (this.delegate != null) {
            this.delegate.store(key, entry);
        }
    }

    @Override
    protected ModuleVersionsCacheEntry get(ModuleAtRepositoryKey key) {
        ModuleVersionsCacheEntry entry = this.inMemoryCache.get(key);
        if (entry == null && this.delegate != null && (entry = this.delegate.get(key)) != null) {
            this.inMemoryCache.put(key, entry);
        }
        return entry;
    }
}

