# Version history of the RCWA package

## Changes between RCWA 4.7.1 and RCWA 4.8.0 (September 22, 2025):

  - Fixed an error in the database of products of 2 class transpositions
    which has been found by a recomputation of the data (the order of
    (9(10),0(12)) * (1(11),10(11)) is not 12, but 60).
  - Added a function CTPairIntersectionTypeNumber to the database of
    products of two class transpositions
  - Fixed representation issue in ImagesSet(f,cl): if both inputs
    are sparse, then output now is as well
  - Added preliminary support for operations `PreImagesNC`,
    `PreImagesElmNC`, `PreImagesSetNC`, `PreImagesRepresentativeNC`
    (for now they are just synonyms to their non-NC counterparts,
    but future GAP versions may change that)
  - Avoid use of `InstallValue` on non-plain objects in preparation
    for some future GAP version possibly dropping support for this.

## Changes between RCWA 4.7.0 and RCWA 4.7.1 (December 6, 2022):

  - Added a global switch `CTSparse` to choose sparse representation
    for class transpositions of Z.
  - Some janitorial changes

## Changes between RCWA 4.6.4 and RCWA 4.7.0 (July 29, 2022):

 - An operation `TryToComputeDegreeOfTransitivity` has been added,
   together with a method for rcwa groups over Z.
   (Not documented so far.)
 - An operation `SupersetOfOrbitRepresentatives` has been added,
   together with a method for subgroups of CT(Z).
 - An operation `ResidueClassCyclesThroughResidueClass` has been added,
   together with a method for rcwa permutations of Z.
 - An operation `DrawResidueClassCyclesThroughResidueClassPicture`
   has been added, together with a method for rcwa permutations of Z.
   (Not documented so far.)
 - Components `growthsequences`, `abelian`, `metabelian`, `solvable`,
   `abelianinvariants` and `compositionfactors` have been added to
   the database of groups generated by 3 class transpositions
   interchanging residue classes with moduli <= 6.
 - Other minor adjustments.

## Changes between RCWA 4.6.3 and RCWA 4.6.4 (March 24, 2019):

 - Clarified that this package is licensed under GPL 2 or later.
 - Moved package homepage to <https://gap-packages.github.io/rcwa>.
 - Fixed some issues where loading ResClasses could inadvertently alter
   the behavior of GAP library functions.
 - Increased minimal required resclasses version to 4.7.2.
 - Improved compatibility with future GAP releases (4.11 and later).
 - Other minor adjustments.

## Changes between RCWA 4.6.2 and RCWA 4.6.3 (November 27, 2018):

 - An operation `CTCSCRSplit` has been added.

## Changes between RCWA 4.6.1 and RCWA 4.6.2 (June 26, 2018):

 - First release after migrating the source code repository to GitHub.
 - Updated the method for Embeddings to fix the compatibility problem
   with LOOPS package.

## Changes between RCWA 4.6.0 and RCWA 4.6.1 (December 18, 2017):

 - The author's email address has been updated.

## Changes between RCWA 4.5.1 and RCWA 4.6.0 (December 5, 2017):

 - Determining transitivity and computing transitivity certificates has been
   made more efficient in some cases, and an operation `SimplifiedCertificate`
   has been added.

 - An operation `EpimorphismsUpToAutomorphisms` has been added, together with
   a method which computes all epimorphisms from a given finitely presented group
   to a given finite group up to automorphisms of the latter.

 - Lists 'redundant_generator', 'spheresizebound_4', 'spheresizebound_6',
   'spheresizebound_12' and 'spheresizebound_24' have been added to the database
   of groups generated by 3 class transpositions.

 - Single-argument methods for `TransitionMatrix` and `TransitionGraph` have
   been added.

## Changes between RCWA 4.5.0 and RCWA 4.5.1 (March 13, 2017):

 - RCWA now prints a warning if GAP is run in legacy 32-bit mode.
   The reason is the limitation on the size of integers in ranges in 32-bit GAP
   which may make some computations fail and trigger error messages.

## Changes between RCWA 4.4.1 and RCWA 4.5.0 (February 12, 2017):

 - A further method for `EpimorphismFromFpGroup` has been added.
   This method allows to limit the search space to elements with not more than
   a given number of affine parts. 

 - Attributes `DecompositionIntoPermutationalAndOrderPreservingElement`
   and `SignInOddCTPZ` have been added.

 - The following components have been added to the database of groups generated by
   3 class transpositions: 'minwordlengthnonbalanced', 'minwordlengthcoprimemultdiv',
   'epifromfpgrouptocollatzgroup_c' and 'epifromfpgrouptocollatzgroup_t'.

 - The method for `RestrictedBall` for computing restricted balls in rcwa monoids
   does now interpret options "boundaffineparts" and "boundnonidentityaffineparts".
   -- If set, the specified bound is on the number of affine parts, respectively,
   on the number of affine parts distinct from the identity, rather than on the
   modulus of the mapping.

 - An operation `HashValueOfRcwaMapping` has been added.
   The purpose of the hash values is to allow faster searching of rcwa mappings
   by algorithms.

 - Now the operations `Support`, `IncreasingOn`, `DecreasingOn`, `ShiftsUpOn`,
   `ShiftsDownOn`, `LargestSourcesOfAffineMappings` and `Multpk` return their
   result in sparse representation if the argument is in sparse representation.

 - An operation `RefinementSequence` has been added.

## Changes between RCWA 4.4.0 and RCWA 4.4.1 (May 22, 2016):

 - A `Random` method for finitely generated rcwa groups and given word length
   has been added.

 - A bug in the default method for `RespectedPartition` for subgroups of CT(Z)
   has been fixed. This bug caused wrong results in very rare cases.

## Changes between RCWA 4.3.1 and RCWA 4.4.0 (May 14, 2016):

 - Many newly found subgroup relations have been added to the database
   of groups generated by 3 class transpositions which interchange residue
   classes with moduli <= 6.

 - A new method for computing the order of an element of CT(Z) has been added.
   Its use can be triggered by setting the option "new_order" when calling the
   operation `Order`. This method is sometimes faster and sometimes slower
   than the default method.

 - The function `PrimeSwitch` has been turned into an operation, and new
   methods PrimeSwitch(p,r,m) and PrimeSwitch(p,cl) to construct "residue
   class specific" prime switches have been added.

 - The functions for loading the databases of rcwa groups and -mappings do
   no longer return the content of the respective database itself, but just
   the name of the variable which the database record is assigned to.
   Hence forgetting the ';;' at the end of the line when loading one of the
   databases does no longer result in megabytes of data printed to the screen.

 - Selector functions `All3CTs9Groups` and `All3CTs9Indices` have been added
   to the database of groups generated by 3 class transpositions interchanging
   residue classes with moduli <= 9.

 - The meaning of CT(P,Integers) has been changed in that 2 is no longer
   treated as a special case, and P is now the full prime set of the
   constructed group. -- That means e.g. that the former CT([],Integers) is
   now CT([2],Integers).

 - There is now a generating set for CT([2,3],Integers) consisting of only
   6 class transpositions known, instead of 14 as before.
   Also, a generating set for CT([3],Integers) has been added.

 - The performance of the function `ClassPairs` has been improved, and this
   function takes now an optional first argument P and interprets an option
   "divisors".

 - A method for `ExtRepOfObj` for class transpositions has been added.
   This method returns the 4-tuple [r1,m1,r2,m2] corresponding to the
   interchanged residue classes r1(m1) and r2(m2).

## Changes between RCWA 4.3.0 and RCWA 4.3.1 (March 9, 2016):

 - Minor adjustments.

## Changes between RCWA 4.2.0 and RCWA 4.3.0 (March 8, 2016):

 - The remaining utility functions and -operations `SaveAsBitmapPicture`,
   `LoadBitmapPicture`, `DrawGrid`, `EquivalenceClasses`, `GraphClasses`,
   `AllGraphs` and `IdGraph` have been moved to the ResClasses package.

 - Some code reordering has been done (the remaining contents of general.gd
   and general.gi have been merged into rcwamap.gd, rcwamap.gi, rcwagrp.gd
   and rcwagrp.gi, and frdepend.gi has been renamed to perlist.gi).

 - A few further minor adjustments have been made.

## Changes between RCWA 4.1.0 and RCWA 4.2.0 (March 4, 2016):

 - The utility functions and -operations `GeneratorsAndInverses`,
   `EpimorphismByGenerators`, `ListOfPowers`, `AssignGlobals`, `SearchCycle`,
   `NextProbablyPrimeInt`, `PrimeNumbersIterator`, `AllSmoothIntegers`,
   `ExponentOfPrime` and `LaTeXStringFactorsInt` have been moved to the
   Utils package. Therefore Utils is now a needed package of RCWA.

 - The automated package test covers now the full test suite, and the tests
   now use standard functionality instead of the old custom setup.

 - The function `DrawOrbitPicture` which was broken due to some other changes
   is now working again.

 - RCWA needs now the FR package, which was before only suggested.

## Changes between RCWA 4.0.1 and RCWA 4.1.0 (March 1, 2016):

 - The test suite (a.k.a. RCWATestAll();) has been amended considerably,
   in order to increase the code coverage of the tests.

 - A few minor bugs which could have led to error messages have been fixed.

## Changes between RCWA 4.0.0 and RCWA 4.0.1 (February 23, 2016):

 - The propagation of the knowledge about bijectivity to inverses of bijective
   rcwa mappings is now taken care of by RCWA. -- Until GAP 4.8.1 this was done
   by the GAP Library.

## Changes between RCWA 3.7.0 and RCWA 4.0.0 (January 25, 2016):

 - A database of groups generated by 3 class transpositions intechanging residue
   classes with moduli <= 9 has been added. For each of these 3031864 groups,
   the modulus and the order are stored. Also, for all finite ones among these
   groups, the length of the shortest respected partition is stored.

 - The following data has been added to the database of groups generated by
   3 class transpositions:
   - data on subgroup- and supergroup relations between the groups in the database
     (lists 'subgroups' and 'supergroups'),
   - data on the orbit growth functions (list 'orbitgrowthtype'),
   - lists of lengths of short finite orbits of residue classes, and
   - data on sphere size cycles for orbits with periodic growth function.
   Also the data on the action of the groups in the database on the set of
   nonnegative integers in their support has been revised and improved
   (aka `trsstatus` / `trsstatuspos`).

 - RCWA makes now use of the new sparse representation of residue class unions
   implemented in ResClasses 4.0.0.

 - A couple of methods for computing stabilizers in rcwa groups have been added.

 - A method for `DirectFactorsOfGroup` for finite subgroups of CT(Z) has been added.

 - The method for `ShortResidueClassOrbits` for rcwa groups over Z has been
   made more efficient.

 - A database of realizations of all (simple) graphs with 4, 5 and 6 vertices
   as class transposition graphs has been added.

 - An attribute `TransitivityCertificate` for subgroups of CT(Z) which act
   transitively on the set of nonnegative integers in their support,
   as well as an operation `TryToComputeTransitivityCertificate`, have been added.
   Also, the method for `IsTransitiveOnNonnegativeIntegersInSupport` has been
   improved.

 - An operation `PiecewiseMapping` to compose a mapping from pieces has been
   added, together with a method for rcwa mappings of Z.

 - An operation `GrowthFunctionOfOrbit` has been added, together with methods
   for rcwa groups.

 - An option to `Display` an rcwa mapping f of Z in the form of
   a table with a line of the form r(m) -> r(m)^f for each affine part
   has been added (option "AsClassMapping").

 - A constructor for the groups CT_P(Z) has been added.
   For P = [] (corresponds to Thompson's group V) and P = [3],
   generators are provided.

 - The operation `RestrictedBall` now interprets an option "untilsmaller".

 - Operations `DensityOfSetOfFixedPoints` and `DensityOfSupport`
   have been added.

 - The method for `CollatzLikeMappingByOrbitTree` has been improved.

 - Utility functions `AllGraphs`, `GraphClasses` and `IdGraph` have been added.

 - A utility function `PrimeNumbersIterator` has been added, which returns an
   iterator looping over the prime numbers in ascending order.

 - A utility function `ComputeCycleLength` has been added.

 - The utility functions `ShrinkMonochromePictureToGrayscalesPicture`,
   `EncryptIntoBitmapPicture`, `DecryptFromBitmapPicture` and
   `RunDemonstration` have been removed from the package, since they will
   be moved to the new Utils package.

 - The utility function `AllProducts` has been discarded.

 - The auxiliary functions `ReadTestWithTimings` and
   `ReadTestCompareRuntimes` have been moved from general.gi to rcwaaux.g,
   since given the improvements of the testing routines of 'core GAP',
   they will be hardly of general interest any more.

## Changes between RCWA 3.6.1 and RCWA 3.7.0 (July 21, 2014):

 - An operation `MergerExtension` has been added.
   This operation constructs a certain infinite extension of a given
   transitive finite permutation group.

 - The manual section "Constructing residue-class-wise affine groups"
   has been revised.

 - The function `DrawOrbitPicture` has been improved, and in particular
   been made more efficient. The meaning of one of its arguments has
   changed.

 - Functions `EncryptIntoBitmapPicture` and `DecryptFromBitmapPicture`
   for steganography in bitmap pictures have been added.

 - A function `ShrinkMonochromePictureToGrayscalesPicture` has been added.
   This function is for producing smaller greyscale pictures from large
   monochrome pictures.

 - Custom methods for \= for rcwa groups have been added.

 - The file rcwa/doc/manual.js has been added.

## Changes between RCWA 3.6.0 and RCWA 3.6.1 (November 18, 2013):

 - The manual chapter on the algorithms implemented in this package
   has been brought up-to-date.

 - The function `LoadDatabaseOfGroupsGeneratedBy4ClassTranspositions`
   has been documented.

## Changes between RCWA 3.5.1 and RCWA 3.6.0 (October 28, 2013):

 - Considerable additions to the database of groups
   generated by 3 class transpositions have been made -- for example:

   - Information on which groups are conjugate in RCWA(Z).
   - Information about short finite orbits.
   - Lengths of shortest respected partitions as well as degrees of action and
     orbit lengths on these partitions for all finite groups in the database.
   - Shortest respected partitions and generators of permutation groups
     induced on them, for all finite groups in the database.
   - Information on which groups stabilize a union of residue classes (mod m)
     for m <= 60.

 - A database of pairs of class transpositions interchanging
   residue classes with moduli <= 12 sorted by the order of their product
   has been added.

 - A database similar to the one mentioned before up to modulus 32, but
   restricted to orders 8, 24, 40, 42, 84, 120, 168 and 420 has been added.

 - There is now a considerably faster method for `RespectedPartition`
   for finite subgroups of CT(Z), giving a speedup by a factor of 1000
   or more for large groups. The method also needs much less memory.

 - A better method for `EpimorphismFromFpGroup` for rcwa groups has been added.

 - There is now an operation `Mirrored` which applies the automorphism
   conjugating with n |-> -n - 1 to an rcwa mapping of Z or an rcwa group
   over Z. This interchanges the action on negative and nonnegative integers.

 - The performance of the method for computing the order of an
   rcwa permutation of Z has been improved.

 - A basic method for `RepresentativeAction` has been added which computes
   an rcwa permutation g such that G^g = H for given conjugate rcwa groups
   G, H < RCWA(Z).

 - A bug has been fixed which caused error messages when computing with
   rcwa mappings of Z in sparse representation which were not class-wise
   order-preserving.

## Changes between RCWA 3.5.0 and RCWA 3.5.1:

 - The manual examples and the test files have been adjusted to the
   improved output format for words in GAP 4.6.0.

## Changes between RCWA 3.4.0 and RCWA 3.5.0 (December 12, 2012):

 - A sparse representation for rcwa mappings of Z has been implemented.
   This allows much faster, much less memory-consuming computations
   in case the respective rcwa mappings have only few different
   affine partial mappings.

 - There are performance improvements in various places.

## Changes between RCWA 3.3.1 and RCWA 3.4.0 (November 1, 2012):

 - The output of tame rcwa permutations has been improved.
   Now sign-preserving tame rcwa permutations of Z are often shown
   in disjoint cycle notation and residue classes moved by class
   transpositions etc. are shown as such. Also it is possible now to
   customize the output by 3 options, which can be either 'true',
   'false' or not set: CycleNotation, PrintNotation, AbridgedNotation.

 - The method to enter an rcwa mapping of Z by giving a string expression
   accepts now rcwa permutations given in disjoint residue class cycle
   notation.

 - The method for `ShortResidueClassCycles` for rcwa permutations of Z
   has been made much faster and much less memory-consuming.

 - An operation `FixedResidueClasses` has been added. This operation
   finds all residue classes with moduli up to a specified bound
   which are fixed setwise by a given rcwa mapping or -group.

 - An operation `CyclesOnFiniteOrbit` has been added. This operation
   returns a list of all cycles of an element of an rcwa group on
   a finite orbit.

 - Two sections have been added to Chapter 'Examples' of the manual:
   1. The 3n+1 group.
   2. A group with huge finite orbits.

 - The function `ClassPairs` can now compute pairs of disjoint
   residue classes of Z^2 as well.

 - A function `RCWATestExamples` has been added. This function tests
   all examples in the RCWA manual, and reports any differences between
   the actual output and the output printed in the manual. It replaces
   the former script-based utility for this purpose.

 - The directory rcwa/gap/ has been renamed to rcwa/lib/, in order to
   follow the same naming convention as for the subdirectories of the
   GAP root directory.

 - A temporary variable `property` has been removed.

 - The ordering of this list has been changed from chronological to
   reverse chronological.

## Changes between RCWA 3.2.0 and RCWA 3.3.1 (June 8, 2012):

 - The chapter "About the RCWA Package" of the manual has been rewritten.

 - The 3 functions with names `RCWALoadDatabaseOf ...` have been renamed to
   `LoadDatabaseOf ...`. Further the function `RCWALoadExamples` has been
   renamed to `LoadRCWAExamples`, while the old name is kept as a synonym.

## Changes between RCWA 3.1.2 and RCWA 3.2.0 (May 7, 2012):

 - Further data has been added to the database of groups generated
   by 3 class transpositions.

 - An operation `LaTeXStringRcwaGroup` has been added.

 - A method for the new operation `IsCommuting` for rcwa mappings has
   been added.

 - A helper function `AllSmoothIntegers` has been added.

 - Now the new function `Test` is used instead of `ReadTest` for the
   test suite.

 - In order to emphasize the permutation aspect, in output the wording
   "bijective rcwa mapping" has been changed to "rcwa permutation".

 - Now RCWA needs ResClasses 3.1.0.

## Changes between RCWA 3.1.1 and RCWA 3.1.2:

 - Prevent that tst/rcwa_ct.tst shows diff's if due to better
   methods in other packages the groups RCWA(R) and CT(R) know
   already more attributes and properties.

 - Added a README file in the otherwise empty directory tst/timings.

## Changes between RCWA 3.0.4 and RCWA 3.1.1 (October 18, 2011):

 - Operations `ShortResidueClassCycles`, `ShortResidueClassOrbits`,
   `CycleRepresentativesAndLengths`,
   `IsTransitiveOnNonnegativeIntegersInSupport`, `CheckForWildness`
   and `TryIsTransitiveOnNonnegativeIntegersInSupport` have been added.

 - The methods for `Modulus` and `RespectedPartition` for rcwa groups
   have been improved, and helper functions
   `CommonRefinementOfPartitionsOfZ_NC` and
   `CommonRefinementOfPartitionsOfR_NC` have been added.

 - A database of groups generated by 3 class transpositions which
   interchange residue classes with moduli <= 6 has been added.

 - The database on products of class transpositions has been extended.

 - The output format for rcwa mappings used by `Display` is now
   much nicer.

 - The documentation has been improved in various places.

 - A run of the test suite now indicates changed run times of
   individual commands in comparison with a reference run.

 - The file gap/general.g has been split into gap/general.gd and
   gap/general.gi, in order to allow other packages to use the
   declarations before RCWA's implementation part is loaded.

 - A utility function `LaTeXStringFactorsInt` has been added.

 - The following functions have been renamed:
   `RCWAReadExamples`      -> `RCWALoadExamples`
   `RcwaMappingToLaTeX`    -> `LaTeXStringRcwaMapping`
   `ReadFromBitmapPicture` -> `LoadBitmapPicture`

 - Now RCWA needs GAP 4.5.2, ResClasses 3.0.2 and GAPDoc 1.4.

## Changes between RCWA 3.0.3 and RCWA 3.0.4:

 - Renamed undocumented variables:
     - `IsOrbit` -> `IsRcwaGroupOrbit`
     - `IsOrbitStandardRep` -> `IsRcwaGroupOrbitStandardRep`
     - `IsOrbitsIteratorRep` -> `IsRcwaGroupOrbitsIteratorRep`
     - `IsOrbitInStandardRep` -> `IsRcwaGroupOrbitInStandardRep`.
   Reason: name collision with orb package, and potential for
   further name collisions; expected benefit from synergies
   with other code for dealing with orbits is small.

## Changes between RCWA 3.0.2 and RCWA 3.0.3:

 - The CVS revision entries have been removed from the source files.

 - The PDF version of the manual contains now bookmarks for chapters,
   sections and subsections. -- This is due to improved functionality
   of the most recent version of the GAPDoc package.

## Changes between RCWA 3.0.1 and RCWA 3.0.2:

 - Renamed the operation `Projections` for rcwa mappings of Z^2 to
   `ProjectionsToCoordinates` and turned it into an attribute.

 - Renamed the operation `Projections` for rcwa group and modulus to
   `ProjectionsToInvariantUnionsOfResidueClasses`.

## Changes between RCWA 3.0.0 and RCWA 3.0.1:

 - Instead of `RCWATest` there are now two different test functions:
   `RCWATestInstall` for briefly checking whether a installation
   went well, and `RCWATestAll` for running the full test suite.
   The function `RCWATestAll` corresponds to the former `RCWATest`.

## Changes between RCWA 2.5.4 and RCWA 3.0.0 (May 8, 2011):

The main changes are:

 - Now the RCWA package provides basic functionality for computing in
   rcwa groups over Z^2.

 - Many examples have been added -- to the manual as well as
   to the files in the examples/ subdirectory.

Further changes are:

 - A function `GroupByResidueClasses` has been added.

 - A method for `ResidueClass` has been added which accepts an expression
   involving class transpositions, class shifts, class reflections,
   operators like *, /, ^ and brackets. The expression is to be provided
   as a string.

 - A function `DrawGrid` to draw pictures of residue class unions of Z^2
   has been added.

 - A property `IsClassWiseTranslating` and an attribute `MaximalShift`
   have been introduced.

 - `Trajectory` now recognizes the option "Action"; default is `OnPoints`.

 - The amount of memory needed to store rcwa mappings with only few different
   coefficient triples has been reduced by making equal triples identical.

 - A `sparse` multiplication method for rcwa mappings has been added.

 - `LargestSourcesOfAffineMappings` has been made more efficient.

 - Now, class transpositions, class shifts, class rotations and
   class reflections have no longer predefined names, and the nice
   `View`ing is cared for by separate methods.

 - Now the RCWA package needs GAP 4.4.12, ResClasses 3.0.0 (which supports
   unions of residue classes of Z^2), GAPDoc 1.3 and Polycyclic 2.6.

## Changes between RCWA 2.5.3 and RCWA 2.5.4 (September 26, 2007):

 - A function `RunDemonstration` has been added.
   The purpose of this function is to present demonstrations of this package
   and possibly also of other GAP code.

 - The line length used in the examples has been reduced to 75 in order to
   improve their appearance in the online help with standard settings.

## Changes between RCWA 2.5.2 and RCWA 2.5.3:

 - A bug concerning SymmetricGroup([]) has been fixed -- the empty list
   was wrongly interpreted as empty list of residue classes, rather than
   as empty list of integers. This caused an error message.
   Thanks to John McDermott for reporting this bug.

## Changes between RCWA 2.5.1 and RCWA 2.5.2:

 - The action of subgroups of CT(Z) on FR's periodic lists by permuting the
   list entries has been implemented. An analogous action has been imple-
   mented for non-bijective rcwa mappings.

 - A method for `EquivalenceClasses` has been added.
   The arguments are either a list and a function computing a class invariant
   of a list entry or a list and a function describing an equivalence
   relation on the entries of the list.

 - A function `RestrictedPartitionsWithoutRepetitions` has been added.
   This is similar to `RestrictedPartitions`, but the difference is that
   no part may occur twice.

 - The documentation has been improved in a few places, and a couple of
   comments in the source files have been improved as well.

## Changes between RCWA 2.5.0 and RCWA 2.5.1:

 - Some minor adjustments have been made, and RCWA needs now the recently
   released version 1.0 of GAPDoc and version 2.5.1 of ResClasses.

## Changes between RCWA 2.4.3 and RCWA 2.5.0 (May 25, 2007):

 - Some functionality for rcwa monoids has been added --
   see the short new manual chapter "Residue-Class-Wise Affine Monoids".

 - The manual has undergone a revision.
   Nothing has been rewritten completely, but lots of improvements and
   updates have been made in many places, and the chapter "The Algorithms
   Implemented in RCWA" has been extended considerably.

 - Iterators for rcwa groups have been implemented.
   These iterators can be used for finitely generated infinite groups
   in general.

 - The functionality for orbits under the action of rcwa groups has been
   improved. There are now orbit objects representing possibly infinite
   orbits. There are methods to compare such orbits, and to loop over them.

 - An operation `EpimorphismFromFpGroup` has been introduced.

 - A `SymmetricGroup` method for partitions of a ring into residue classes
   has been added.

 - The `IsomorphismRcwaGroup` method for finite groups has been improved.
   It works now over all rings which are currently supported by RCWA.

 - An `Exponent` method for rcwa groups has been added.

 - Methods for `Action` and `ActionHomomorphism` to compute the action of
   an rcwa group on a subset of its underlying ring have been added.

 - Basic functionality for subgroups of rcwa groups "by property" has
   been implemented.

 - A method to construct a dihedral group acting on a given residue class
   has been added.

 - Methods for `ExtRepOfObj` and `ObjByExtRep` for rcwa mappings have
   been added.

 - Attributes `ShiftsUpOn` and `ShiftsDownOn` as well as a property
   `IsSignPreserving` have been introduced.

 - Class shifts, class reflections, class rotations and class transpositions
   can now be given user-defined names via an option `Name`.

 - The methods for `PreImagesElm`, `PreImagesRepresentative` and
   `PreImagesSet` have been generalized to rcwa mappings of rings other
   than Z.

 - "Generalized class transpositions" have been introduced.
   The difference between them and "usual" class transpositions is that
   the former interchange given pairs of disjoint residue classes *with
   fixed representatives and signed moduli*.

 - The operation `RcwaGroupByPermGroup` / `RcwaGroupOverZByPermGroup` is
   no longer needed, and has been removed.

 - The Attributes `SetOnWhichMappingIs ...` have been given shorter names.
   Now they are called `ClassWiseOrderPreservingOn`, `ClassWiseConstantOn`
   and `ClassWiseOrderReversingOn`.

 - The bibliography format has been changed from BibTeX to GAPDoc XML.

 - Now RCWA needs ResClasses 2.5.0 and GAPDoc 0.99999.

## Changes between RCWA 2.4.2 and RCWA 2.4.3:

 - The documentation has been improved in a few places.

 - The HTML version of the manual has been made a bit nicer by adding
   a couple of images for displayed formulae.

 - A few formulae in ASCII art have been added to the text version of
   the manual.

 - A quirk with the style file for the HTML version of the manual has
   been fixed.

## Changes between RCWA 2.4.1 and RCWA 2.4.2:

 - A method IsomorphismRcwaGroup( <G>, <R> ) for the case that <R> is
   a (semi-) localization of Z has been added.

 - The `Order` method for rcwa permutations of polynomial rings GF(q)[x]
   has been improved.

 - The membership test for rcwa groups over polynomial rings GF(q)[x]
   has been improved. This also includes improved or new methods for
   a couple of related operations.

## Changes between RCWA 2.4.0 and RCWA 2.4.1:

 - Some improvements of the documentation have been made.

## Changes between RCWA 2.3.3 and RCWA 2.4.0 (February 20, 2007):

 - The groups CT(R) are now available as GAP objects.

 - More methods for `RepresentativeAction` have been added:

     - For RCWA(GF(q)[x]) resp. RCWA(Z_(pi)) and two partitions
       of GF(q)[x] resp. Z_(pi) into residue classes.

     - For RCWA(GF(q)[x]) resp. RCWA(Z_(pi)) and two unions of
       residue classes of GF(q)[x] resp. Z_(pi).

 - An operation `ClassRotation` has been introduced.

 - A method for `Permuted` for a list of residue classes and an
   rcwa permutation has been added.

 - A major "cleanup" of the source files has taken place: Many comments have
   been improved, and the declarations / implementations have been rearranged
   and grouped together by "topic".

 - The documentation has been improved in a few places.

 - Now RCWA needs ResClasses 2.4.0, which provides improved support for
   unions of residue classes of rings Z_(pi) and GF(q)[x].

## Changes between RCWA 2.3.2 and RCWA 2.3.3:

 - Now there is a new preprint on algorithms and methods for rcwa groups,
   in which many of the algorithms and methods implemented in this package
   are described in detail. A reference to this preprint has been added
   to the manual.

 - A couple of minor improvements of the code and the documentation have
   been made. For example, the method for computing the order of a bijective
   rcwa mapping has been improved, and the number of stored generators of
   wreath products of rcwa groups with finite permutation groups has been
   reduced.

 - There is now a two-argument version of the function `ClassPairs`, which
   supports the rings Z_pi and GF(q)[x] as well. The ring has to be given as
   the first argument.

## Changes between RCWA 2.3.1 and RCWA 2.3.2:

 - A copy of my thesis is distributed with the package again
   (somebody had asked for it).

## Changes between RCWA 2.3.0 and RCWA 2.3.1:

 - A graphics function `ReadFromBitmapPicture` has been added.

 - The code of the function `SaveAsBitmapPicture` has been improved,
   and the requirement that the width of a bitmap picture must be a multiple
   of 32 has been removed.

 - A test file tst/bmptest.g for RCWA's graphics functionality has been
   added.

## Changes between RCWA 2.2.2 and RCWA 2.3.0 (November 30, 2006):

 - Graphics functions `SaveAsBitmapPicture` and `DrawOrbitPicture`
   have been added.

 - A `DirectProductOp` method has been moved to Polycyclic.
   Therefore RCWA now requires Polycyclic 2.1.

 - A couple of minor improvements in the code and in the documentation
   have been made.

## Changes between RCWA 2.2.1 and RCWA 2.2.2:

 - The implementation of the methods for checking some wildness criteria
   has been improved.

 - The documentation has been improved in some places.

 - A little "spelling reform" has taken place -- the longer the author looks
   at it, the more he is convinced that "residue-class-wise affine" looks
   better than "residue class-wise affine".

## Changes between RCWA 2.2.0 and RCWA 2.2.1:

 - Some minor code and documentation improvements have been made.
   Now RCWA needs ResClasses 2.3.5.

## Changes between RCWA 2.1.7 and RCWA 2.2.0 (September 20, 2006):

 - Improvements of the documentation have been made:
   In particular the abstract, the preface and the readme file have been
   updated, improved and shortened.

 - The author's thesis is no longer distributed with the package, since more
   and better results on residue-class-wise affine groups have been found in
   the meantime.

## Changes between RCWA 2.1.6 and RCWA 2.1.7:

 - A function `GluckTaylorInvariant` has been added.

 - A bug in `KernelOfActionOnRespectedPartition` has been fixed.

## Changes between RCWA 2.1.5 and RCWA 2.1.6:

 - A bug in the application of a non-membership criterion for rcwa groups
   has been fixed (the error has been identified in the code, no example
   has been constructed).

 - Some cleanup of comments and declarations in the source code
   has been made.

## Changes between RCWA 2.1.4 and RCWA 2.1.5:

 - The abstract and the preface of the manual have been revised.

## Changes between RCWA 2.1.3 and RCWA 2.1.4:

 - Some information in the chapter `The Algorithms Implemented in RCWA`
   of the manual has been updated.

 - A method for computing conjugates of GAP permutations under bijective
   rcwa mappings has been added.

## Changes between RCWA 2.1.2 and RCWA 2.1.3:

 - Some additional criteria for disproving membership of a given
   rcwa permutation in a given rcwa group are now tested.

 - The output string of `StructureDescription` is now a bit nicer
   in certain cases.

## Changes between RCWA 2.1.1 and RCWA 2.1.2:

 - A method for the operation `Index` for rcwa groups has been added.

 - A method for computing factor groups G/N of rcwa groups has been
   added. This method covers the case that the normal subgroup N has
   finite index in G.

 - A few internal code improvements have been made.

## Changes between RCWA 2.1.0 and RCWA 2.1.1:

 - Some improvements to `StructureDescription` and to the membership test
   have been made.

## Changes between RCWA 2.0.2 and RCWA 2.1.0 (June 6, 2006):

 - A method for `StructureDescription` with basic functionality has been
   added.

## Changes between RCWA 2.0.0 and RCWA 2.0.2:

 - Operations `Projections` and `RespectsPartition` have been introduced.

## Changes between RCWA 1.8.0 and RCWA 2.0.0 (May 30, 2006):

The main change is that the manual has been revised.

Further changes:

 - `ClassTransposition`, `ClassShift` and `ClassReflection` now work
   also over rings other than Z.

 - Methods for `Multiplier` and `Divisor` for rcwa groups have been added.

 - Some further minor extensions of the functionality have been made,
   e.g. there is now a method for `ShortCycles` analogous to `ShortOrbits`,
   and a function `InjectiveAsMappingFrom` has been added.

 - The code has been improved in various places.

## Changes between RCWA 1.7.2 and RCWA 1.8.0 (May 18, 2006):

 - The method for the operation `KernelOfActionOnRespectedPartition` works
   now also for tame rcwa groups which are not class-wise order-preserving,
   and has been documented. RCWA needs now the package Polycyclic.

 - An operation `SplittedClassTransposition` has been introduced, and the
   function `ClassPairs` has been documented.

 - The documentation has been improved in some places, and a couple of
   general auxiliary functions have been documented.

 - An example "embeddings of graphs with 4 vertices in the class
   transposition graph" has been added to examples/examples.g.

 - Various little "internal" improvements have been made.

## Changes between RCWA 1.7.1 and RCWA 1.7.2:

 - The length of the used respected partitions of tame rcwa mappings
   and -groups has been reduced.

## Changes between RCWA 1.7.0 and RCWA 1.7.1:

 - The method for `Root` has been improved.
   The modulus of the result is now often significantly smaller.

 - Some minor improvements of code and documentation have been made.

## Changes between RCWA 1.6.2 and RCWA 1.7.0 (April 28, 2006):

 - A method for `Root` which extracts k-th roots of class-wise
   order-preserving rcwa mappings of finite order has been added.

 - Methods for `RepresentativeAction` for RCWA(Z) and two integers
   and for RCWA(Z) and two tuples of integers have been added.

 - The functions `Trajectory`, `TrajectoryModulo` and
   `CoefficientsOnTrajectory` have been merged into an operation
   `Trajectory`.

 - The functions `IncreasingOn` and `DecreasingOn` have been turned
   into attributes.

 - The function `TransitionMatrix` has been turned into an operation.

 - Some cleanup "behind the scenes" has been made. In particular some code
   has been improved or simplified, and a number of undocumented global
   variables have been made local.

## Changes between RCWA 1.6.0 and RCWA 1.6.2:

 - A method for `IsomorphismRcwaGroup` for free products of finite groups
   has been added.

 - Methods for `CyclicGroup`, `DihedralGroup` and `AbelianGroup` have been
   added.

## Changes between RCWA 1.5.2 and RCWA 1.6.0 (April 18, 2006):

 - Two Methods for `WreathProduct` have been added:

     * for an rcwa group over Z and a finite permutation group, and
     * for an rcwa group over Z and an infinite cyclic group.

 - An `IsomorphismRcwaGroup` method for free groups has been added.

 - Properties `IsClassShift`, `IsClassReflection`, `IsClassTransposition`
   and `IsPrimeSwitch` have been introduced.

 - An attribute `TransposedClasses` for class transpositions has been
   introduced.

## Changes between RCWA 1.5.1 and RCWA 1.5.2:

 - An example "Representations of the free group of rank 2" has been added
   to the manual. This example shows a transfer of the construction of the
   Schottky groups from PSL(2,C) to RCWA(Z).

 - An example "A representation of the modular group PSL(2,Z)" has been
   added to the manual.

 - A bug in the `Size` method for tame rcwa groups which are not class-wise
   order-preserving has been fixed. In certain situations this bug falsely
   caused the method to return `infinity`.

## Changes between RCWA 1.4.4 and RCWA 1.5.1 (March 29, 2006):

 - Attributes `Sources`, `Sinks` and `Loops` have been introduced.

 - A larger number of method descriptions has been made more intuitive.

 - The names of some filters have been changed in order to make the naming
   scheme more consistent and more intuitive. These are:

   `IsIntegralRcwaMapping`          -> `IsRcwaMappingOfZ`
   `IsSemilocalIntegralRcwaMapping` -> `IsRcwaMappingOfZ_pi`
   `IsModularRcwaMapping`           -> `IsRcwaMappingOfGFqx`

   `IsIntegralRcwaGroup`            -> `IsRcwaGroupOverZ`
   `IsSemilocalIntegralRcwaGroup`   -> `IsRcwaGroupOverZ_pi`
   `IsModularRcwaGroup`             -> `IsRcwaGroupOverGFqx`

 - Some minor adjustments to output formatting improvements in
   ResClasses 2.2.2 have been made. RCWA requires now ResClasses 2.2.2.

## Changes between RCWA 1.4.2 and RCWA 1.4.4:

 - An attribute `FixedPointsOfAffinePartialMappings` has been introduced.

 - Functions `LocalizedRcwaMapping` and `SemilocalizedRcwaMapping` have been
   added.

 - A function `mKnot` has been added. This function constructs bijective
   rcwa mappings of the type discussed in

   Timothy P. Keller. Finite Cycles of Certain Periodically Linear
   Permutations. Missouri J. Math. Sci. 11(1999), no. 3, 152-157.

## Changes between RCWA 1.4.1 and RCWA 1.4.2:

 - Functions `ConjugatingCTs` and `TreeSortingPerm` have been added to
   the examples file (rcwa/examples/examples.g):

   `ConjugatingCTs` is a function which, given two class transpositions
                    ct1 and ct2, returns a 6-tuple of class transpositions
                    ct3 .. ct8 such that ct1^(ct3 * .. * ct8) = ct2.
                    The existence of such a tuple of class transpositions
                    is used in the proof that the group generated by all
                    class transpositions is simple.

   `TreeSortingPerm` is a mapping which is a permutation of the positive
                     integers if and only if the 3n+1 Conjecture holds.

 - A couple of minor / technical changes have been made, e.g. some newly
   introduced features of ResClasses are now used. RCWA requires now
   ResClasses 2.2.1.

## Changes between RCWA 1.4.0 and RCWA 1.4.1:

 - The attribute `FactorizationIntoGenerators` has been renamed to
   `FactorizationIntoCSCRCT`, and the method for computing such
   factorizations has been installed as a method for `Factorization`.
   The old name remains available as a synonym.

 - The mappings used in a preprint `Symmetrizing the 3n+1 Tree` and a few
   related examples have been added to examples/examples.g.

 - An example `Forward orbits of a monoid with two generators` has been
   added to the manual. In this example, it is checked by means of
   computation that the forward orbit of any positive integer under the
   action of the monoid generated by the two mappings
   T5+/-: n -> (n/2 if n even, (5n+/-1)/2 if n odd) contains 1.

## Changes between RCWA 1.3.6 and RCWA 1.4.0 (January 27, 2006):

 - Significant parts of the documentation have been rewritten.

 - A synonym `Support` for `MovedPoints`, a generic method
   for `NrMovedPoints` and an operation `Ball` have been added.

## Changes between RCWA 1.3.5 and RCWA 1.3.6:

 - A bug in `FactorizationIntoGenerators` which caused an infinite loop under
   certain circumstances has been fixed.

 - The shortening of the respected partition in the last factoring step in
   `FactorizationIntoGenerators` has been made much faster.

 - A special method for `RepresentativeActionOp` has been added.

 - A new test file tst/Ngens.tst has been added (corresponds to a preprint
   on minimal normal subgroups of RCWA(Z)).

## Changes between RCWA 1.3.4 and RCWA 1.3.5:

 - The package documentation has been made autoloaded.

## Changes between RCWA 1.3.1 and RCWA 1.3.4:

 - The errata known on 29/12/2005 have been corrected in the copy of the
   thesis distributed with this package.

 - A bunch of typo's in the English translation of the thesis has been
   corrected.

## Changes between RCWA 1.3.0 and RCWA 1.3.1:

 - A list of a few (harmless!) errata for the author's thesis has been added.

## Changes between RCWA 1.2.2 and RCWA 1.3.0 (November 22, 2005):

 - Operations `Induction`, `RightInverse` and `CommonRightInverse`
   have been added.

 - The code for `Restriction` has been improved.

 - RepresentativeAction(RCWA(Integers),P1,P2) works now also in cases
   where P1 and P2 do not consist entirely of single residue classes,
   but of unions of residue classes.

 - The multiplication of rcwa mappings is now slightly faster due to making
   use of a better bound for the modulus of the product.

 - The archive file now includes a copy of the author's thesis
   "Restklassenweise affine Gruppen" as well as an English translation of it.

## Changes between RCWA 1.2.1 and RCWA 1.2.2:

 - Some code which was misplaced in RCWA has been moved to the GAP library
   (rudimentary support for floats, `PadicValuation`,
   `EpimorphismFromFreeGroup`).

 - An example has been added to the manual in which finite quotients of
   Grigorchuk groups are constructed.

## Changes between RCWA 1.2.0 and RCWA 1.2.1:

 - An adaptation to an incompatible change in GAP 4.4.6 w.r.t. `InstallValue`
   for families has been made.

## Changes between RCWA 1.1.0 and RCWA 1.2.0 (August 8, 2005):

 - An example "A group which acts 3-transitively, but not 4-transitively on Z"
   has been added to the manual. In this example, the 3-transitivity and
   non-4-transitivity of the action of a given wild rcwa group on Z is
   checked computationally.

 - The example which has been added in the previous version has been extended
   -- now it is checked that the given group acts even 4-transitively on the
   positive integers.

 - A `RepresentativeAction` method for RCWA(Z) and two unions of residue
   classes has been added.

## Changes between RCWA 1.0.3 and RCWA 1.1.0 (June 16, 2005):

 - The `Display` - method for rcwa mappings over the integers now recognizes
   an option `xdvi`. If this option is set, a LaTeX representation of the
   rcwa mapping is written to a file, LaTeX'ed and shown with xdvi.
   Try e.g. Display(Random(RCWA(Integers)):xdvi);.

 - An example "A group which acts 2-transitively on the positive integers"
   has been added to the manual. In this example, the 2-transitivity of
   a given wild rcwa group is checked computationally.

## Changes between RCWA 1.0.2 and RCWA 1.0.3:

 - `View` - methods for certain group rings of rcwa groups and their elements
   have been added (compact form to save space; not documented yet).

## Changes between RCWA 1.0.0 and RCWA 1.0.2:

 - Several cosmetic improvements have been made; no new functionality
   has been added.

## Release of RCWA 1.0.0: April 26, 2005

