﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/TextAreaControlDisplayOptions.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>A control to display a text box that is used to enter multiple
 * entries.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/FilterTextAreaControl">AWS
 * API Reference</a></p>
 */
class FilterTextAreaControl {
 public:
  AWS_QUICKSIGHT_API FilterTextAreaControl() = default;
  AWS_QUICKSIGHT_API FilterTextAreaControl(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API FilterTextAreaControl& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the <code>FilterTextAreaControl</code>.</p>
   */
  inline const Aws::String& GetFilterControlId() const { return m_filterControlId; }
  inline bool FilterControlIdHasBeenSet() const { return m_filterControlIdHasBeenSet; }
  template <typename FilterControlIdT = Aws::String>
  void SetFilterControlId(FilterControlIdT&& value) {
    m_filterControlIdHasBeenSet = true;
    m_filterControlId = std::forward<FilterControlIdT>(value);
  }
  template <typename FilterControlIdT = Aws::String>
  FilterTextAreaControl& WithFilterControlId(FilterControlIdT&& value) {
    SetFilterControlId(std::forward<FilterControlIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The title of the <code>FilterTextAreaControl</code>.</p>
   */
  inline const Aws::String& GetTitle() const { return m_title; }
  inline bool TitleHasBeenSet() const { return m_titleHasBeenSet; }
  template <typename TitleT = Aws::String>
  void SetTitle(TitleT&& value) {
    m_titleHasBeenSet = true;
    m_title = std::forward<TitleT>(value);
  }
  template <typename TitleT = Aws::String>
  FilterTextAreaControl& WithTitle(TitleT&& value) {
    SetTitle(std::forward<TitleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source filter ID of the <code>FilterTextAreaControl</code>.</p>
   */
  inline const Aws::String& GetSourceFilterId() const { return m_sourceFilterId; }
  inline bool SourceFilterIdHasBeenSet() const { return m_sourceFilterIdHasBeenSet; }
  template <typename SourceFilterIdT = Aws::String>
  void SetSourceFilterId(SourceFilterIdT&& value) {
    m_sourceFilterIdHasBeenSet = true;
    m_sourceFilterId = std::forward<SourceFilterIdT>(value);
  }
  template <typename SourceFilterIdT = Aws::String>
  FilterTextAreaControl& WithSourceFilterId(SourceFilterIdT&& value) {
    SetSourceFilterId(std::forward<SourceFilterIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The delimiter that is used to separate the lines in text.</p>
   */
  inline const Aws::String& GetDelimiter() const { return m_delimiter; }
  inline bool DelimiterHasBeenSet() const { return m_delimiterHasBeenSet; }
  template <typename DelimiterT = Aws::String>
  void SetDelimiter(DelimiterT&& value) {
    m_delimiterHasBeenSet = true;
    m_delimiter = std::forward<DelimiterT>(value);
  }
  template <typename DelimiterT = Aws::String>
  FilterTextAreaControl& WithDelimiter(DelimiterT&& value) {
    SetDelimiter(std::forward<DelimiterT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The display options of a control.</p>
   */
  inline const TextAreaControlDisplayOptions& GetDisplayOptions() const { return m_displayOptions; }
  inline bool DisplayOptionsHasBeenSet() const { return m_displayOptionsHasBeenSet; }
  template <typename DisplayOptionsT = TextAreaControlDisplayOptions>
  void SetDisplayOptions(DisplayOptionsT&& value) {
    m_displayOptionsHasBeenSet = true;
    m_displayOptions = std::forward<DisplayOptionsT>(value);
  }
  template <typename DisplayOptionsT = TextAreaControlDisplayOptions>
  FilterTextAreaControl& WithDisplayOptions(DisplayOptionsT&& value) {
    SetDisplayOptions(std::forward<DisplayOptionsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_filterControlId;

  Aws::String m_title;

  Aws::String m_sourceFilterId;

  Aws::String m_delimiter;

  TextAreaControlDisplayOptions m_displayOptions;
  bool m_filterControlIdHasBeenSet = false;
  bool m_titleHasBeenSet = false;
  bool m_sourceFilterIdHasBeenSet = false;
  bool m_delimiterHasBeenSet = false;
  bool m_displayOptionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
