﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/ContainerServiceLogEvent.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {
class GetContainerLogResult {
 public:
  AWS_LIGHTSAIL_API GetContainerLogResult() = default;
  AWS_LIGHTSAIL_API GetContainerLogResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LIGHTSAIL_API GetContainerLogResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of objects that describe the log events of a container.</p>
   */
  inline const Aws::Vector<ContainerServiceLogEvent>& GetLogEvents() const { return m_logEvents; }
  template <typename LogEventsT = Aws::Vector<ContainerServiceLogEvent>>
  void SetLogEvents(LogEventsT&& value) {
    m_logEventsHasBeenSet = true;
    m_logEvents = std::forward<LogEventsT>(value);
  }
  template <typename LogEventsT = Aws::Vector<ContainerServiceLogEvent>>
  GetContainerLogResult& WithLogEvents(LogEventsT&& value) {
    SetLogEvents(std::forward<LogEventsT>(value));
    return *this;
  }
  template <typename LogEventsT = ContainerServiceLogEvent>
  GetContainerLogResult& AddLogEvents(LogEventsT&& value) {
    m_logEventsHasBeenSet = true;
    m_logEvents.emplace_back(std::forward<LogEventsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to advance to the next page of results from your request.</p> <p>A
   * next page token is not returned if there are no more results to display.</p>
   * <p>To get the next page of results, perform another <code>GetContainerLog</code>
   * request and specify the next page token using the <code>pageToken</code>
   * parameter.</p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  GetContainerLogResult& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetContainerLogResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ContainerServiceLogEvent> m_logEvents;

  Aws::String m_nextPageToken;

  Aws::String m_requestId;
  bool m_logEventsHasBeenSet = false;
  bool m_nextPageTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
