# reset_button.py
#
# Copyright 2024 Hari Rana (TheEvilSkeleton)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gettext import gettext as _
from typing import Any

from gi.repository import Gtk


class ResetButton(Gtk.Button):
    """A `Gtk.Button` for resetting a setting."""

    __gtype_name__ = "ResetButton"

    def __init__(self, **kwargs: Any) -> None:
        super().__init__(**kwargs)

        self.set_tooltip_text(_("Reset"))
        self.set_icon_name("edit-undo-symbolic")
