/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.sort.HashMap;
import com.icl.saxon.tree.AttributeCollection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class HTMLEmitter
extends XMLEmitter {
    private static final int REP_NATIVE = 0;
    private static final int REP_ENTITY = 1;
    private static final int REP_DECIMAL = 2;
    private static final int REP_HEX = 3;
    private int nonASCIIRepresentation = 1;
    private int excludedRepresentation = 2;
    private String mediaType = "text/html";
    private int inScript;
    private boolean started = false;
    static HashMap emptyTags = new HashMap(101);
    private static HashMap booleanAttributes;
    private static HashMap booleanCombinations;
    private static HashMap urlAttributes;
    private static HashMap urlCombinations;
    private static String[] latin1Entities;

    private static int representationCode(String string) {
        if (string.equalsIgnoreCase("native")) {
            return 0;
        }
        if (string.equalsIgnoreCase("entity")) {
            return 1;
        }
        if (string.equalsIgnoreCase("decimal")) {
            return 2;
        }
        if (string.equalsIgnoreCase("hex")) {
            return 3;
        }
        return 1;
    }

    private static void setEmptyTag(String string) {
        emptyTags.set(string);
    }

    protected static boolean isEmptyTag(String string) {
        return emptyTags.get(string);
    }

    private static void setBooleanAttribute(String string, String string2) {
        booleanAttributes.set(string2);
        booleanCombinations.set(string + "+" + string2);
    }

    private static boolean isBooleanAttribute(String string, String string2, String string3) {
        if (!string2.equalsIgnoreCase(string3)) {
            return false;
        }
        if (!booleanAttributes.get(string2)) {
            return false;
        }
        return booleanCombinations.get(string + "+" + string2);
    }

    private static void setUrlAttribute(String string, String string2) {
        urlAttributes.set(string2);
        urlCombinations.set(string + "+" + string2);
    }

    public static boolean isUrlAttribute(String string, String string2) {
        if (!urlAttributes.get(string2)) {
            return false;
        }
        return urlCombinations.get(string + "+" + string2);
    }

    public void startDocument() throws TransformerException {
        if (this.started) {
            return;
        }
        this.started = true;
        String string = this.outputProperties.getProperty("media-type");
        if (string != null) {
            this.mediaType = string;
        }
        String string2 = this.outputProperties.getProperty("doctype-system");
        String string3 = this.outputProperties.getProperty("doctype-public");
        if (string2 != null || string3 != null) {
            this.writeDocType("html", string2, string3);
        }
        this.empty = false;
        this.inScript = -1000000;
        String string4 = this.outputProperties.getProperty("{http://icl.com/saxon}character-representation");
        if (string4 != null) {
            String string5;
            String string6;
            int n = string4.indexOf(59);
            if (n < 0) {
                string6 = string4;
                string5 = string4;
            } else {
                string6 = string4.substring(0, n).trim();
                string5 = string4.substring(n + 1).trim();
            }
            this.nonASCIIRepresentation = HTMLEmitter.representationCode(string6);
            this.excludedRepresentation = HTMLEmitter.representationCode(string5);
            if (this.excludedRepresentation == 0) {
                this.excludedRepresentation = 1;
            }
        }
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        String string;
        String string2 = this.namePool.getLocalName(n);
        short s = this.namePool.getURICode(n);
        if (s == 0 && (string2.equalsIgnoreCase("script") || string2.equalsIgnoreCase("style"))) {
            this.inScript = 0;
        }
        ++this.inScript;
        super.startElement(n, attributes, nArray, n2);
        this.closeStartTag(-1, false);
        if (s == 0 && string2.equalsIgnoreCase("head") && !"yes".equals(string = this.outputProperties.getProperty("{http://icl.com/saxon}omit-meta-tag"))) {
            String string3 = this.outputProperties.getProperty("encoding");
            if (string3 == null) {
                string3 = "utf-8";
            }
            AttributeCollection attributeCollection = new AttributeCollection(this.namePool);
            attributeCollection.addAttribute("", "", "http-equiv", "CDATA", "Content-Type");
            attributeCollection.addAttribute("", "", "content", "CDATA", this.mediaType + "; charset=" + string3);
            try {
                this.writer.write("\n      ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n3 = this.namePool.allocate("", "", "meta");
            this.startElement(n3, attributeCollection, new int[0], 0);
            this.endElement(n3);
            try {
                this.writer.write("\n   ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void writeAttribute(int n, String string, String string2, String string3) throws TransformerException {
        try {
            String string4 = this.namePool.getDisplayName(n);
            short s = this.namePool.getURICode(n);
            if (s == 0 && HTMLEmitter.isBooleanAttribute(string4, string, string3)) {
                this.testCharacters(string);
                this.writer.write(string);
            } else if (s == 0 && HTMLEmitter.isUrlAttribute(string4, string) && !string2.equals("NO-ESC")) {
                String string5 = HTMLEmitter.escapeURL(string3);
                super.writeAttribute(n, string, string2, string5);
            } else {
                super.writeAttribute(n, string, string2, string3);
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void writeEscape(char[] cArray, int n, int n2, boolean bl) throws IOException {
        int n3 = n;
        boolean[] blArray = bl ? XMLEmitter.specialInAtt : XMLEmitter.specialInText;
        while (n3 < n + n2) {
            int n4;
            block29: {
                block30: {
                    block35: {
                        block31: {
                            block34: {
                                block33: {
                                    block32: {
                                        boolean bl2;
                                        n4 = n3;
                                        boolean bl3 = true;
                                        do {
                                            if (!bl3 || (bl3 = false) || !true) {
                                                ++n4;
                                            }
                                            if (n4 >= n + n2) break;
                                            if (cArray[n4] < '\u0080') {
                                                if (!blArray[cArray[n4]]) {
                                                    bl2 = true;
                                                    continue;
                                                }
                                                bl2 = false;
                                                continue;
                                            }
                                            if (this.characterSet.inCharset(cArray[n4])) {
                                                if (this.nonASCIIRepresentation == 0 && cArray[n4] != '\u00a0') {
                                                    bl2 = true;
                                                    continue;
                                                }
                                                bl2 = false;
                                                continue;
                                            }
                                            bl2 = false;
                                        } while (bl2);
                                        this.writer.write(cArray, n3, n4 - n3);
                                        if (n4 == n + n2) {
                                            return;
                                        }
                                        if (cArray[n4] >= '\u007f') break block30;
                                        if (!bl) break block31;
                                        if (cArray[n4] != '<') break block32;
                                        this.writer.write(60);
                                        break block29;
                                    }
                                    if (cArray[n4] != '>') break block33;
                                    this.writer.write("&gt;");
                                    break block29;
                                }
                                if (cArray[n4] != '&') break block34;
                                if (n4 + 1 < n + n2 && cArray[n4 + 1] == '{') {
                                    this.writer.write(38);
                                    break block29;
                                } else {
                                    this.writer.write("&amp;");
                                }
                                break block29;
                            }
                            if (cArray[n4] == '\"') {
                                this.writer.write("&#34;");
                                break block29;
                            } else if (cArray[n4] == '\n') {
                                this.writer.write("&#xA;");
                            }
                            break block29;
                        }
                        if (cArray[n4] != '<') break block35;
                        this.writer.write("&lt;");
                        break block29;
                    }
                    if (cArray[n4] == '>') {
                        this.writer.write("&gt;");
                        break block29;
                    } else if (cArray[n4] == '&') {
                        this.writer.write("&amp;");
                    }
                    break block29;
                }
                if (cArray[n4] == '\u00a0') {
                    this.writer.write("&nbsp;");
                } else if (cArray[n4] >= '\ud800' && cArray[n4] <= '\udbff') {
                    int n5 = (cArray[n4] - 55296) * 1024 + (cArray[n4 + 1] - 56320) + 65536;
                    this.outputCharacterReference(n5);
                    ++n4;
                } else if (this.characterSet.inCharset(cArray[n4])) {
                    switch (this.nonASCIIRepresentation) {
                        case 0: {
                            this.writer.write(cArray[n4]);
                            break;
                        }
                        case 1: {
                            if (cArray[n4] > '\u00a0' && cArray[n4] <= '\u00ff') {
                                this.writer.write(38);
                                this.writer.write(latin1Entities[cArray[n4] - 160]);
                                this.writer.write(59);
                                break;
                            }
                        }
                        case 2: {
                            this.preferHex = false;
                            this.outputCharacterReference(cArray[n4]);
                            break;
                        }
                        case 3: {
                            this.preferHex = true;
                        }
                        default: {
                            this.outputCharacterReference(cArray[n4]);
                            break;
                        }
                    }
                } else {
                    this.preferHex = this.excludedRepresentation == 3;
                    this.outputCharacterReference(cArray[n4]);
                }
            }
            n3 = ++n4;
        }
    }

    public void endElement(int n) throws TransformerException {
        String string = this.namePool.getLocalName(n);
        short s = this.namePool.getURICode(n);
        --this.inScript;
        if (this.inScript == 0) {
            this.inScript = -1000000;
        }
        if (s != 0 || !HTMLEmitter.isEmptyTag(string)) {
            super.endElement(n);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        if (this.inScript > 0 && this.escaping) {
            this.setEscaping(false);
            super.characters(cArray, n, n2);
            this.setEscaping(true);
        } else {
            super.characters(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
        try {
            this.writer.write("<?");
            this.writer.write(string);
            this.writer.write(32);
            this.writer.write(string2);
            this.writer.write(62);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    private static String escapeURL(String string) throws TransformerException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "0123456789ABCDEF";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < ' ' || c > '~') {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    object = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                    ((OutputStreamWriter)object).write(c);
                    ((OutputStreamWriter)object).close();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new TransformerException(unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new TransformerException(iOException);
                }
                object = byteArrayOutputStream.toByteArray();
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    Object object2 = object[n2] >= 0 ? object[n2] : (Object)(256 + object[n2]);
                    stringBuffer.append('%');
                    stringBuffer.append(string2.charAt((int)(object2 / 16)));
                    stringBuffer.append(string2.charAt((int)(object2 % 16)));
                    ++n2;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        HTMLEmitter.setEmptyTag("area");
        HTMLEmitter.setEmptyTag("base");
        HTMLEmitter.setEmptyTag("basefont");
        HTMLEmitter.setEmptyTag("br");
        HTMLEmitter.setEmptyTag("col");
        HTMLEmitter.setEmptyTag("frame");
        HTMLEmitter.setEmptyTag("hr");
        HTMLEmitter.setEmptyTag("img");
        HTMLEmitter.setEmptyTag("input");
        HTMLEmitter.setEmptyTag("isindex");
        HTMLEmitter.setEmptyTag("link");
        HTMLEmitter.setEmptyTag("meta");
        HTMLEmitter.setEmptyTag("param");
        booleanAttributes = new HashMap(101);
        booleanCombinations = new HashMap(203);
        HTMLEmitter.setBooleanAttribute("area", "nohref");
        HTMLEmitter.setBooleanAttribute("button", "disabled");
        HTMLEmitter.setBooleanAttribute("dir", "compact");
        HTMLEmitter.setBooleanAttribute("dl", "compact");
        HTMLEmitter.setBooleanAttribute("frame", "noresize");
        HTMLEmitter.setBooleanAttribute("hr", "noshade");
        HTMLEmitter.setBooleanAttribute("img", "ismap");
        HTMLEmitter.setBooleanAttribute("input", "checked");
        HTMLEmitter.setBooleanAttribute("input", "disabled");
        HTMLEmitter.setBooleanAttribute("input", "readonly");
        HTMLEmitter.setBooleanAttribute("menu", "compact");
        HTMLEmitter.setBooleanAttribute("object", "declare");
        HTMLEmitter.setBooleanAttribute("ol", "compact");
        HTMLEmitter.setBooleanAttribute("optgroup", "disabled");
        HTMLEmitter.setBooleanAttribute("option", "selected");
        HTMLEmitter.setBooleanAttribute("option", "disabled");
        HTMLEmitter.setBooleanAttribute("script", "defer");
        HTMLEmitter.setBooleanAttribute("select", "multiple");
        HTMLEmitter.setBooleanAttribute("select", "disabled");
        HTMLEmitter.setBooleanAttribute("td", "nowrap");
        HTMLEmitter.setBooleanAttribute("textarea", "disabled");
        HTMLEmitter.setBooleanAttribute("textarea", "readonly");
        HTMLEmitter.setBooleanAttribute("th", "nowrap");
        HTMLEmitter.setBooleanAttribute("ul", "compact");
        urlAttributes = new HashMap(101);
        urlCombinations = new HashMap(203);
        HTMLEmitter.setUrlAttribute("form", "action");
        HTMLEmitter.setUrlAttribute("body", "background");
        HTMLEmitter.setUrlAttribute("q", "cite");
        HTMLEmitter.setUrlAttribute("blockquote", "cite");
        HTMLEmitter.setUrlAttribute("del", "cite");
        HTMLEmitter.setUrlAttribute("ins", "cite");
        HTMLEmitter.setUrlAttribute("object", "classid");
        HTMLEmitter.setUrlAttribute("object", "codebase");
        HTMLEmitter.setUrlAttribute("applet", "codebase");
        HTMLEmitter.setUrlAttribute("object", "data");
        HTMLEmitter.setUrlAttribute("a", "href");
        HTMLEmitter.setUrlAttribute("a", "name");
        HTMLEmitter.setUrlAttribute("area", "href");
        HTMLEmitter.setUrlAttribute("link", "href");
        HTMLEmitter.setUrlAttribute("base", "href");
        HTMLEmitter.setUrlAttribute("img", "longdesc");
        HTMLEmitter.setUrlAttribute("frame", "longdesc");
        HTMLEmitter.setUrlAttribute("iframe", "longdesc");
        HTMLEmitter.setUrlAttribute("head", "profile");
        HTMLEmitter.setUrlAttribute("script", "src");
        HTMLEmitter.setUrlAttribute("input", "src");
        HTMLEmitter.setUrlAttribute("frame", "src");
        HTMLEmitter.setUrlAttribute("iframe", "src");
        HTMLEmitter.setUrlAttribute("img", "src");
        HTMLEmitter.setUrlAttribute("img", "usemap");
        HTMLEmitter.setUrlAttribute("input", "usemap");
        HTMLEmitter.setUrlAttribute("object", "usemap");
        latin1Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }
}

