/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.TreeWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class XPipeline
extends XCompoundStep {
    private static final QName c_param_set = new QName("c", "http://www.w3.org/ns/xproc-step", "param-set");
    private static final QName c_param = new QName("c", "http://www.w3.org/ns/xproc-step", "param");
    private static final QName _name = new QName("name");
    private static final QName _namespace = new QName("namespace");
    private static final QName _value = new QName("value");
    private Hashtable<QName, RuntimeValue> optionsPassedIn = null;
    private boolean doPhoneHome = false;

    public XPipeline(XProcRuntime xProcRuntime, Step step, XCompoundStep xCompoundStep) {
        super(xProcRuntime, step, xCompoundStep);
    }

    @Override
    public DeclareStep getDeclareStep() {
        return this.step.getDeclaration();
    }

    public void passOption(QName qName, RuntimeValue runtimeValue) {
        if (this.optionsPassedIn == null) {
            this.optionsPassedIn = new Hashtable();
        }
        this.optionsPassedIn.put(qName, runtimeValue);
    }

    @Override
    public Hashtable<QName, RuntimeValue> getInScopeOptions() {
        Hashtable<QName, RuntimeValue> hashtable = new Hashtable<QName, RuntimeValue>();
        if (this.inScopeOptions != null) {
            for (QName qName : this.inScopeOptions.keySet()) {
                hashtable.put(qName, (RuntimeValue)this.inScopeOptions.get(qName));
            }
        }
        if (this.optionsPassedIn != null) {
            for (QName qName : this.optionsPassedIn.keySet()) {
                hashtable.put(qName, this.optionsPassedIn.get(qName));
            }
        }
        return hashtable;
    }

    public Set<String> getInputs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.inputs.keySet()) {
            if (string.startsWith("|")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void clearInputs(String string) {
        Vector vector = (Vector)this.inputs.get(string);
        vector.clear();
    }

    public void writeTo(String string, XdmNode xdmNode) {
        WritablePipe writablePipe = (WritablePipe)this.outputs.get(string + "|");
        this.finest(this.step.getNode(), "writesTo " + writablePipe + " for " + string);
        writablePipe.write(xdmNode);
    }

    public Set<String> getOutputs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.outputs.keySet()) {
            if (string.endsWith("|")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public ReadablePipe readFrom(String string) {
        ReadablePipe readablePipe = null;
        XOutput xOutput = this.getOutput(string);
        readablePipe = xOutput.getReader();
        readablePipe.canReadSequence(true);
        return readablePipe;
    }

    public Serialization getSerialization(String string) {
        Output output = this.step.getOutput(string);
        return output.getSerialization();
    }

    @Override
    public void run() throws SaxonApiException {
        QName qName = XProcConstants.p_pipeline;
        this.fine(null, "Running " + qName + " " + this.step.getName());
        if (this.runtime.getAllowGeneralExpressions()) {
            this.fine(this.step.getNode(), "Running with the 'general-values' extension enabled.");
        }
        XProcData xProcData = this.runtime.getXProcData();
        xProcData.openFrame(this);
        this.runtime.start(this);
        try {
            this.doRun();
        }
        catch (XProcException xProcException) {
            this.runtime.error(xProcException);
            throw xProcException;
        }
        catch (SaxonApiException saxonApiException) {
            this.runtime.error(saxonApiException);
            throw saxonApiException;
        }
        this.runtime.finish(this);
        xProcData.closeFrame();
    }

    private void setupParameters() {
        Vector<String> vector = new Vector<String>();
        Iterator<String> iterator = this.getParameterPorts().iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        for (String string : vector) {
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(c_param_set);
            treeWriter.startContent();
            for (QName qName : this.getParameters(string)) {
                String string2 = this.getParameter(string, qName).getString();
                treeWriter.addStartElement(c_param);
                treeWriter.addAttribute(_name, qName.getLocalName());
                if (qName.getNamespaceURI() != null) {
                    treeWriter.addAttribute(_namespace, qName.getNamespaceURI());
                }
                treeWriter.addAttribute(_value, string2);
                treeWriter.startContent();
                treeWriter.addEndElement();
            }
            treeWriter.addEndElement();
            treeWriter.endDocument();
            this.writeTo(string, treeWriter.getResult());
        }
    }

    private void doRun() throws SaxonApiException {
        XdmNode xdmNode;
        Object object;
        Object object2;
        for (String object3 : this.inputs.keySet()) {
            if (object3.startsWith("|")) continue;
            object2 = object3 + "|";
            object = (WritablePipe)this.outputs.get(object2);
            for (ReadablePipe readablePipe : (Vector)this.inputs.get(object3)) {
                while (readablePipe.moreDocuments()) {
                    xdmNode = readablePipe.read();
                    object.write(xdmNode);
                    this.finest(this.step.getNode(), "Pipeline input copy from " + readablePipe + " to " + object);
                }
            }
        }
        this.setupParameters();
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (QName qName : this.step.getOptions()) {
            object2 = this.step.getOption(qName);
            object = null;
            if (this.optionsPassedIn != null && this.optionsPassedIn.containsKey(qName)) {
                object = this.optionsPassedIn.get(qName);
            } else {
                if (((Option)object2).getRequired() && ((Option)object2).getSelect() == null) {
                    throw XProcException.staticError(18, ((SourceArtifact)object2).getNode(), "No value provided for required option \"" + ((Option)object2).getName() + "\"");
                }
                object = ((Option)object2).getSelect() == null ? new RuntimeValue() : this.computeValue((ComputableValue)object2);
            }
            this.setOption(qName, (RuntimeValue)object);
            this.inScopeOptions.put(qName, object);
        }
        for (Variable variable : this.step.getVariables()) {
            object2 = this.computeValue(variable);
            this.inScopeOptions.put(variable.getName(), object2);
        }
        for (XStep xStep : this.subpipeline) {
            xStep.run();
        }
        for (String string : this.inputs.keySet()) {
            if (!string.startsWith("|")) continue;
            object2 = string.substring(1);
            object = (WritablePipe)this.outputs.get(object2);
            for (ReadablePipe readablePipe : (Vector)this.inputs.get(string)) {
                if (!readablePipe.moreDocuments() && !object.writeSequence()) {
                    throw XProcException.dynamicError(7);
                }
                while (readablePipe.moreDocuments()) {
                    xdmNode = readablePipe.read();
                    object.write(xdmNode);
                    this.finest(this.step.getNode(), "Pipeline output copy from " + readablePipe + " to " + object);
                }
            }
            object.close();
        }
    }
}

