/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.Equal;
import com.thaiopensource.validate.nrl.ContextMap;
import com.thaiopensource.validate.nrl.Mode;
import java.util.Enumeration;
import java.util.Vector;

class ModeUsage {
    private final Mode mode;
    private final Mode currentMode;
    private ContextMap modeMap;
    private int attributeProcessing = -1;

    ModeUsage(Mode mode, Mode mode2) {
        this(mode, mode2, null);
    }

    private ModeUsage(Mode mode, Mode mode2, ContextMap contextMap) {
        this.mode = mode;
        this.currentMode = mode2;
        this.modeMap = contextMap;
    }

    ModeUsage changeCurrentMode(Mode mode) {
        return new ModeUsage(this.mode, mode, this.modeMap);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModeUsage)) {
            return false;
        }
        ModeUsage modeUsage = (ModeUsage)object;
        return this.mode == modeUsage.mode && this.currentMode == modeUsage.currentMode && Equal.equal(this.modeMap, modeUsage.modeMap);
    }

    public int hashCode() {
        int n = this.mode.hashCode() ^ this.currentMode.hashCode();
        if (this.modeMap != null) {
            n ^= this.modeMap.hashCode();
        }
        return n;
    }

    private Mode resolve(Mode mode) {
        return mode == Mode.CURRENT ? this.currentMode : mode;
    }

    int getAttributeProcessing() {
        if (this.attributeProcessing == -1) {
            this.attributeProcessing = this.resolve(this.mode).getAttributeProcessing();
            if (this.modeMap != null) {
                Enumeration enumeration = this.modeMap.values();
                while (enumeration.hasMoreElements() && this.attributeProcessing != 2) {
                    this.attributeProcessing = Math.max(this.resolve((Mode)enumeration.nextElement()).getAttributeProcessing(), this.attributeProcessing);
                }
            }
        }
        return this.attributeProcessing;
    }

    boolean isContextDependent() {
        return this.modeMap != null;
    }

    Mode getMode(Vector vector) {
        Mode mode;
        if (this.modeMap != null && (mode = (Mode)this.modeMap.get(vector)) != null) {
            return this.resolve(mode);
        }
        return this.resolve(this.mode);
    }

    boolean addContext(boolean bl, Vector vector, Mode mode) {
        if (this.modeMap == null) {
            this.modeMap = new ContextMap();
        }
        return this.modeMap.put(bl, vector, mode);
    }
}

