﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/OutboundRawMessage.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Connect {
namespace Model {

OutboundRawMessage::OutboundRawMessage(JsonView jsonValue) { *this = jsonValue; }

OutboundRawMessage& OutboundRawMessage::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Subject")) {
    m_subject = jsonValue.GetString("Subject");
    m_subjectHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Body")) {
    m_body = jsonValue.GetString("Body");
    m_bodyHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ContentType")) {
    m_contentType = jsonValue.GetString("ContentType");
    m_contentTypeHasBeenSet = true;
  }
  return *this;
}

JsonValue OutboundRawMessage::Jsonize() const {
  JsonValue payload;

  if (m_subjectHasBeenSet) {
    payload.WithString("Subject", m_subject);
  }

  if (m_bodyHasBeenSet) {
    payload.WithString("Body", m_body);
  }

  if (m_contentTypeHasBeenSet) {
    payload.WithString("ContentType", m_contentType);
  }

  return payload;
}

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
