//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// 20100804  M. Kelsey -- Add name string to ctor
// 20110719  M. Kelsey -- Add initial state code to ctor
// 20110725  M. Kelsey -- Instantiate cross-section object for self-registration
// 20110916  M. Kelsey -- Drop self-registration due to platform inconsistencies

#include "G4CascadeKplusNChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;
 
namespace {
  // Outgoing particle types of a given multiplicity
 
  static const G4int kpn2bfs[2][2] =
    {{kpl,neu}, {k0,pro}};
 
  static const G4int kpn3bfs[8][3] =
    {{kpl,neu,pi0}, {kpl,pro,pim}, {k0,pro,pi0}, {k0,neu,pip},
     {kpl,k0,lam},  {kpl,k0,s0},   {k0,k0,sp},   {kpl,kpl,sm}};

  static const G4int kpn4bfs[20][4] =
    {{neu,pi0,pi0,kpl}, {neu,pip,pim,kpl}, {pro,pim,pi0,kpl}, {neu,pip,pi0,k0},
     {pro,pi0,pi0,k0},  {pro,pip,pim,k0},  {pim,kpl,kpl,lam}, {pi0,kpl,k0,lam},
     {pip,k0,k0,lam},   {pim,kpl,k0,sp},   {pi0,k0,k0,sp},    {pim,kpl,kpl,s0},
     {pi0,kpl,k0,s0},   {pip,k0,k0,s0},    {pi0,kpl,kpl,sm},  {pip,kpl,k0,sm},
     {neu,kpl,kpl,kmi}, {neu,kpl,k0,k0b},  {pro,kpl,kmi,k0},  {pro,k0,k0,k0b}};
 
  static const G4int kpn5bfs[34][5] =
    {{neu,pip,pip,pim,k0},  {neu,pip,pi0,pi0,k0},  {pro,pip,pim,pim,kpl},
     {pro,pim,pi0,pi0,kpl}, {pro,pi0,pi0,pi0,k0},  {neu,pi0,pi0,pi0,kpl},
     {pro,pip,pim,pi0,k0},  {neu,pip,pim,pi0,kpl}, {pim,pi0,kpl,kpl,lam},
     {pi0,pi0,kpl,k0,lam},  {pip,pim,kpl,k0,lam},  {pip,pi0,k0,k0,lam},
     {pim,pim,kpl,kpl,sp},  {pim,pi0,kpl,k0,sp},   {pi0,pi0,k0,k0,sp},
     {pip,pim,k0,k0,sp},    {pim,pi0,kpl,kpl,s0},  {pi0,pi0,kpl,k0,s0},
     {pip,pim,kpl,k0,s0},   {pip,pi0,k0,k0,s0},    {pi0,pi0,kpl,kpl,sm},
     {pip,pim,kpl,kpl,sm},  {pip,pi0,kpl,k0,sm},   {pip,pip,k0,k0,sm},
     {pro,pim,kpl,kpl,kmi}, {pro,pim,kpl,k0,k0b},  {pro,pi0,kpl,kmi,k0},
     {pro,pi0,k0,k0,k0b},   {pro,pip,kmi,k0,k0},   {neu,pim,kpl,kpl,k0b},
     {neu,pi0,kpl,kpl,kmi}, {neu,pi0,kpl,k0,k0b},  {neu,pip,kpl,kmi,k0},
     {neu,pip,k0,k0,k0b}};

  static const G4int kpn6bfs[48][6] =
    {{pro,pip,pim,pim,pi0,kpl}, {neu,pip,pim,pi0,pi0,kpl},
     {pro,pip,pim,pi0,pi0,k0},  {neu,pip,pip,pim,pi0,k0},
     {pro,pip,pip,pim,pim,k0},  {neu,pip,pip,pim,pim,kpl},
     {pro,pim,pi0,pi0,pi0,kpl}, {neu,pip,pi0,pi0,pi0,k0},
     {pro,pi0,pi0,pi0,pi0,k0},  {neu,pi0,pi0,pi0,pi0,kpl},
     {pip,pim,pi0,kpl,k0,lam},  {pim,pi0,pi0,kpl,kpl,lam},
     {pip,pim,pim,kpl,kpl,lam}, {pip,pi0,pi0,k0,k0,lam},
     {pip,pip,pim,k0,k0,lam},   {pi0,pi0,pi0,kpl,k0,lam},
     {pim,pi0,pi0,kpl,k0,sp},   {pip,pim,pim,kpl,k0,sp},
     {pip,pim,pi0,k0,k0,sp},    {pim,pim,pi0,kpl,kpl,sp},
     {pi0,pi0,pi0,k0,k0,sp},    {pip,pim,pi0,kpl,k0,s0},
     {pim,pi0,pi0,kpl,kpl,s0},  {pip,pim,pim,kpl,kpl,s0},
     {pip,pi0,pi0,k0,k0,s0},    {pip,pip,pim,k0,k0,s0},
     {pi0,pi0,pi0,kpl,k0,s0},   {pip,pim,pi0,kpl,kpl,sm},
     {pip,pi0,pi0,kpl,k0,sm},   {pip,pip,pim,kpl,k0,sm},
     {pip,pip,pi0,k0,k0,sm},    {pi0,pi0,pi0,kpl,kpl,sm},
     {pro,pim,pi0,kpl,k0,k0b},  {pro,pip,pim,kpl,kmi,k0},
     {pro,pim,pi0,kpl,kpl,kmi}, {pro,pi0,pi0,kpl,kmi,k0},
     {pro,pip,pim,k0,k0,k0b},   {pro,pip,pi0,kmi,k0,k0},
     {pro,pim,pim,kpl,kpl,k0b}, {pro,pi0,pi0,k0,k0,k0b},
     {neu,pip,pim,kpl,k0,k0b},  {neu,pip,pi0,kpl,kmi,k0},
     {neu,pim,pi0,kpl,kpl,k0b}, {neu,pip,pim,kpl,kpl,kmi},
     {neu,pi0,pi0,kpl,k0,k0b},  {neu,pip,pi0,k0,k0,k0b},
     {neu,pi0,pi0,kpl,kpl,kmi}, {neu,pip,pip,kmi,k0,k0}};

  static const G4int kpn7bfs[62][7] =
    {{pro,pip,pim,pim,pi0,pi0,kpl}, {neu,pip,pip,pim,pim,pi0,kpl},
     {pro,pip,pip,pim,pim,pi0,k0},  {neu,pip,pip,pim,pi0,pi0,k0},
     {pro,pip,pim,pi0,pi0,pi0,k0},  {neu,pip,pim,pi0,pi0,pi0,kpl},
     {pro,pip,pip,pim,pim,pim,kpl}, {neu,pip,pip,pip,pim,pim,k0},
     {pro,pim,pi0,pi0,pi0,pi0,kpl}, {neu,pip,pi0,pi0,pi0,pi0,k0},
     {pro,pi0,pi0,pi0,pi0,pi0,k0},  {neu,pi0,pi0,pi0,pi0,pi0,kpl}, 
     {pip,pim,pi0,pi0,kpl,k0,lam},  {pip,pim,pim,pi0,kpl,kpl,lam},
     {pip,pip,pim,pim,kpl,k0,lam},  {pip,pip,pim,pi0,k0,k0,lam},
     {pim,pi0,pi0,pi0,kpl,kpl,lam}, {pip,pi0,pi0,pi0,k0,k0,lam},
     {pi0,pi0,pi0,pi0,kpl,k0,lam},  {pip,pim,pim,pi0,kpl,k0,sp},
     {pip,pim,pi0,pi0,k0,k0,sp},    {pim,pi0,pi0,pi0,kpl,k0,sp},
     {pim,pim,pi0,pi0,kpl,kpl,sp},  {pip,pip,pim,pim,k0,k0,sp},
     {pip,pim,pim,pim,kpl,kpl,sp},  {pi0,pi0,pi0,pi0,k0,k0,sp},
     {pip,pim,pi0,pi0,kpl,k0,s0},   {pip,pim,pim,pi0,kpl,kpl,s0},
     {pip,pip,pim,pim,kpl,k0,s0},   {pip,pip,pim,pi0,k0,k0,s0},
     {pim,pi0,pi0,pi0,kpl,kpl,s0},  {pip,pi0,pi0,pi0,k0,k0,s0},
     {pi0,pi0,pi0,pi0,kpl,k0,s0},   {pip,pip,pim,pi0,kpl,k0,sm},
     {pip,pim,pi0,pi0,kpl,kpl,sm},  {pip,pi0,pi0,pi0,kpl,k0,sm},
     {pip,pip,pim,pim,kpl,kpl,sm},  {pip,pip,pi0,pi0,k0,k0,sm},
     {pip,pip,pip,pim,k0,k0,sm},    {pi0,pi0,pi0,pi0,kpl,kpl,sm},
     {pro,pip,pim,pi0,kpl,kmi,k0},  {neu,pip,pim,pi0,kpl,k0,k0b},
     {pro,pim,pi0,pi0,kpl,k0,k0b},  {pro,pip,pim,pim,kpl,k0,k0b},
     {pro,pip,pim,pi0,k0,k0,k0b},   {neu,pip,pim,pi0,kpl,kpl,kmi},
     {neu,pip,pi0,pi0,kpl,kmi,k0},  {neu,pip,pip,pim,kpl,kmi,k0},
     {pro,pim,pim,pi0,kpl,kpl,k0b}, {pro,pim,pi0,pi0,kpl,kpl,kmi},
     {pro,pip,pim,pim,kpl,kpl,kmi}, {pro,pip,pi0,pi0,kmi,k0,k0},
     {pro,pip,pip,pim,kmi,k0,k0},   {neu,pim,pi0,pi0,kpl,kpl,k0b},
     {neu,pip,pim,pim,kpl,kpl,k0b}, {neu,pip,pi0,pi0,k0,k0,k0b},
     {neu,pip,pip,pim,k0,k0,k0b},   {neu,pip,pip,pi0,kmi,k0,k0},
     {pro,pi0,pi0,pi0,kpl,kmi,k0},  {neu,pi0,pi0,pi0,kpl,k0,k0b},
     {pro,pi0,pi0,pi0,k0,k0,k0b},   {neu,pi0,pi0,pi0,kpl,kpl,kmi}};

  static const G4int kpn8bfs[45][8] =
    {{pro,pip,pip,pim,pim,pi0,pi0,k0},  {neu,pip,pip,pim,pim,pi0,pi0,kpl},
     {pro,pip,pim,pim,pi0,pi0,pi0,kpl}, {pro,pip,pip,pim,pim,pim,pi0,kpl},
     {neu,pip,pip,pim,pi0,pi0,pi0,k0},  {neu,pip,pip,pip,pim,pim,pi0,k0},
     {pro,pip,pim,pi0,pi0,pi0,pi0,k0},  {neu,pip,pim,pi0,pi0,pi0,pi0,kpl},
     {pro,pip,pip,pip,pim,pim,pim,k0},  {neu,pip,pip,pip,pim,pim,pim,kpl},
     {pro,pim,pi0,pi0,pi0,pi0,pi0,kpl}, {neu,pip,pi0,pi0,pi0,pi0,pi0,k0},
     {pro,pi0,pi0,pi0,pi0,pi0,pi0,k0},  {neu,pi0,pi0,pi0,pi0,pi0,pi0,kpl},
     {pip,pip,pim,pim,pi0,kpl,k0,lam},  {pip,pim,pi0,pi0,pi0,kpl,k0,lam},
     {pip,pim,pim,pi0,pi0,kpl,kpl,lam}, {pip,pip,pim,pi0,pi0,k0,k0,lam},
     {pip,pip,pim,pim,pim,kpl,kpl,lam}, {pip,pip,pip,pim,pim,k0,k0,lam},
     {pim,pi0,pi0,pi0,pi0,kpl,kpl,lam}, {pip,pi0,pi0,pi0,pi0,k0,k0,lam},
     {pi0,pi0,pi0,pi0,pi0,kpl,k0,lam},  {pip,pim,pim,pi0,pi0,kpl,k0,sp},
     {pip,pip,pim,pim,pi0,k0,k0,sp},    {pip,pim,pim,pim,pi0,kpl,kpl,sp},
     {pip,pip,pim,pim,pim,kpl,k0,sp},   {pip,pim,pi0,pi0,pi0,k0,k0,sp},
     {pim,pim,pi0,pi0,pi0,kpl,kpl,sp},  {pim,pi0,pi0,pi0,pi0,kpl,k0,sp},
     {pip,pip,pim,pim,pi0,kpl,k0,s0},   {pip,pim,pi0,pi0,pi0,kpl,k0,s0},
     {pip,pim,pim,pi0,pi0,kpl,kpl,s0},  {pip,pip,pim,pi0,pi0,k0,k0,s0},
     {pip,pip,pim,pim,pim,kpl,kpl,s0},  {pip,pip,pip,pim,pim,k0,k0,s0},
     {pim,pi0,pi0,pi0,pi0,kpl,kpl,s0},  {pip,pi0,pi0,pi0,pi0,k0,k0,s0},
     {pip,pip,pim,pi0,pi0,kpl,k0,sm},   {pip,pip,pim,pim,pi0,kpl,kpl,sm},
     {pip,pim,pi0,pi0,pi0,kpl,kpl,sm},  {pip,pip,pip,pim,pim,kpl,k0,sm},
     {pip,pip,pip,pim,pi0,k0,k0,sm},    {pip,pi0,pi0,pi0,pi0,kpl,k0,sm},
     {pip,pip,pi0,pi0,pi0,k0,k0,sm}};

  static const G4int kpn9bfs[50][9] =
    {{pro,pip,pip,pim,pim,pim,pi0,pi0,kpl}, {pro,pip,pip,pim,pim,pi0,pi0,pi0,k0},
     {neu,pip,pip,pim,pim,pi0,pi0,pi0,kpl}, {neu,pip,pip,pip,pim,pim,pi0,pi0,k0},
     {pro,pip,pip,pip,pim,pim,pim,pi0,k0},  {neu,pip,pip,pip,pim,pim,pim,pi0,kpl},
     {pro,pip,pim,pim,pi0,pi0,pi0,pi0,kpl}, {neu,pip,pip,pim,pi0,pi0,pi0,pi0,k0},
     {pro,pip,pip,pip,pim,pim,pim,pim,kpl}, {neu,pip,pip,pip,pip,pim,pim,pim,k0},
     {pro,pip,pim,pi0,pi0,pi0,pi0,pi0,k0},  {neu,pip,pim,pi0,pi0,pi0,pi0,pi0,kpl},
     {pro,pim,pi0,pi0,pi0,pi0,pi0,pi0,kpl}, {neu,pip,pi0,pi0,pi0,pi0,pi0,pi0,k0},
     {pip,pip,pim,pim,pi0,pi0,kpl,k0,lam},  {pip,pim,pim,pi0,pi0,pi0,kpl,kpl,lam},
     {pip,pip,pim,pim,pim,pi0,kpl,kpl,lam}, {pip,pim,pi0,pi0,pi0,pi0,kpl,k0,lam},
     {pip,pip,pim,pi0,pi0,pi0,k0,k0,lam},   {pip,pip,pip,pim,pim,pi0,k0,k0,lam},
     {pip,pip,pip,pim,pim,pim,kpl,k0,lam},  {pim,pi0,pi0,pi0,pi0,pi0,kpl,kpl,lam},
     {pip,pi0,pi0,pi0,pi0,pi0,k0,k0,lam},   {pip,pim,pim,pi0,pi0,pi0,kpl,k0,sp},
     {pip,pip,pim,pim,pim,pi0,kpl,k0,sp},   {pip,pip,pim,pim,pi0,pi0,k0,k0,sp},
     {pip,pim,pim,pim,pi0,pi0,kpl,kpl,sp},  {pip,pim,pi0,pi0,pi0,pi0,k0,k0,sp},
     {pip,pip,pip,pim,pim,pim,k0,k0,sp},    {pim,pim,pi0,pi0,pi0,pi0,kpl,kpl,sp},
     {pip,pip,pim,pim,pim,pim,kpl,kpl,sp},  {pim,pi0,pi0,pi0,pi0,pi0,kpl,k0,sp},
     {pip,pip,pim,pim,pi0,pi0,kpl,k0,s0},   {pip,pim,pim,pi0,pi0,pi0,kpl,kpl,s0},
     {pip,pip,pim,pim,pim,pi0,kpl,kpl,s0},  {pip,pim,pi0,pi0,pi0,pi0,kpl,k0,s0},
     {pip,pip,pim,pi0,pi0,pi0,k0,k0,s0},    {pip,pip,pip,pim,pim,pi0,k0,k0,s0},
     {pip,pip,pip,pim,pim,pim,kpl,k0,s0},   {pim,pi0,pi0,pi0,pi0,pi0,kpl,kpl,s0},
     {pip,pi0,pi0,pi0,pi0,pi0,k0,k0,s0},    {pip,pip,pim,pi0,pi0,pi0,kpl,k0,sm},
     {pip,pip,pip,pim,pim,pi0,kpl,k0,sm},   {pip,pip,pim,pim,pi0,pi0,kpl,kpl,sm},
     {pip,pip,pip,pim,pi0,pi0,k0,k0,sm},    {pip,pim,pi0,pi0,pi0,pi0,kpl,kpl,sm},
     {pip,pip,pip,pim,pim,pim,kpl,kpl,sm},  {pip,pip,pi0,pi0,pi0,pi0,k0,k0,sm},
     {pip,pip,pip,pip,pim,pim,k0,k0,sm},    {pip,pi0,pi0,pi0,pi0,pi0,kpl,k0,sm}};

  // 
  // Cross sections for K+ n -> 2-9 body final states
  //
  // first index:    0-1: channels for mult = 2
  //                 2-9: channels for mult = 3
  //               10-29: channels for mult = 4
  //               30-63: channels for mult = 5
  //              64-111: channels for mult = 6
  //             112-173: channels for mult = 7
  //             174-218: channels for mult = 8
  //             219-268: channels for mult = 9
  //
  // second index: kinetic energy
  //
  static const G4double kpnCrossSections[269][30] = {
    //
    // multiplicity 2 (2 channels)
    //
    //  K+ n
    { 4.87, 5.12, 5.38, 5.64, 5.87, 6.00,  6.15, 6.25, 6.40,  6.40,
      6.40, 6.30, 6.20, 5.84, 5.51, 5.196, 5.00, 4.46, 4.00,  3.25,
      2.95, 2.60, 2.20, 2.00, 1.75, 1.65,  1.55, 1.45, 1.405, 1.37},

    //  K0 p
    { 1.10,  1.10,  1.20,  1.49,  2.00,  2.43,  3.00,  3.72,  5.00,  6.356,
      7.493, 8.304, 8.581, 6.829, 5.411, 4.578, 3.81,  2.81,  2.10,  1.37,
      0.91,  0.54,  0.33,  0.193, 0.109, 0.062, 0.037, 0.019, 0.011, 0.007},

    //
    // multiplicity 3 (8 channels)
    //
    //  K+ n pi0
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.036, 
      0.102, 0.249, 0.555, 1.53, 2.27, 2.48, 2.62,  2.82,  2.54,  2.22, 
      1.69,  1.21,  0.96,  0.75, 0.55, 0.41, 0.298, 0.218, 0.17,  0.13}, 

    //  K+ p pi- 
    { 0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,  0.036, 
      0.113, 0.30, 0.71, 2.20, 3.20, 3.50, 3.70,  3.72,  3.38, 3.10,  
      2.38,  1.65, 1.20, 0.93, 0.63, 0.47, 0.378, 0.278, 0.21, 0.16},
                                       
    //  K0 p pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.049,
      0.13, 0.30, 0.64, 1.55, 2.20,  2.35,  2.50,  2.43,  2.15,  1.65, 
      1.03, 0.52, 0.28, 0.15, 0.063, 0.029, 0.014, 0.006, 0.003, 0.001},

    // K0 n pi+
    { 0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.023,
      0.062, 0.147, 0.314, 0.85, 1.40, 1.60, 1.65,  1.55, 1.33, 1.13,
      0.88,  0.68,  0.56,  0.44, 0.33, 0.25, 0.189, 0.14, 0.11, 0.073},

    //  L K+ K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.008, 0.025,
      0.028, 0.027, 0.024, 0.022, 0.017, 0.014, 0.011, 0.010, 0.008, 0.007},

    //  S0 K+ K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.007,
      0.009, 0.009, 0.007, 0.006, 0.005, 0.004, 0.004, 0.003, 0.003, 0.002},    

    //  S+ K0 K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.011,
      0.013, 0.013, 0.012, 0.011, 0.008, 0.007, 0.006, 0.005, 0.004, 0.003},

    //  S- K+ K+
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.007,
      0.009, 0.009, 0.007, 0.006, 0.005, 0.004, 0.004, 0.003, 0.003, 0.002},

    //
    // multiplicity 4 (20 channels)
    //
    //  K+ n 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0005, 0.002, 0.006, 0.08,  0.256, 0.418,
      0.516, 0.510, 0.401, 0.315, 0.233,  0.191, 0.136, 0.098, 0.078, 0.057},
  
    //  K+ n pi+ pi-
    { 0.0,   0.0,  0.0,   0.0,    0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0002, 0.0013, 0.004, 0.013, 0.16,  0.512, 0.838,
      1.031, 1.02, 0.802, 0.629,  0.468,  0.382, 0.273, 0.196, 0.158, 0.115},
 
    //  K+ p pi- pi0
    { 0.0,   0.0,   0.0,   0.0,    0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0003, 0.0017, 0.005, 0.017, 0.205, 0.654, 1.071,
      1.312, 1.305, 1.026, 0.804,  0.598,  0.488, 0.35,  0.251, 0.201, 0.147},

    //  K0 n pi+ pi0
    { 0.0,   0.0,   0.0,   0.0,    0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0003, 0.0017, 0.005, 0.017, 0.205, 0.654, 1.071,
      1.312, 1.305, 1.026, 0.804,  0.598,  0.488, 0.35,  0.251, 0.201, 0.147},

    //  K0 p 2pi0     
    { 0.0,   0.0,   0.0,   0.0,   0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0005, 0.002, 0.006, 0.08,  0.256, 0.418,
      0.516, 0.510, 0.401, 0.315, 0.233,  0.191, 0.136, 0.098, 0.078, 0.057},

    //  K0 p pi+ pi-
    { 0.0,   0.0,   0.0,   0.0,    0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0002, 0.0013, 0.004, 0.013, 0.16,  0.512, 0.838,
      1.031, 1.02,  0.802, 0.629,  0.468,  0.382, 0.273, 0.196, 0.158, 0.115},

    // L K+ K+ pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002,
      0.013, 0.017, 0.017, 0.018, 0.016, 0.015, 0.014, 0.013, 0.012, 0.011},
 
    // L K+ K0 pi0
    { 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.003,
      0.023, 0.03, 0.03, 0.032, 0.028, 0.026, 0.024, 0.022, 0.02, 0.017},

    // L K0 K0 pi+
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002,
      0.013, 0.017, 0.017, 0.018, 0.016, 0.015, 0.014, 0.013, 0.012, 0.011},

    // S+ K+ K0 pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0005, 0.002, 0.004, 0.008, 0.013, 0.017, 0.017, 0.016, 0.014, 0.012},

    // S+ K0 K0 pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.006, 0.008, 0.008, 0.007, 0.006, 0.005},

    // S0 K+ K+ pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0002, 0.001, 0.002, 0.005, 0.006, 0.008, 0.008, 0.007, 0.006, 0.005},

    // S0 K+ K0 pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0006, 0.002, 0.004, 0.009, 0.013, 0.017, 0.017, 0.016, 0.014, 0.012},

    // S0 K0 K0 pi+
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0002, 0.001, 0.002, 0.005, 0.006, 0.008, 0.008, 0.007, 0.006, 0.005},

    // S- K+ K+ pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.004, 0.006, 0.008, 0.008, 0.007, 0.006, 0.005},

    // S- K+ K0 pi+
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0005, 0.002, 0.004, 0.008, 0.013, 0.017, 0.017, 0.016, 0.014, 0.012},

    // n K+ K+ K-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0005, 0.004, 0.010, 0.015, 0.019, 0.020, 0.019, 0.018, 0.015, 0.013},

    // n K+ K0 K0b
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.009, 0.020, 0.030, 0.038, 0.039, 0.038, 0.036, 0.030, 0.025},

    // p K+ K0 K-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.009, 0.020, 0.030, 0.038, 0.039, 0.038, 0.036, 0.030, 0.025},

    // p K0 K0 K0b
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0005, 0.004, 0.010, 0.015, 0.019, 0.020, 0.019, 0.018, 0.015, 0.013},

    //
    // multiplicity 5 (34 channels)
    //
    // K0 n 2pi+ pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,    0.0,    0.0,    0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0002, 0.0004, 0.0006, 0.002, 0.015, 0.072,
      0.222, 0.381, 0.447, 0.459, 0.42,   0.405,  0.351,  0.315, 0.285, 0.264},

    // K0 n pi+ 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,    0.0,    0.0,    0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0002, 0.0004, 0.0006, 0.002, 0.015, 0.072,
      0.222, 0.381, 0.447, 0.459, 0.42,   0.405,  0.351,  0.315, 0.285, 0.264},

    // K+ p pi+ 2pi-
    { 0.0,   0.0,  0.0,   0.0,   0.0,    0.0,    0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0003, 0.0005, 0.001, 0.003, 0.018, 0.084,
      0.33, 0.609, 0.738, 0.702, 0.552,  0.45,   0.333, 0.243, 0.183, 0.138},

    // K+ p pi- 2pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,    0.0,    0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,   0.0,   0.0003, 0.0005, 0.001, 0.003, 0.018, 0.084,
      0.33, 0.609, 0.738, 0.702, 0.552,  0.45,   0.333, 0.243, 0.183, 0.138},

    // K0 p 3pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,    0.0,    0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.0001, 0.0004, 0.001, 0.006, 0.024,
      0.075, 0.126, 0.15, 0.153, 0.141, 0.135,  0.117,  0.105, 0.096, 0.09},

    // K+ n 3pi0
    { 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,    0.0,    0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,  0.0,   0.0,   0.0001, 0.0004, 0.001, 0.006, 0.024,
      0.075, 0.126, 0.15, 0.153, 0.141, 0.135,  0.117,  0.105, 0.096, 0.09},

    // K0 p pi+ pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0005, 0.001, 0.002, 0.004, 0.033, 0.147,
      0.44, 0.765, 0.894, 0.921, 0.843,  0.807, 0.702, 0.633, 0.573, 0.531},

    // K+ n pi+ pi- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,    0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0005, 0.001, 0.002, 0.004, 0.033, 0.147,
      0.44, 0.765, 0.894, 0.921, 0.843,  0.807, 0.702, 0.633, 0.573, 0.531},

    // L K+ K+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.015, 0.028, 0.030, 0.032, 0.026, 0.022, 0.015, 0.012},

    // L K+ K0 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.015, 0.028, 0.030, 0.032, 0.026, 0.022, 0.015, 0.012},

    // L K+ K0 pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.007, 0.036, 0.044, 0.051, 0.046, 0.042, 0.033, 0.028},

    // L K0 K0 pi+ pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.015, 0.028, 0.030, 0.032, 0.026, 0.022, 0.015, 0.012},

    // S+ K+ K+ pi- pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.010, 0.019, 0.020, 0.021, 0.017, 0.015, 0.010, 0.008},

    // S+ K+ K0 pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.010, 0.008, 0.005, 0.004},

    // S+ K0 K0 pi0 pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.010, 0.008, 0.005, 0.004},

    // S+ K0 K0 pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.010, 0.008, 0.005, 0.004},

    // S0 K+ K+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.008, 0.007, 0.007, 0.006, 0.003, 0.003},

    // S0 K+ K0 pi0 pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.008, 0.007, 0.007, 0.006, 0.003, 0.003},

    // S0 K+ K0 pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.009, 0.010, 0.011, 0.010, 0.010, 0.007, 0.006},

    // S0 K0 K0 pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.008, 0.007, 0.007, 0.006, 0.003, 0.003},

    // S- K+ K+ pi0 pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.005, 0.006, 0.005, 0.004, 0.003, 0.002},

    // S- K+ K+ pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.010, 0.010, 0.011, 0.009, 0.007, 0.005, 0.004},

    // S- K+ K0 pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.020, 0.020, 0.022, 0.018, 0.014, 0.010, 0.008},

    // S- K0 K0 pi+ pi+
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.005, 0.006, 0.005, 0.004, 0.003, 0.002},

    // p K+ K+ K- pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.004, 0.017, 0.023, 0.022, 0.020, 0.015, 0.012, 0.010},

    // p K+ K0 K0b pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.009, 0.034, 0.047, 0.045, 0.040, 0.031, 0.025, 0.021},
 
    // p K+ K0 K- pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.009, 0.034, 0.047, 0.045, 0.040, 0.031, 0.025, 0.021},
 
    // p K0 K0 K0b pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.004, 0.017, 0.023, 0.022, 0.020, 0.015, 0.012, 0.010},

    // p K0 K0 K- pi+
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.004, 0.017, 0.023, 0.022, 0.020, 0.015, 0.012, 0.010},

    // n K+ K+ K0b pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.017, 0.023, 0.022, 0.020, 0.015, 0.012, 0.010},
 
    // n K+ K+ K- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.017, 0.023, 0.022, 0.020, 0.015, 0.012, 0.010},
 
    // n K+ K0 K0bar pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.003, 0.009, 0.034, 0.047, 0.045, 0.040, 0.031, 0.025, 0.021},
 
    // n K+ K0 K- pi+
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.003, 0.009, 0.034, 0.047, 0.045, 0.040, 0.031, 0.025, 0.021},

    // n K0 K0 K0b pi+
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.004, 0.017, 0.023, 0.022, 0.020, 0.015, 0.012, 0.010},

    //
    // multiplicity 6 (48 channels)
    //
    // K+ p pi+ 2pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0006, 0.004,
      0.015, 0.091, 0.309, 0.456, 0.621, 0.579, 0.501, 0.455, 0.369,  0.33},

    // K+ n pi+ pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0006, 0.004,
      0.015, 0.091, 0.309, 0.456, 0.621, 0.579, 0.501, 0.455, 0.369,  0.33},

    // K0 p pi+ pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0006, 0.004,
      0.015, 0.091, 0.309, 0.456, 0.621, 0.579, 0.501, 0.455, 0.369,  0.33},

    // K0 n 2pi+ pi- pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0006, 0.004,
      0.015, 0.091, 0.309, 0.456, 0.621, 0.579, 0.501, 0.455, 0.369,  0.33},

    // K0 p 2pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0004, 0.002,
      0.007, 0.046, 0.153, 0.228, 0.309, 0.288, 0.249, 0.227, 0.183,  0.165},

    // K+ n 2pi+ 2pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0004, 0.002,
      0.007, 0.046, 0.153, 0.228, 0.309, 0.288, 0.249, 0.227, 0.183,  0.165},

    // K+ p pi- 3pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0004, 0.001,
      0.005, 0.03, 0.102, 0.153, 0.207, 0.192, 0.168, 0.152, 0.123,  0.111},

    // K0 n pi+ 3pi0
    { 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,    0.0,
      0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0004, 0.001,
      0.005, 0.03, 0.102, 0.153, 0.207, 0.192, 0.168, 0.152, 0.123,  0.111},

    // K0 p 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0005,
      0.001, 0.008, 0.024, 0.039, 0.051, 0.048, 0.042, 0.038, 0.03, 0.027},
 
    // K+ n 4pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0005,
      0.001, 0.008, 0.024, 0.039, 0.051, 0.048, 0.042, 0.038, 0.03, 0.027},

    // L K+ K0 pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.005, 0.010, 0.020, 0.034, 0.046, 0.046, 0.044, 0.042, 0.040},

    // L K+ K+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.005, 0.010, 0.017, 0.023, 0.023, 0.022, 0.021, 0.020},

    // L K+ K+ pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.005, 0.010, 0.017, 0.023, 0.023, 0.022, 0.021, 0.020},

    // L K0 K0 pi+ 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.005, 0.010, 0.017, 0.023, 0.023, 0.022, 0.021, 0.020},

    // L K0 K0 2pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.005, 0.010, 0.017, 0.023, 0.023, 0.022, 0.021, 0.020},

    // L K+ K0 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.003, 0.006, 0.007, 0.008, 0.007, 0.007, 0.006},

    // S+ K+ K0 pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.010, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S+ K+ K0 pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.010, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S+ K0 K0 pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.010, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S+ K+ K+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S+ K0 K0 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // S0 K+ K0 pi+ pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.002, 0.005, 0.010, 0.017, 0.023, 0.023, 0.022, 0.021, 0.020},

    // S0 K+ K+ pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.008, 0.010, 0.011, 0.011, 0.010, 0.010},

    // S0 K+ K+ pi+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.008, 0.010, 0.011, 0.011, 0.010, 0.010},

    // S0 K0 K0 pi+ 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.008, 0.010, 0.011, 0.011, 0.010, 0.010},

    // S0 K0 K0 2pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.008, 0.010, 0.011, 0.011, 0.010, 0.010},

    // S0 K+ K0 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.004, 0.003, 0.003},

    // S- K+ K+ pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.010, 0.013, 0.014, 0.014, 0.013, 0.013},

    // S- K+ K0 pi+ 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.010, 0.013, 0.014, 0.014, 0.013, 0.013},

    // S- K+ K0 2pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.010, 0.013, 0.014, 0.014, 0.013, 0.013},

    // S- K0 K0 2pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S- K+ K+ 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // p K+ K0 K0b pi- pi0
    { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0, 0.01, 0.02, 0.03, 0.034, 0.03, 0.026, 0.022, 0.018},

    // p K+ K0 K- pi+ pi-
    { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0, 0.01, 0.02, 0.03, 0.034, 0.03, 0.026, 0.022, 0.018},

    // p K+ K+ K- pi- pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.014, 0.016, 0.014, 0.012, 0.01, 0.008},

    // p K+ K0 K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.014, 0.016, 0.014, 0.012, 0.01, 0.008},

    // p K0 K0 K0bar pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.014, 0.016, 0.014, 0.012, 0.01, 0.008},
 
    // p K0 K0 K- pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.01, 0.014, 0.016, 0.014, 0.012, 0.01, 0.008},

    // p K+ K+ K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.008, 0.01, 0.008, 0.006, 0.006, 0.004},

    // p K0 K0 K0b 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.008, 0.01, 0.008, 0.006, 0.006, 0.004},

    // n K+ K0 K0b pi+ pi-
    { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   
      0.0, 0.0, 0.01, 0.02, 0.03, 0.034, 0.03, 0.026, 0.022, 0.018},

    // n K+ K0 K- pi+ pi0
    { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,   0.0,   0.0,   
      0.0, 0.0, 0.01, 0.02, 0.03, 0.034, 0.03, 0.026, 0.022, 0.018},

    // n K+ K+ K0bar pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.010, 0.014, 0.016, 0.014, 0.012, 0.010, 0.008},

    // n K+ K+ K- pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.010, 0.014, 0.016, 0.014, 0.012, 0.010, 0.008},

    // n K+ K0 K0bar 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.010, 0.014, 0.016, 0.014, 0.012, 0.010, 0.008},

    // n K0 K0 K0b pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.010, 0.014, 0.016, 0.014, 0.012, 0.010, 0.008},

    // n K+ K+ K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.008, 0.010, 0.008, 0.006, 0.006, 0.004},

    // n K0 K0 K- 2pi+
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.008, 0.010, 0.008, 0.006, 0.006, 0.004},

    //
    // multiplicity 7 (62 channels)
    //
    // K+ p pi+ 2pi- 2pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0003,
      0.0015, 0.015, 0.103, 0.162, 0.269, 0.369, 0.425, 0.468, 0.446, 0.387},

    // K+ n 2pi+ 2pi- pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0003,
      0.0015, 0.015, 0.103, 0.162, 0.269, 0.369, 0.425, 0.468, 0.446, 0.387},

    // K0 p 2pi+ 2pi- pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0003,
      0.0015, 0.015, 0.103, 0.162, 0.269, 0.369, 0.425, 0.468, 0.446, 0.387},

    // K0 n 2pi+ pi- 2pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0003,
      0.0015, 0.015, 0.103, 0.162, 0.269, 0.369, 0.425, 0.468, 0.446, 0.387},

    // K0 p pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0003,
      0.001, 0.009, 0.069, 0.108, 0.177, 0.247, 0.278, 0.312, 0.292, 0.259},

    // K+ n pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0003,
      0.001, 0.009, 0.069, 0.108, 0.177, 0.247, 0.278, 0.312, 0.292, 0.259},

    // K+ p 2pi+ 3pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0001,
      0.0004, 0.005, 0.034, 0.054, 0.088, 0.123, 0.139, 0.155, 0.146, 0.129},

    // K0 n 3pi+ 2pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0001,
      0.0004, 0.005, 0.034, 0.054, 0.088, 0.123, 0.139, 0.155, 0.146, 0.129},

    // K+ p pi- 4pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0001, 0.002, 0.018, 0.027, 0.044, 0.062, 0.069, 0.078, 0.072, 0.065},

    // K0 n pi+ 4pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0001, 0.002, 0.018, 0.027, 0.044, 0.062, 0.069, 0.078, 0.072, 0.065},

    // K0 p 5pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0, 0.004, 0.005, 0.008, 0.012, 0.015, 0.016, 0.016, 0.013},

    // K+ n 5pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0, 0.0, 0.004, 0.005, 0.008, 0.012, 0.015, 0.016, 0.016, 0.013},

    // L K+ K0 pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.007, 0.010, 0.012, 0.017, 0.023, 0.018, 0.016},

    // L K+ K+ pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.008, 0.011, 0.008, 0.007},

    // L K+ K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.008, 0.011, 0.008, 0.007},

    // L K0 K0 2pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.008, 0.011, 0.008, 0.007},

    // L K+ K+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.004, 0.003, 0.003},

    // L K0 K0 pi+ 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.004, 0.003, 0.003},

    // L K+ K0 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S+ K+ K0 pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.007, 0.010, 0.012, 0.017, 0.023, 0.018, 0.016},

    // S+ K0 K0 pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.008, 0.011, 0.008, 0.007},

    // S+ K+ K0 pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.006, 0.008, 0.006, 0.005},

    // S+ K+ K+ 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.006, 0.004, 0.004},

    // S+ K0 K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.006, 0.004, 0.004},

    // S+ K+ K+ pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.004, 0.003, 0.002},

    // S+ K0 K0 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S0 K+ K0 pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.008, 0.011, 0.008, 0.007},

    // S0 K+ K+ pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.003, 0.004, 0.005, 0.004, 0.003},

    // S0 K+ K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.003, 0.004, 0.005, 0.004, 0.003},

    // S0 K0 K0 2pi+ pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.003, 0.004, 0.005, 0.004, 0.003},

    // S0 K+ K+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.004, 0.003, 0.002},

    // S0 K0 K0 pi+ 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.004, 0.003, 0.002},

    // S0 K+ K0 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- K+ K0 2pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.007, 0.010, 0.012, 0.017, 0.023, 0.018, 0.016},

    // S- K+ K+ pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.008, 0.011, 0.008, 0.007},

    // S- K+ K0 pi+ 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.006, 0.008, 0.006, 0.005},

    // S- K+ K+ 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.006, 0.005, 0.004},

    // S- K0 K0 2pi+ 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.006, 0.005, 0.004},

    // S- K0 K0 3pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.003, 0.004, 0.003, 0.003},

    // S- K+ K+ 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // p K+ K0 K- pi+ pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.009, 0.011, 0.013, 0.013, 0.013},

    // n K+ K0 K0b pi+ pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.009, 0.011, 0.013, 0.013, 0.013},

    // p K+ K0 K0b pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.007, 0.006, 0.006},

    // p K+ K0 K0b pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.007, 0.006, 0.006},

    // p K0 K0 K0b pi+ pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.007, 0.006, 0.006},

    // n K+ K+ K- pi+ pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.007, 0.006, 0.006},

    // n K+ K0 K- pi+ 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.007, 0.006, 0.006},

    // n K+ K0 K- 2pi+ pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.007, 0.006, 0.006},

    // p K+ K+ K0bar 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // p K+ K+ K- pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // p K+ K+ K- pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // p K0 K0 K- pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // p K0 K0 K- 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // n K+ K+ K0b pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // n K+ K+ K0b pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // n K0 K0 K0b pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // n K0 K0 K0b 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // n K0 K0 K- 2pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.003, 0.003},

    // p K+ K0 K- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // n K+ K0 K0b 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // p K0 K0 K0bar 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // n K+ K+ K- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    //
    //  multiplicity 8 (45 channels)
    //
    // p K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.006, 0.015, 0.053, 0.12, 0.25, 0.36, 0.495, 0.568},

    // n K+ 2pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.006, 0.015, 0.053, 0.12, 0.25, 0.36, 0.495, 0.568},

    // p K+ pi+ 2pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.001, 0.004, 0.01, 0.035, 0.08, 0.17, 0.24, 0.33, 0.379},

    // p K+ 2pi+ 3pi- pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.001, 0.004, 0.01, 0.035, 0.08, 0.17, 0.24, 0.33, 0.379},

    // n K0 2pi+ pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.001, 0.004, 0.01, 0.035, 0.08, 0.17, 0.24, 0.33, 0.379},

    // n K0 3pi+ 2pi- pi0
    { 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0, 0.001, 0.004, 0.01, 0.035, 0.08, 0.17, 0.24, 0.33, 0.379},

    // p K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.017, 0.04, 0.084, 0.12, 0.165, 0.189},

    // n K+ pi+ pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.017, 0.04, 0.084, 0.12, 0.165, 0.189},

    // p K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.001, 0.003, 0.012, 0.027, 0.056, 0.08, 0.11, 0.126},

    // n K+ 3pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.001, 0.003, 0.012, 0.027, 0.056, 0.08, 0.11, 0.126},

    // p K+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.008, 0.017, 0.024, 0.033, 0.038},

    // n K0 pi+ 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.008, 0.017, 0.024, 0.033, 0.038},

    // p K0 6pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.003, 0.004, 0.005, 0.006},

    // n K+ 6pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.003, 0.004, 0.005, 0.006},

    // L K+ K0 2pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.006, 0.011, 0.018, 0.020, 0.021, 0.024, 0.027},

    // L K+ K0 pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.004, 0.008, 0.012, 0.014, 0.014, 0.017, 0.019},

    // L K+ K+ pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.014},

    // L K0 K0 2pi+ pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.014},

    // L K+ K+ 2pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.004, 0.004},

    // L K0 K0 3pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.004, 0.004},

    // L K+ K+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // L K0 K0 pi+ 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // L K+ K0 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S+ K+ K0 pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.014},

    // S+ K0 K0 2pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.004, 0.005, 0.006, 0.006, 0.007},

    // S+ K+ K+ pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.004},

    // S+ K+ K0 2pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.004},

    // S+ K0 K0 pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.004},

    // S+ K+ K+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S+ K+ K0 pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S+ 2K0 5pi0 negligible

    // S0 K+ K0 2pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.014},

    // S0 K+ K0 pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.006, 0.007, 0.008, 0.008, 0.008},

    // S0 K+ K+ pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.006, 0.007},

    // S0 K0 K0 2pi+ pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.006, 0.007},

    // S0 K+ K+ 2pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // S0 K0 K0 3pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // S0 K+ K+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S0 K0 K0 pi+ 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S0 K+ K0 5pi0 negligible

    // S- K+ K0 2pi+ pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.014},

    // S- K+ K+ 2pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.005, 0.006, 0.006},

    // S- K+ K+ pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.004},

    // S- K+ K0 3pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.004},

    // S- K0 K0 3pi+ pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.004},

    // S- K+ K0 pi+ 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // S- K0 K0 2pi+ 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // S- K+ K+ 5pi0 negligible

    //
    //  mulitplicity 9 (50 channels)
    //
    // p K+ 2pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.002, 0.01, 0.03, 0.073, 0.205, 0.30, 0.42, 0.556},

    // p K0 2pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.002, 0.01, 0.03, 0.073, 0.205, 0.30, 0.42, 0.556},

    // n K+ 2pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.002, 0.01, 0.03, 0.073, 0.205, 0.30, 0.42, 0.556},

    // n K0 3pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.002, 0.01, 0.03, 0.073, 0.205, 0.30, 0.42, 0.556},

    // p K0 3pi+ 3pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.001, 0.007, 0.02, 0.048, 0.137, 0.20, 0.284, 0.368},

    // n K+ 3pi+ 3pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.007, 0.02, 0.048, 0.137, 0.20, 0.284, 0.368},

    // p K+ pi+ 2pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.001, 0.005, 0.015, 0.036, 0.102, 0.15, 0.21, 0.284},

    // n K0 2pi+ pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.001, 0.005, 0.015, 0.036, 0.102, 0.15, 0.21, 0.284},

    // p K+ 3pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.012, 0.034, 0.050, 0.074, 0.093},

    // n K0 4pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.012, 0.034, 0.050, 0.074, 0.093},

    // p K0 pi+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.006, 0.015, 0.041, 0.06, 0.084, 0.116},

    // n K+ pi+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.006, 0.015, 0.041, 0.06, 0.084, 0.116},

    // p K+ pi- 6pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.007, 0.010, 0.014, 0.021},

    // n K0 pi+ 6pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.007, 0.010, 0.014, 0.021},

    // p K0 7pi0, n K+ 7pi0 are negligible

    // L K+ K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.010, 0.022, 0.032, 0.044, 0.060, 0.069, 0.075},

    // L K+ K+ pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.005, 0.011, 0.016, 0.022, 0.030, 0.035, 0.037},

    // L K+ K+ 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.005, 0.011, 0.016, 0.022, 0.030, 0.035, 0.037},

    // L K+ K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.005, 0.011, 0.016, 0.022, 0.030, 0.035, 0.037},

    // L K0 K0 2pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.005, 0.011, 0.016, 0.022, 0.030, 0.035, 0.037},

    // L K0 K0 3pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.005, 0.011, 0.016, 0.022, 0.030, 0.035, 0.037},

    // L K+ K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.007, 0.010, 0.014, 0.020, 0.023, 0.025},

    // L K+ K+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.003, 0.004},

    // L K0 K0 pi+ 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.003, 0.004},

    // L K+ K0 6pi0 negligible

    // S+ K+ K0 pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.002, 0.004, 0.008, 0.010, 0.013, 0.016},

    // S+ K+ K0 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.002, 0.004, 0.008, 0.010, 0.013, 0.016},

    // S+ K0 K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.002, 0.003, 0.006, 0.008, 0.009, 0.010},

    // S+ K+ K+ pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007},

    // S+ K0 K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004},

    // S+ K0 K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S+ K+ K+ 2pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002},

    // S+ K+ K+ 2pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002},

    // S+ K+ K0 pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S0 K+ K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.006, 0.012, 0.015, 0.019, 0.022},

    // S0 K+ K+ pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007},

    // S0 K+ K+ 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007},

    // S0 K+ K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007},

    // S0 K0 K0 2pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007},

    // S0 K0 K0 3pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.006, 0.007},

    // S0 K+ K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.003, 0.003, 0.004, 0.005},

    // S0 K+ K+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001},

    // S0 K0 K0 pi+ 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001},

    // S0 K+ K0 6pi0 negligible

    // S- K+ K0 2pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.008, 0.011, 0.014, 0.017, 0.019},

    // S- K+ K0 3pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.008, 0.011, 0.014, 0.017, 0.019},

    // S- K+ K+ 2pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.004, 0.006, 0.008, 0.011, 0.013, 0.015},

    // S- K0 K0 3pi+ pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.008, 0.009},

    // S- K+ K+ pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.005},

    // S- K+ K+ 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // S- K0 K0 2pi+ 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S- K0 K0 4pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S- K+ K0 pi+ 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002},
 };
}

const G4CascadeKplusNChannelData::data_t
G4CascadeKplusNChannelData::data(kpn2bfs, kpn3bfs, kpn4bfs, kpn5bfs,
                                 kpn6bfs, kpn7bfs, kpn8bfs, kpn9bfs,
				 kpnCrossSections, kpl*neu, "KplusN");
